/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.guisystem;

import com.teamacronymcoders.base.guisystem.IHasGui;
import com.teamacronymcoders.base.multiblock.MultiblockTileEntityBase;
import com.teamacronymcoders.base.util.ItemStackUtils;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public enum GuiCarrier {
    ENTITY{

        @Override
        public IHasGui getHasGUI(EntityPlayer player, World world, BlockPos blockPos) {
            IHasGui hasGui = null;
            Entity entity = world.func_73045_a(blockPos.func_177958_n());
            if (entity instanceof IHasGui) {
                hasGui = (IHasGui)entity;
            }
            return hasGui;
        }
    }
    ,
    BLOCK{

        @Override
        public IHasGui getHasGUI(EntityPlayer player, World world, BlockPos blockPos) {
            IHasGui hasGui = null;
            Block block = world.func_180495_p(blockPos).func_177230_c();
            if (block instanceof IHasGui) {
                hasGui = (IHasGui)block;
            }
            return hasGui;
        }
    }
    ,
    TILE_ENTITY{

        @Override
        public IHasGui getHasGUI(EntityPlayer player, World world, BlockPos blockPos) {
            IHasGui hasGui = null;
            TileEntity tileEntity = world.func_175625_s(blockPos);
            if (tileEntity instanceof IHasGui) {
                hasGui = (IHasGui)tileEntity;
            }
            return hasGui;
        }
    }
    ,
    MULTIBLOCK{

        @Override
        public IHasGui getHasGUI(EntityPlayer player, World world, BlockPos blockPos) {
            MultiblockTileEntityBase multiblockTileEntity;
            IHasGui hasGui = null;
            TileEntity tileEntity = world.func_175625_s(blockPos);
            if (tileEntity instanceof MultiblockTileEntityBase && (multiblockTileEntity = (MultiblockTileEntityBase)tileEntity).getMultiblockController() instanceof IHasGui) {
                hasGui = (IHasGui)multiblockTileEntity.getMultiblockController();
            }
            return hasGui;
        }
    }
    ,
    ITEMSTACK{

        @Override
        public IHasGui getHasGUI(EntityPlayer player, World world, BlockPos blockPos) {
            IHasGui hasGui = null;
            ItemStack itemStack = player.func_184586_b(EnumHand.values()[blockPos.func_177958_n()]);
            if (ItemStackUtils.isItemInstanceOf(itemStack, IHasGui.class)) {
                hasGui = (IHasGui)itemStack.func_77973_b();
            }
            return hasGui;
        }
    };


    @Nullable
    public abstract IHasGui getHasGUI(EntityPlayer var1, World var2, BlockPos var3);
}

