/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.recipesystem.input;

import com.teamacronymcoders.base.recipesystem.RecipeContainer;
import com.teamacronymcoders.base.recipesystem.input.IInput;
import com.teamacronymcoders.base.util.CapUtils;
import net.minecraftforge.energy.CapabilityEnergy;

public class ForgeEnergyInput
implements IInput {
    private final int amountRequired;

    public ForgeEnergyInput(int amountRequired) {
        this.amountRequired = amountRequired;
    }

    @Override
    public boolean isMatched(RecipeContainer recipeContainer) {
        return CapUtils.getOptional(recipeContainer, CapabilityEnergy.ENERGY).map(energyStorage -> energyStorage.extractEnergy(this.amountRequired, true) == this.amountRequired).orElse(false);
    }

    @Override
    public void consume(RecipeContainer recipeContainer) {
        CapUtils.getOptional(recipeContainer, CapabilityEnergy.ENERGY).ifPresent(energyStorage -> energyStorage.extractEnergy(this.amountRequired, false));
    }
}

