/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium;

import com.hrznstudio.titanium.TitaniumClient;
import com.hrznstudio.titanium._impl.creative.CreativeFEGeneratorBlock;
import com.hrznstudio.titanium._impl.test.AssetTestBlock;
import com.hrznstudio.titanium._impl.test.MachineTestBlock;
import com.hrznstudio.titanium._impl.test.TestBlock;
import com.hrznstudio.titanium._impl.test.TwentyFourTestBlock;
import com.hrznstudio.titanium._impl.test.recipe.TestSerializableRecipe;
import com.hrznstudio.titanium.annotation.plugin.FeaturePlugin;
import com.hrznstudio.titanium.capability.CapabilityItemStackHolder;
import com.hrznstudio.titanium.client.screen.container.BasicAddonScreen;
import com.hrznstudio.titanium.command.RewardCommand;
import com.hrznstudio.titanium.command.RewardGrantCommand;
import com.hrznstudio.titanium.container.BasicAddonContainer;
import com.hrznstudio.titanium.event.handler.EventManager;
import com.hrznstudio.titanium.material.ResourceRegistry;
import com.hrznstudio.titanium.module.Feature;
import com.hrznstudio.titanium.module.Module;
import com.hrznstudio.titanium.module.ModuleController;
import com.hrznstudio.titanium.network.NetworkHandler;
import com.hrznstudio.titanium.network.locator.LocatorTypes;
import com.hrznstudio.titanium.network.messages.ButtonClickNetworkMessage;
import com.hrznstudio.titanium.plugin.PluginManager;
import com.hrznstudio.titanium.recipe.condition.ContentExistsConditionSerializer;
import com.hrznstudio.titanium.recipe.generator.BlockItemModelGeneratorProvider;
import com.hrznstudio.titanium.recipe.generator.titanium.DefaultLootTableProvider;
import com.hrznstudio.titanium.recipe.generator.titanium.JsonRecipeSerializerProvider;
import com.hrznstudio.titanium.recipe.generator.titanium.ResourceRegistryProvider;
import com.hrznstudio.titanium.recipe.shapelessenchant.ShapelessEnchantSerializer;
import com.hrznstudio.titanium.reward.Reward;
import com.hrznstudio.titanium.reward.RewardManager;
import com.hrznstudio.titanium.reward.RewardSyncMessage;
import com.hrznstudio.titanium.reward.storage.RewardWorldStorage;
import com.hrznstudio.titanium.util.SidedHandler;
import com.mojang.brigadier.CommandDispatcher;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.command.CommandSource;
import net.minecraft.data.IDataProvider;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.DrawHighlightEvent;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="titanium")
public class Titanium
extends ModuleController {
    public static final String MODID = "titanium";
    public static final Logger LOGGER = LogManager.getLogger((String)"titanium");
    public static NetworkHandler NETWORK = new NetworkHandler("titanium");
    public static final PluginManager RESOURCES = new PluginManager("titanium", FeaturePlugin.FeaturePluginType.FEATURE, featurePlugin -> featurePlugin.value().equalsIgnoreCase("resources"), false);

    public Titanium() {
        NETWORK.registerMessage(ButtonClickNetworkMessage.class);
        NETWORK.registerMessage(RewardSyncMessage.class);
        SidedHandler.runOn(Dist.CLIENT, () -> () -> EventManager.mod(FMLClientSetupEvent.class).process(this::clientSetup).subscribe());
        EventManager.mod(FMLCommonSetupEvent.class).process(this::commonSetup).subscribe();
        EventManager.forge(PlayerEvent.PlayerLoggedInEvent.class).process(this::onPlayerLoggedIn).subscribe();
        EventManager.forge(FMLServerStartingEvent.class).process(this::onServerStart).subscribe();
        CraftingHelper.register((IConditionSerializer)new ContentExistsConditionSerializer());
    }

    @Override
    public void onPreInit() {
        super.onPreInit();
    }

    @Override
    public void onInit() {
        ResourceRegistry.onInit();
        super.onInit();
    }

    @Override
    protected void initModules() {
        this.addModule(Module.builder("core").force().feature((Feature.Builder)((Feature.Builder)Feature.builder("core").force().content(ContainerType.class, (IForgeRegistryEntry)((ContainerType)IForgeContainerType.create(BasicAddonContainer::create).setRegistryName(new ResourceLocation(MODID, "addon_container"))))).content(IRecipeSerializer.class, (IForgeRegistryEntry)((IRecipeSerializer)new ShapelessEnchantSerializer().setRegistryName(new ResourceLocation(MODID, "shapeless_enchant"))))));
        TestBlock.TEST = new TestBlock();
        TwentyFourTestBlock.TEST = new TwentyFourTestBlock();
        AssetTestBlock.TEST = new AssetTestBlock();
        MachineTestBlock.TEST = new MachineTestBlock();
        this.addModule(Module.builder("test_module").disableByDefault().description("Test module for titanium features").feature((Feature.Builder)((Feature.Builder)((Feature.Builder)((Feature.Builder)Feature.builder("blocks").description("Adds test titanium blocks").content(Block.class, (IForgeRegistryEntry)TestBlock.TEST)).content(Block.class, (IForgeRegistryEntry)TwentyFourTestBlock.TEST)).content(Block.class, (IForgeRegistryEntry)AssetTestBlock.TEST)).content(Block.class, (IForgeRegistryEntry)MachineTestBlock.TEST)).feature(Feature.builder("events").description("Adds test titanium events").event(EventManager.forge(EntityItemPickupEvent.class).filter(ev -> ev.getItem().func_92059_d().func_77973_b() == Items.field_151055_y).process(ev -> {
            ev.getItem().lifespan = 0;
        }).cancel())).feature(((Feature.Builder)Feature.builder("recipe").description("Testing of recipe stuff").content(IRecipeSerializer.class, (IForgeRegistryEntry)TestSerializableRecipe.SERIALIZER)).event(EventManager.mod(FMLCommonSetupEvent.class).process(event -> {
            IRecipeType cfr_ignored_0 = (IRecipeType)Registry.func_218322_a((Registry)Registry.field_218367_H, (ResourceLocation)TestSerializableRecipe.SERIALIZER.getRegistryName(), TestSerializableRecipe.SERIALIZER.getRecipeType());
        })).event(EventManager.forge(PlayerInteractEvent.LeftClickBlock.class).filter(leftClickBlock -> !leftClickBlock.getWorld().field_72995_K && leftClickBlock.getPlayer() != null).process(leftClickBlock -> {
            Map recipes = (Map)ObfuscationReflectionHelper.getPrivateValue(RecipeManager.class, (Object)leftClickBlock.getWorld().func_199532_z(), (String)"field_199522_d");
            ((Map)recipes.get(TestSerializableRecipe.SERIALIZER.getRecipeType())).values().stream().map(iRecipe -> (TestSerializableRecipe)iRecipe).filter(testSerializableRecipe -> testSerializableRecipe.isValid(leftClickBlock.getPlayer().func_184586_b(leftClickBlock.getHand()), leftClickBlock.getWorld().func_180495_p(leftClickBlock.getPos()).func_177230_c())).findFirst().ifPresent(testSerializableRecipe -> {
                leftClickBlock.getPlayer().func_184586_b(leftClickBlock.getHand()).func_190918_g(1);
                ItemHandlerHelper.giveItemToPlayer((PlayerEntity)leftClickBlock.getPlayer(), (ItemStack)testSerializableRecipe.func_77571_b().func_77946_l());
                leftClickBlock.setCanceled(true);
            });
        }))));
        this.addModule(Module.builder("creative").disableByDefault().description("Creative features").feature((Feature.Builder)Feature.builder("blocks").description("Adds creative machine features").content(Block.class, (IForgeRegistryEntry)CreativeFEGeneratorBlock.INSTANCE)));
        ResourceRegistry.initModules(this);
    }

    @Override
    public void onPostInit() {
        super.onPostInit();
        ResourceRegistry.onPostInit();
    }

    @Override
    public void addDataProvider(GatherDataEvent event) {
        event.getGenerator().func_200390_a((IDataProvider)new BlockItemModelGeneratorProvider(event.getGenerator(), MODID));
        event.getGenerator().func_200390_a((IDataProvider)new DefaultLootTableProvider(event.getGenerator(), MODID));
        event.getGenerator().func_200390_a((IDataProvider)new JsonRecipeSerializerProvider(event.getGenerator(), MODID));
        event.getGenerator().func_200390_a((IDataProvider)new ResourceRegistryProvider(event.getGenerator()));
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        CapabilityItemStackHolder.register();
        RewardManager.get().getRewards().values().forEach(rewardGiver -> rewardGiver.getRewards().forEach(reward -> reward.register(Dist.DEDICATED_SERVER)));
        LocatorTypes.register();
    }

    @OnlyIn(value=Dist.CLIENT)
    private void clientSetup(FMLClientSetupEvent event) {
        EventManager.forge(DrawHighlightEvent.HighlightBlock.class).process(TitaniumClient::blockOverlayEvent).subscribe();
        TitaniumClient.registerModelLoader();
        RewardManager.get().getRewards().values().forEach(rewardGiver -> rewardGiver.getRewards().forEach(reward -> reward.register(Dist.CLIENT)));
        ScreenManager.func_216911_a(BasicAddonContainer.TYPE, BasicAddonScreen::new);
    }

    private void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        event.getPlayer().func_184102_h().execute(() -> {
            RewardWorldStorage storage = RewardWorldStorage.get(event.getPlayer().func_184102_h().func_71218_a(DimensionType.field_223227_a_));
            if (!storage.getConfiguredPlayers().contains(event.getPlayer().func_110124_au())) {
                for (ResourceLocation collectRewardsResourceLocation : RewardManager.get().collectRewardsResourceLocations(event.getPlayer().func_110124_au())) {
                    Reward reward = RewardManager.get().getReward(collectRewardsResourceLocation);
                    storage.add(event.getPlayer().func_110124_au(), reward.getResourceLocation(), reward.getOptions()[0]);
                }
                storage.getConfiguredPlayers().add(event.getPlayer().func_110124_au());
                storage.func_76185_a();
            }
            CompoundNBT nbt = storage.serializeSimple();
            event.getPlayer().func_184102_h().func_184103_al().func_181057_v().forEach(serverPlayerEntity -> NETWORK.get().sendTo((Object)new RewardSyncMessage(nbt), serverPlayerEntity.field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT));
        });
    }

    private void onServerStart(FMLServerStartingEvent event) {
        RewardCommand.register((CommandDispatcher<CommandSource>)event.getCommandDispatcher());
        RewardGrantCommand.register((CommandDispatcher<CommandSource>)event.getCommandDispatcher());
    }
}

