/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.api.cargo;

import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.IItemProvider;
import xyz.brassgoggledcoders.transport.api.TransportObjects;
import xyz.brassgoggledcoders.transport.api.cargo.CargoModuleInstance;
import xyz.brassgoggledcoders.transport.api.entity.IModularEntity;
import xyz.brassgoggledcoders.transport.api.module.Module;

public class CargoModule
extends Module<CargoModule> {
    private final Supplier<? extends Block> blockSupplier;
    private BlockState blockState;

    public CargoModule(Supplier<? extends Block> blockSupplier) {
        this(blockSupplier, (BiFunction<CargoModule, IModularEntity, ? extends CargoModuleInstance>)((BiFunction<CargoModule, IModularEntity, CargoModuleInstance>)CargoModuleInstance::new));
    }

    public CargoModule(Supplier<? extends Block> blockSupplier, BiFunction<CargoModule, IModularEntity, ? extends CargoModuleInstance> cargoInstanceCreator) {
        super(TransportObjects.CARGO_TYPE, cargoInstanceCreator);
        this.blockSupplier = blockSupplier;
    }

    @Nonnull
    public BlockState getDefaultBlockState() {
        if (this.blockState == null) {
            this.blockState = this.blockSupplier.get().func_176223_P();
        }
        return this.blockState;
    }

    public boolean isEmpty() {
        return false;
    }

    public ItemStack createItemStack(Item item) {
        return this.createItemStack(item, null);
    }

    public ItemStack createItemStack(Item item, @Nullable CargoModuleInstance cargoModuleInstance) {
        ItemStack itemStack = new ItemStack((IItemProvider)item);
        CompoundNBT cargoNBT = itemStack.func_190925_c("cargo");
        cargoNBT.func_74778_a("name", String.valueOf(this.getRegistryName()));
        if (cargoModuleInstance != null) {
            cargoNBT.func_218657_a("instance", (INBT)cargoModuleInstance.serializeNBT());
        }
        return itemStack;
    }

    @Nonnull
    public Item func_199767_j() {
        return this.getDefaultBlockState().func_177230_c().func_199767_j();
    }
}

