/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.api.module;

import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ForgeRegistryEntry;
import xyz.brassgoggledcoders.transport.api.TransportAPI;
import xyz.brassgoggledcoders.transport.api.entity.IModularEntity;
import xyz.brassgoggledcoders.transport.api.module.ModuleInstance;
import xyz.brassgoggledcoders.transport.api.module.ModuleType;

public abstract class Module<MOD extends Module<MOD>>
extends ForgeRegistryEntry<MOD>
implements IItemProvider {
    private final BiFunction<MOD, IModularEntity, ? extends ModuleInstance<MOD>> instanceCreator;
    private final Supplier<ModuleType<MOD>> componentType;
    private String translationKey;
    private ITextComponent name;

    public Module(Supplier<ModuleType<MOD>> componentType, BiFunction<MOD, IModularEntity, ? extends ModuleInstance<MOD>> instanceCreator) {
        this.componentType = componentType;
        this.instanceCreator = instanceCreator;
    }

    @Nonnull
    public String getTranslationKey() {
        if (this.translationKey == null) {
            this.translationKey = Util.func_200697_a((String)this.componentType.get().getName(), (ResourceLocation)this.getRegistryName());
        }
        return this.translationKey;
    }

    @Nonnull
    public ITextComponent getDisplayName() {
        if (this.name == null) {
            this.name = new TranslationTextComponent(this.getTranslationKey(), new Object[0]);
        }
        return this.name;
    }

    public boolean isValidFor(IModularEntity modularEntity) {
        return true;
    }

    public ModuleType<MOD> getType() {
        return this.componentType.get();
    }

    @Nonnull
    public ModuleInstance<MOD> createInstance(IModularEntity carrier) {
        return this.instanceCreator.apply((MOD)((Object)this), carrier);
    }

    @Nullable
    public static Module<?> fromPacketBuffer(PacketBuffer packetBuffer) {
        ModuleType<?> moduleType = TransportAPI.getModuleType(packetBuffer.func_192575_l());
        if (moduleType != null) {
            return (Module)((Object)moduleType.load(packetBuffer.func_192575_l()));
        }
        return null;
    }

    public static void toPacketBuffer(Module<?> module, PacketBuffer packetBuffer) {
        packetBuffer.func_192572_a(Objects.requireNonNull(module.getType().getRegistryName()));
        packetBuffer.func_192572_a(Objects.requireNonNull(module.getRegistryName()));
    }

    public static Module<?> fromCompoundNBT(CompoundNBT compoundNBT) {
        ModuleType<?> moduleType = TransportAPI.getModuleType(compoundNBT.func_74779_i("type"));
        if (moduleType != null) {
            return (Module)((Object)moduleType.load(compoundNBT.func_74779_i("module")));
        }
        return null;
    }

    public static void toCompoundNBT(Module<?> module, CompoundNBT compoundNBT) {
        compoundNBT.func_74778_a("type", String.valueOf(module.getType().getRegistryName()));
        compoundNBT.func_74778_a("module", String.valueOf(module.getRegistryName()));
    }
}

