/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.block;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import xyz.brassgoggledcoders.transport.tileentity.ModuleConfiguratorTileEntity;

public class ModuleConfiguratorBlock
extends Block {
    public static final EnumProperty<Direction> FACING = BlockStateProperties.field_208157_J;
    private static final VoxelShape SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);

    public ModuleConfiguratorBlock() {
        this(Block.Properties.func_200945_a((Material)Material.field_151573_f).harvestTool(ToolType.PICKAXE).func_226896_b_());
    }

    public ModuleConfiguratorBlock(Block.Properties properties) {
        super(properties);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING});
    }

    @Nullable
    public BlockState func_196258_a(@Nonnull BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a(FACING, (Comparable)context.func_195992_f());
    }

    public BlockState rotate(BlockState state, IWorld world, BlockPos pos, Rotation direction) {
        return (BlockState)state.func_206870_a(FACING, (Comparable)direction.func_185831_a((Direction)state.func_177229_b(FACING)));
    }

    public boolean hasTileEntity(BlockState blockState) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new ModuleConfiguratorTileEntity();
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult blockRayTraceResult) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof ModuleConfiguratorTileEntity) {
            return ((ModuleConfiguratorTileEntity)tileEntity).openScreen(player);
        }
        return ActionResultType.PASS;
    }
}

