/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.block.rail;

import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xyz.brassgoggledcoders.transport.block.rail.HoldingRailBlock;
import xyz.brassgoggledcoders.transport.tileentity.rail.TimedHoldingRailTileEntity;
import xyz.brassgoggledcoders.transport.util.RailUtils;

public class TimedHoldingRailBlock
extends HoldingRailBlock {
    public static IntegerProperty DELAY = BlockStateProperties.field_208126_aa;

    public TimedHoldingRailBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((IProperty)DELAY, (Comparable)Integer.valueOf(1)));
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{DELAY});
    }

    @Override
    @Nonnull
    @ParametersAreNonnullByDefault
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
        ActionResultType actionResultType = super.func_225533_a_(state, world, pos, player, hand, rayTraceResult);
        if (actionResultType == ActionResultType.PASS) {
            world.func_175656_a(pos, (BlockState)state.func_177231_a((IProperty)DELAY));
            return ActionResultType.SUCCESS;
        }
        return actionResultType;
    }

    @Override
    @ParametersAreNonnullByDefault
    public void onMinecartPass(BlockState state, World world, BlockPos pos, AbstractMinecartEntity cart) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TimedHoldingRailTileEntity) {
            ((TimedHoldingRailTileEntity)tileEntity).onMinecartPass(cart);
        }
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TimedHoldingRailTileEntity();
    }

    @OnlyIn(value=Dist.CLIENT)
    @ParametersAreNonnullByDefault
    public void func_180655_c(BlockState blockState, World world, BlockPos pos, Random rand) {
        if (((Boolean)blockState.func_177229_b((IProperty)POWERED)).booleanValue() && rand.nextBoolean()) {
            Direction direction = RailUtils.getFacingFromBlockState(blockState).func_176734_d();
            double d0 = (double)pos.func_177958_n() + 0.5 + (rand.nextDouble() - 0.5) * 0.2;
            double d1 = (double)pos.func_177956_o() + 0.4 + (rand.nextDouble() - 0.5) * 0.2;
            double d2 = (double)pos.func_177952_p() + 0.5 + (rand.nextDouble() - 0.5) * 0.2;
            float f = (Integer)blockState.func_177229_b((IProperty)DELAY) * 2 - 1;
            double d3 = (f /= 16.0f) * (float)direction.func_82601_c();
            double d4 = f * (float)direction.func_82599_e();
            world.func_195594_a((IParticleData)RedstoneParticleData.field_197564_a, d0 + d3, d1, d2 + d4, 0.0, 0.0, 0.0);
        }
    }
}

