/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.capability.itemhandler;

import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;
import xyz.brassgoggledcoders.transport.api.TransportAPI;
import xyz.brassgoggledcoders.transport.api.entity.IModularEntity;
import xyz.brassgoggledcoders.transport.api.module.Module;
import xyz.brassgoggledcoders.transport.api.module.ModuleInstance;
import xyz.brassgoggledcoders.transport.api.module.ModuleSlot;
import xyz.brassgoggledcoders.transport.content.TransportModuleSlots;

public class ModuleCaseItemStackHandler
implements IItemHandlerModifiable {
    private final Supplier<LazyOptional<IModularEntity>> modularEntity;
    private final Consumer<Void> onUpdate;

    public ModuleCaseItemStackHandler(Supplier<LazyOptional<IModularEntity>> modularEntity, Consumer<Void> onUpdate) {
        this.modularEntity = modularEntity;
        this.onUpdate = onUpdate;
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        LazyOptional<IModularEntity> entity = this.modularEntity.get();
        entity.ifPresent(value -> {
            ModuleSlot moduleSlot = this.getModuleSlot(entity, slot);
            if (!stack.func_190926_b()) {
                Module<?> module = TransportAPI.getModuleFromItem(stack.func_77973_b());
                if (module != null) {
                    value.remove(moduleSlot, false);
                    value.add(module, moduleSlot, false);
                }
            } else {
                value.remove(moduleSlot, false);
            }
            this.onUpdate.accept(null);
        });
    }

    @Nonnull
    public ModuleSlot getModuleSlot(int slot) {
        return this.getModuleSlot(this.modularEntity.get(), slot);
    }

    @Nonnull
    private ModuleSlot getModuleSlot(LazyOptional<IModularEntity> entity, int slot) {
        return (ModuleSlot)((Object)entity.map(IModularEntity::getModuleSlots).filter(moduleSlots -> slot >= 0 && slot < moduleSlots.size()).map(moduleSlots -> (ModuleSlot)((Object)((Object)moduleSlots.get(slot)))).orElseGet(() -> TransportModuleSlots.NONE.get()));
    }

    public int getSlots() {
        return 9;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        ModuleSlot moduleSlot = this.getModuleSlot(this.modularEntity.get(), slot);
        return (ItemStack)this.modularEntity.get().map(value -> {
            ModuleInstance<?> moduleInstance = value.getModuleInstance(moduleSlot);
            if (moduleInstance != null) {
                return moduleInstance.asItemStack();
            }
            return ItemStack.field_190927_a;
        }).orElse((Object)ItemStack.field_190927_a);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        ModuleSlot moduleSlot = this.getModuleSlot(this.modularEntity.get(), slot);
        return (ItemStack)this.modularEntity.get().filter(value -> this.isItemValid(slot, stack)).filter(value -> value.getModuleInstance(moduleSlot) == null).map(value -> {
            ItemStack newStack = stack.func_77946_l();
            newStack.func_190918_g(1);
            if (!simulate) {
                Module<?> module = TransportAPI.getModuleFromItem(stack.func_77973_b());
                value.add(module, moduleSlot, false);
                this.onUpdate.accept(null);
            }
            return newStack;
        }).orElse((Object)stack);
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ModuleSlot moduleSlot = this.getModuleSlot(this.modularEntity.get(), slot);
        return (ItemStack)this.modularEntity.get().map(value -> {
            ModuleInstance<?> moduleInstance = value.getModuleInstance(moduleSlot);
            if (moduleInstance != null) {
                ItemStack itemStack = moduleInstance.asItemStack();
                if (!simulate) {
                    value.remove(moduleSlot, false);
                    this.onUpdate.accept(null);
                }
                return itemStack;
            }
            return ItemStack.field_190927_a;
        }).orElse((Object)ItemStack.field_190927_a);
    }

    public int getSlotLimit(int slot) {
        return 1;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        if (!stack.func_190926_b()) {
            Module<?> module = TransportAPI.getModuleFromItem(stack.func_77973_b());
            ModuleSlot moduleSlot = this.getModuleSlot(this.modularEntity.get(), slot);
            if (module != null) {
                return (Boolean)this.modularEntity.get().map(value -> value.canEquip(module) && module.isValidFor((IModularEntity)value) && moduleSlot.isModuleValid((IModularEntity)value, module)).orElse((Object)false);
            }
        }
        return false;
    }
}

