/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.tileentity.loader;

import com.google.common.collect.Maps;
import com.hrznstudio.titanium.api.client.IScreenAddonProvider;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.container.addon.IContainerAddonProvider;
import com.hrznstudio.titanium.network.locator.LocatorFactory;
import com.hrznstudio.titanium.network.locator.LocatorInstance;
import com.hrznstudio.titanium.network.locator.instance.TileEntityLocatorInstance;
import java.util.EnumMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkHooks;
import xyz.brassgoggledcoders.transport.block.loader.LoadType;
import xyz.brassgoggledcoders.transport.block.loader.LoaderBlock;
import xyz.brassgoggledcoders.transport.container.LoaderContainerProvider;

public abstract class BasicLoaderTileEntity<CAP>
extends TileEntity
implements ITickableTileEntity,
IComponentHarness,
IScreenAddonProvider,
IContainerAddonProvider {
    private final Capability<CAP> capability;
    private final EnumMap<Direction, LazyOptional<CAP>> lazyOptionals;
    private int run = 20;

    public <T extends BasicLoaderTileEntity<CAP>> BasicLoaderTileEntity(TileEntityType<T> tileEntityType, Capability<CAP> capability) {
        super(tileEntityType);
        this.capability = capability;
        this.lazyOptionals = Maps.newEnumMap(Direction.class);
    }

    public void func_73660_a() {
        if (this.func_145831_w() != null && !this.func_145831_w().func_201670_d()) {
            if (this.run >= 0) {
                --this.run;
            } else {
                this.doWork();
                this.run = 15 + this.func_145831_w().func_201674_k().nextInt(10);
            }
        }
    }

    @Nonnull
    public World getTheWorld() {
        return Objects.requireNonNull(this.func_145831_w());
    }

    private void doWork() {
        AxisAlignedBB axisAlignedBB = new AxisAlignedBB(this.func_174877_v()).func_186662_g(1.0);
        List entities = this.getTheWorld().func_175674_a(null, axisAlignedBB, Entity::func_70089_S);
        for (Direction side : Direction.values()) {
            BlockPos neighborPos = this.func_174877_v().func_177967_a(side, 1);
            LoadType loadType = (LoadType)((Object)this.func_195044_w().func_177229_b((IProperty)LoaderBlock.PROPERTIES.get(side)));
            if (loadType == LoadType.NONE) continue;
            this.doWorkOnSide(loadType, side, neighborPos, entities.stream().filter(entity -> entity.func_180425_c().equals((Object)neighborPos)));
        }
    }

    private void doWorkOnSide(LoadType loadType, Direction side, BlockPos neighborPos, Stream<Entity> entitiesOnSide) {
        this.getNeighborCap(side, neighborPos, entitiesOnSide).ifPresent(cap -> this.handleNeighborCap(loadType, cap));
    }

    private void handleNeighborCap(LoadType loadType, CAP cap) {
        if (loadType == LoadType.INPUT) {
            this.getInternalCAP().ifPresent(internal -> this.transfer(cap, internal));
        } else if (loadType == LoadType.OUTPUT) {
            this.getInternalCAP().ifPresent(internal -> this.transfer(internal, cap));
        }
    }

    protected abstract void transfer(CAP var1, CAP var2);

    private LazyOptional<CAP> getNeighborCap(Direction side, BlockPos neighborPos, Stream<Entity> entitiesOnSide) {
        Optional<Entity> entity = entitiesOnSide.findAny();
        LazyOptional capLazyOptional = entity.isPresent() ? entity.map(value -> value.getCapability(this.capability, side.func_176734_d())).orElseGet(LazyOptional::empty) : Optional.ofNullable(this.getTheWorld().func_175625_s(neighborPos)).map(tileEntity -> tileEntity.getCapability(this.capability, side.func_176734_d())).orElseGet(LazyOptional::empty);
        return capLazyOptional;
    }

    public void updateSide(Direction direction) {
        LazyOptional<CAP> existing = this.lazyOptionals.put(direction, this.getNewCAPForSide(direction));
        if (existing != null && existing.isPresent()) {
            existing.invalidate();
        }
    }

    private LazyOptional<CAP> getNewCAPForSide(Direction direction) {
        LoadType loadType = (LoadType)((Object)this.func_195044_w().func_177229_b((IProperty)LoaderBlock.PROPERTIES.get(direction)));
        switch (loadType) {
            case NONE: {
                return LazyOptional.empty();
            }
            case INPUT: {
                return this.createInputCAP();
            }
            case OUTPUT: {
                return this.createOutputCAP();
            }
        }
        return LazyOptional.empty();
    }

    public World getComponentWorld() {
        return this.func_145831_w();
    }

    public void markComponentForUpdate(boolean referenced) {
    }

    public void markComponentDirty() {
        this.func_70296_d();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == this.capability) {
            if (side != null) {
                LazyOptional<CAP> lazyOptional = this.lazyOptionals.get(side);
                if (lazyOptional != null && lazyOptional.isPresent()) {
                    return lazyOptional.cast();
                }
            } else {
                return this.getInternalCAP().cast();
            }
        }
        return super.getCapability(cap, side);
    }

    protected abstract LazyOptional<CAP> getInternalCAP();

    protected abstract LazyOptional<CAP> createOutputCAP();

    protected abstract LazyOptional<CAP> createInputCAP();

    protected abstract CompoundNBT serializeCap();

    protected abstract void deserializeCap(CompoundNBT var1);

    public void onActivated(PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
        if (player instanceof ServerPlayerEntity) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new LoaderContainerProvider(this), packetBuffer -> LocatorFactory.writePacketBuffer((PacketBuffer)packetBuffer, (LocatorInstance)new TileEntityLocatorInstance(this.func_174877_v())));
        }
    }

    public void func_145839_a(@Nonnull CompoundNBT nbt) {
        super.func_145839_a(nbt);
        this.deserializeCap(nbt.func_74775_l("capability"));
    }

    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT nbt) {
        CompoundNBT superNBT = super.func_189515_b(nbt);
        superNBT.func_218657_a("capability", (INBT)this.serializeCap());
        return superNBT;
    }

    protected void invalidateCaps() {
        super.invalidateCaps();
        this.getInternalCAP().invalidate();
        this.lazyOptionals.forEach((direction, capLazyOptional) -> capLazyOptional.invalidate());
    }
}

