/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.tileentity.rail;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import xyz.brassgoggledcoders.transport.block.rail.HoldingRailBlock;
import xyz.brassgoggledcoders.transport.block.rail.TimedHoldingRailBlock;
import xyz.brassgoggledcoders.transport.content.TransportBlocks;
import xyz.brassgoggledcoders.transport.util.TickTimer;

public class TimedHoldingRailTileEntity
extends TileEntity
implements ITickableTileEntity {
    private final Map<UUID, TickTimer> timers = Maps.newHashMap();

    public TimedHoldingRailTileEntity() {
        this(TransportBlocks.TIMED_HOLDING_RAIL.getTileEntityType());
    }

    public TimedHoldingRailTileEntity(TileEntityType<?> tileEntityType) {
        super(tileEntityType);
    }

    public void onMinecartPass(AbstractMinecartEntity minecartEntity) {
        TickTimer timer = this.timers.get(minecartEntity.func_110124_au());
        if (timer == null) {
            timer = new TickTimer(5);
            this.timers.put(minecartEntity.func_110124_au(), timer);
        }
        timer.resetTimeToLive();
        if ((double)timer.getNumberOfTicks() > this.getMaxWait()) {
            HoldingRailBlock.handleGo(this.func_195044_w(), minecartEntity);
        } else {
            HoldingRailBlock.handleStop(minecartEntity);
        }
    }

    public void func_73660_a() {
        boolean powered = (Boolean)this.func_195044_w().func_177229_b((IProperty)HoldingRailBlock.POWERED);
        this.timers.entrySet().removeIf(entry -> !((TickTimer)entry.getValue()).tick(!powered));
    }

    private double getMaxWait() {
        return Math.pow(10.0, ((Integer)this.func_195044_w().func_177229_b((IProperty)TimedHoldingRailBlock.DELAY)).intValue());
    }

    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT nbt) {
        CompoundNBT superNBT = super.func_189515_b(nbt);
        ListNBT timerListNBT = new ListNBT();
        for (Map.Entry<UUID, TickTimer> entry : this.timers.entrySet()) {
            CompoundNBT timerNBT = entry.getValue().serializeNBT();
            timerNBT.func_186854_a("uuid", entry.getKey());
            timerListNBT.add((Object)timerNBT);
        }
        superNBT.func_218657_a("timers", (INBT)timerListNBT);
        return superNBT;
    }

    @ParametersAreNonnullByDefault
    public void func_145839_a(CompoundNBT nbt) {
        super.func_145839_a(nbt);
        ListNBT timerListNBT = nbt.func_150295_c("timers", 10);
        this.timers.clear();
        for (int i = 0; i < timerListNBT.size(); ++i) {
            CompoundNBT timerNBT = timerListNBT.func_150305_b(i);
            this.timers.put(timerNBT.func_186857_a("uuid"), new TickTimer(timerNBT));
        }
    }
}

