/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.api.cargo;

import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.util.NonNullLazy;
import net.minecraftforge.common.util.NonNullSupplier;
import xyz.brassgoggledcoders.transport.api.TransportObjects;
import xyz.brassgoggledcoders.transport.api.cargo.CargoModuleInstance;
import xyz.brassgoggledcoders.transport.api.entity.IModularEntity;
import xyz.brassgoggledcoders.transport.api.module.Module;
import xyz.brassgoggledcoders.transport.api.module.ModuleType;

public class CargoModule
extends Module<CargoModule> {
    private final NonNullLazy<? extends BlockState> blockStateLazy = NonNullLazy.of(() -> blockSupplier.get() == null ? Blocks.field_150350_a.func_176223_P() : (BlockState)blockSupplier.get());
    private final NonNullLazy<? extends Item> itemLazy = NonNullLazy.of(() -> itemSupplier.get() == null ? Items.field_190931_a : (Item)itemSupplier.get());
    private final NonNullLazy<Boolean> isActive = NonNullLazy.of(() -> blockSupplier.get() != null || itemSupplier.get() != null);
    private final boolean useContentTranslation;

    public CargoModule(Supplier<? extends Block> blockLazy) {
        this(blockLazy, (BiFunction<CargoModule, IModularEntity, ? extends CargoModuleInstance>)((BiFunction<CargoModule, IModularEntity, CargoModuleInstance>)CargoModuleInstance::new));
    }

    public CargoModule(Supplier<? extends Block> blockSupplier, BiFunction<CargoModule, IModularEntity, ? extends CargoModuleInstance> cargoInstanceCreator) {
        this(blockSupplier, cargoInstanceCreator, false);
    }

    public CargoModule(Supplier<? extends Block> blockSupplier, BiFunction<CargoModule, IModularEntity, ? extends CargoModuleInstance> cargoInstanceCreator, boolean useContentTranslation) {
        this(() -> ((Block)blockSupplier.get()).func_176223_P(), () -> blockSupplier.get() == null ? Items.field_190931_a : ((Block)blockSupplier.get()).func_199767_j(), cargoInstanceCreator, useContentTranslation);
    }

    public CargoModule(Supplier<? extends BlockState> blockSupplier, Supplier<? extends Item> itemSupplier, BiFunction<CargoModule, IModularEntity, ? extends CargoModuleInstance> cargoInstanceCreator, boolean useContentTranslation) {
        super((Supplier<ModuleType>)TransportObjects.CARGO_TYPE, cargoInstanceCreator);
        this.useContentTranslation = useContentTranslation;
    }

    @Nonnull
    public BlockState getDefaultBlockState() {
        return (BlockState)this.blockStateLazy.get();
    }

    @Override
    public boolean isActive() {
        return (Boolean)this.isActive.get();
    }

    @Override
    @Nonnull
    public String getTranslationKey() {
        return this.useContentTranslation ? ((Item)this.itemLazy.get()).func_77658_a() : super.getTranslationKey();
    }

    public ItemStack createItemStack(Item item) {
        return this.createItemStack(item, null);
    }

    public ItemStack createItemStack(Item item, @Nullable CargoModuleInstance cargoModuleInstance) {
        ItemStack itemStack = new ItemStack((IItemProvider)item);
        CompoundNBT cargoNBT = itemStack.func_190925_c("cargo");
        cargoNBT.func_74778_a("name", String.valueOf(this.getRegistryName()));
        if (cargoModuleInstance != null) {
            cargoNBT.func_218657_a("instance", (INBT)cargoModuleInstance.serializeNBT());
        }
        return itemStack;
    }

    @Nonnull
    public Item func_199767_j() {
        return (Item)this.itemLazy.get();
    }

    public static CargoModule fromItem(NonNullSupplier<? extends Item> itemSupplier, BiFunction<CargoModule, IModularEntity, ? extends CargoModuleInstance> cargoInstanceCreator) {
        return CargoModule.fromItem(itemSupplier, cargoInstanceCreator, false);
    }

    public static CargoModule fromItem(NonNullSupplier<? extends Item> itemSupplier, BiFunction<CargoModule, IModularEntity, ? extends CargoModuleInstance> cargoInstanceCreator, boolean useContentTranslation) {
        return new CargoModule(() -> null, () -> itemSupplier.get(), cargoInstanceCreator, useContentTranslation);
    }

    public static CargoModule fromBlockState(NonNullSupplier<? extends BlockState> blockStateSupplier, BiFunction<CargoModule, IModularEntity, ? extends CargoModuleInstance> cargoInstanceCreator, boolean useContentTranslation) {
        return new CargoModule(() -> blockStateSupplier.get(), () -> ((BlockState)blockStateSupplier.get()).func_177230_c().func_199767_j(), cargoInstanceCreator, useContentTranslation);
    }
}

