/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.api.engine;

import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import xyz.brassgoggledcoders.transport.api.engine.EngineModule;
import xyz.brassgoggledcoders.transport.api.engine.PoweredState;
import xyz.brassgoggledcoders.transport.api.entity.IHoldable;
import xyz.brassgoggledcoders.transport.api.entity.IModularEntity;
import xyz.brassgoggledcoders.transport.api.module.ModuleInstance;

public abstract class EngineModuleInstance
extends ModuleInstance<EngineModule>
implements IHoldable {
    private PoweredState poweredState = PoweredState.RUNNING;
    private Long lastForced;

    protected EngineModuleInstance(EngineModule engineModule, IModularEntity componentCarrier) {
        super(engineModule, componentCarrier);
    }

    public abstract boolean isRunning();

    public abstract double getMaximumSpeed();

    @Nonnull
    public PoweredState getPoweredState() {
        if (this.poweredState == PoweredState.FORCED_IDLE && (this.lastForced == null || this.lastForced + 5L < this.getWorld().func_82737_E())) {
            this.poweredState = PoweredState.RUNNING;
        }
        return this.poweredState;
    }

    public void setPoweredState(@Nonnull PoweredState poweredState) {
        this.poweredState = poweredState;
        this.lastForced = poweredState == PoweredState.FORCED_IDLE ? Long.valueOf(this.getWorld().func_82737_E()) : null;
    }

    protected void handleParticles(IParticleData particleData, int runningAmount) {
        if (this.isRunning() && this.getModularEntity().getTheWorld().field_73012_v.nextInt(runningAmount *= this.poweredState.getRunningModifier()) == 0) {
            this.getModularEntity().getTheWorld().func_195594_a(particleData, this.getModularEntity().getSelf().func_226277_ct_(), this.getModularEntity().getSelf().func_226278_cu_() + (double)this.getModularEntity().getSelf().func_70047_e() + 0.6, this.getModularEntity().getSelf().func_226281_cx_(), 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void onHeld() {
        this.setPoweredState(PoweredState.FORCED_IDLE);
    }

    @Override
    public void onRelease() {
        this.setPoweredState(PoweredState.RUNNING);
    }

    @Override
    public void push(float xPush, float zPush) {
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compoundNBT = super.serializeNBT();
        compoundNBT.func_74778_a("poweredState", this.poweredState.name());
        return compoundNBT;
    }

    @Override
    public void deserializeNBT(CompoundNBT nbt) {
        this.poweredState = PoweredState.byName(nbt.func_74779_i("poweredState"));
    }
}

