/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.api.entity;

import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import xyz.brassgoggledcoders.transport.api.module.Module;
import xyz.brassgoggledcoders.transport.api.module.ModuleInstance;
import xyz.brassgoggledcoders.transport.api.module.ModuleSlot;
import xyz.brassgoggledcoders.transport.api.module.ModuleType;

public interface IModularEntity
extends IItemProvider,
INBTSerializable<CompoundNBT>,
ICapabilityProvider {
    public void openContainer(PlayerEntity var1, INamedContainerProvider var2, Consumer<PacketBuffer> var3);

    default public boolean canInteractWith(PlayerEntity playerEntity) {
        return this.getSelf().func_70089_S() && playerEntity.func_70068_e(this.getSelf()) < 64.0;
    }

    @Nonnull
    default public World getTheWorld() {
        return this.getSelf().func_130014_f_();
    }

    @Nonnull
    public Entity getSelf();

    public boolean canEquip(Module<?> var1);

    @Nonnull
    public List<ModuleSlot> getModuleSlots();

    public void remove(ModuleSlot var1, boolean var2);

    public void remove(ModuleInstance<?> var1);

    @Nullable
    public <T extends Module<T>> ModuleInstance<T> add(Module<T> var1, ModuleSlot var2, boolean var3);

    @Nullable
    public ModuleInstance<?> getModuleInstance(ModuleSlot var1);

    @Nullable
    public <T extends Module<T>, U extends ModuleInstance<T>> U getModuleInstance(ModuleType var1);

    @Nullable
    default public <T extends Module<T>, U extends ModuleInstance<T>> U getModuleInstance(Supplier<ModuleType> moduleType) {
        return this.getModuleInstance(moduleType.get());
    }

    default public <T extends Module<T>, U extends ModuleInstance<T>, V> V callModule(Supplier<ModuleType> moduleType, Function<U, V> calling, Supplier<V> defaultValue) {
        U moduleInstance = this.getModuleInstance(moduleType);
        if (moduleInstance != null) {
            return calling.apply(moduleInstance);
        }
        return defaultValue.get();
    }

    public ItemStack asItemStack();

    public void read(PacketBuffer var1);

    public void write(PacketBuffer var1);

    public Collection<ModuleInstance<?>> getModuleInstances();

    default public ActionResultType applyPlayerInteraction(Supplier<ModuleSlot> moduleSlot, PlayerEntity player, Vector3d vec, Hand hand) {
        return this.applyPlayerInteraction(moduleSlot.get(), player, vec, hand);
    }

    public ActionResultType applyPlayerInteraction(ModuleSlot var1, PlayerEntity var2, Vector3d var3, Hand var4);

    public <T> List<LazyOptional<T>> getCapabilities(@Nonnull Capability<T> var1, @Nullable Direction var2, @Nullable ModuleSlot var3);

    public void invalidateCapabilities();

    public void sendClientUpdate(ModuleInstance<?> var1, int var2, CompoundNBT var3);
}

