/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.api.entity;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkHooks;
import xyz.brassgoggledcoders.transport.api.TransportAPI;
import xyz.brassgoggledcoders.transport.api.TransportObjects;
import xyz.brassgoggledcoders.transport.api.cargo.CargoModuleInstance;
import xyz.brassgoggledcoders.transport.api.entity.IModularEntity;
import xyz.brassgoggledcoders.transport.api.module.Module;
import xyz.brassgoggledcoders.transport.api.module.ModuleInstance;
import xyz.brassgoggledcoders.transport.api.module.ModuleSlot;
import xyz.brassgoggledcoders.transport.api.module.ModuleType;

public class ModularEntity<ENT extends Entity>
implements IModularEntity {
    private final ENT entity;
    private final ImmutableList<ModuleSlot> moduleSlots;
    private final Map<ModuleSlot, ModuleInstance<?>> byModuleSlot;
    private final Map<ModuleType, ModuleInstance<?>> byModuleType;

    @SafeVarargs
    public ModularEntity(ENT entity, Supplier<ModuleSlot> ... moduleSlots) {
        this(entity, (ModuleSlot[])Arrays.stream(moduleSlots).map(Supplier::get).toArray(ModuleSlot[]::new));
    }

    public ModularEntity(ENT entity, ModuleSlot ... moduleSlots) {
        this.entity = entity;
        this.moduleSlots = ImmutableList.copyOf((Object[])moduleSlots);
        this.byModuleSlot = Maps.newHashMap();
        this.byModuleType = Maps.newHashMap();
    }

    @Override
    public void openContainer(PlayerEntity playerEntity, INamedContainerProvider provider, Consumer<PacketBuffer> packetBufferConsumer) {
        if (playerEntity instanceof ServerPlayerEntity) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)playerEntity), (INamedContainerProvider)provider, packetBuffer -> {
                packetBuffer.writeInt(this.entity.func_145782_y());
                packetBufferConsumer.accept((PacketBuffer)packetBuffer);
            });
        }
    }

    @Override
    @Nonnull
    public Entity getSelf() {
        return this.entity;
    }

    @Override
    public boolean canEquip(Module<?> module) {
        return this.getModuleInstance(module.getType()) == null;
    }

    @Override
    @Nonnull
    public List<ModuleSlot> getModuleSlots() {
        return this.moduleSlots;
    }

    @Override
    @Nullable
    public <T extends Module<T>> ModuleInstance<T> add(Module<T> module, ModuleSlot moduleSlot, boolean sendUpdate) {
        if (this.canEquip(module) && module.isValidFor(this) && !this.byModuleSlot.containsKey((Object)moduleSlot) && this.getModuleSlots().contains((Object)moduleSlot)) {
            ModuleInstance<T> moduleInstance = module.createInstance(this);
            this.byModuleSlot.put(moduleSlot, moduleInstance);
            this.byModuleType.put(moduleInstance.getModuleType(), moduleInstance);
            if (sendUpdate) {
                TransportAPI.getNetworkHandler().sendAddModuleCase(this, moduleInstance, moduleSlot);
            }
            return moduleInstance;
        }
        return null;
    }

    @Override
    @Nullable
    public ModuleInstance<?> getModuleInstance(ModuleSlot moduleSlot) {
        return this.byModuleSlot.get((Object)moduleSlot);
    }

    @Override
    @Nullable
    public <T extends Module<T>, U extends ModuleInstance<T>> U getModuleInstance(ModuleType moduleType) {
        return (U)this.byModuleType.get((Object)moduleType);
    }

    @Nonnull
    public Item func_199767_j() {
        ItemStack itemStack = new ItemStack((IItemProvider)((IItemProvider)this.entity).func_199767_j());
        itemStack.func_196082_o().func_218657_a("modules", (INBT)this.serializeNBT());
        return ((IItemProvider)this.entity).func_199767_j();
    }

    @Override
    public ItemStack asItemStack() {
        ItemStack itemStack = new ItemStack((IItemProvider)((IItemProvider)this.entity).func_199767_j());
        itemStack.func_196082_o().func_218657_a("modules", (INBT)this.serializeNBT());
        return itemStack;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT caseNBT = new CompoundNBT();
        ListNBT moduleNBT = new ListNBT();
        for (Map.Entry<ModuleSlot, ModuleInstance<?>> entrySet : this.byModuleSlot.entrySet()) {
            CompoundNBT moduleInstanceNBT = new CompoundNBT();
            ModuleInstance<?> moduleInstance = entrySet.getValue();
            Module.toCompoundNBT(moduleInstance.getModule(), moduleInstanceNBT);
            CompoundNBT instanceNBT = moduleInstance.serializeNBT();
            moduleInstanceNBT.func_218657_a("instance", (INBT)instanceNBT);
            moduleInstanceNBT.func_74778_a("moduleSlot", String.valueOf(entrySet.getKey().getRegistryName()));
            moduleNBT.add((Object)moduleInstanceNBT);
        }
        caseNBT.func_218657_a("moduleInstances", (INBT)moduleNBT);
        return caseNBT;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        ListNBT moduleInstancesNBT = nbt.func_150295_c("moduleInstances", 10);
        for (int x = 0; x < moduleInstancesNBT.size(); ++x) {
            CompoundNBT moduleInstanceNBT = moduleInstancesNBT.func_150305_b(x);
            Module<?> module = Module.fromCompoundNBT(moduleInstanceNBT);
            ModuleSlot moduleSlot = TransportAPI.getModuleSlot(moduleInstanceNBT.func_74779_i("moduleSlot"));
            if (module == null || moduleSlot == null) continue;
            CompoundNBT instanceNBT = moduleInstanceNBT.func_74775_l("instance");
            ModuleInstance<?> moduleInstance = this.add(module, moduleSlot, false);
            if (moduleInstance == null) continue;
            moduleInstance.deserializeNBT(instanceNBT);
        }
    }

    @Override
    public void write(PacketBuffer packetBuffer) {
        packetBuffer.writeInt(this.byModuleSlot.size());
        for (Map.Entry<ModuleSlot, ModuleInstance<?>> entrySet : this.byModuleSlot.entrySet()) {
            Module.toPacketBuffer(entrySet.getValue().getModule(), packetBuffer);
            packetBuffer.func_192572_a(Objects.requireNonNull(entrySet.getKey().getRegistryName()));
            entrySet.getValue().write(packetBuffer);
        }
    }

    @Override
    public Collection<ModuleInstance<?>> getModuleInstances() {
        return this.byModuleType.values();
    }

    @Override
    public ActionResultType applyPlayerInteraction(ModuleSlot moduleSlot, PlayerEntity player, Vector3d vec, Hand hand) {
        ModuleInstance<?> moduleInstance = this.getModuleInstance(moduleSlot);
        return moduleInstance != null ? moduleInstance.applyInteraction(player, vec, hand) : ActionResultType.PASS;
    }

    @Override
    public void read(PacketBuffer packetBuffer) {
        this.byModuleSlot.clear();
        this.byModuleType.clear();
        int components = packetBuffer.readInt();
        for (int x = 0; x < components; ++x) {
            ModuleInstance<?> moduleInstance;
            Module<?> module = Module.fromPacketBuffer(packetBuffer);
            ModuleSlot moduleSlot = TransportAPI.getModuleSlot(packetBuffer.func_192575_l());
            if (module == null || moduleSlot == null || (moduleInstance = this.add(module, moduleSlot, false)) == null) continue;
            moduleInstance.read(packetBuffer);
        }
    }

    @Override
    public void remove(ModuleSlot moduleSlot, boolean sendUpdate) {
        ModuleInstance<?> moduleInstance = this.byModuleSlot.remove((Object)moduleSlot);
        if (moduleInstance != null) {
            this.byModuleType.remove((Object)moduleInstance.getModuleType());
            if (sendUpdate) {
                // empty if block
            }
        }
    }

    @Override
    public void remove(ModuleInstance<?> moduleInstance) {
        this.byModuleSlot.entrySet().removeIf(entry -> entry.getValue() == moduleInstance);
        this.byModuleType.entrySet().removeIf(entry -> entry.getValue() == moduleInstance);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        LazyOptional<T> lazyOptional;
        CargoModuleInstance cargoModuleInstance = (CargoModuleInstance)this.getModuleInstance((Supplier<ModuleType>)TransportObjects.CARGO_TYPE);
        if (cargoModuleInstance != null && (lazyOptional = cargoModuleInstance.getCapability(cap, side)).isPresent()) {
            return lazyOptional;
        }
        for (ModuleInstance<?> moduleInstance : this.byModuleSlot.values()) {
            LazyOptional<T> lazyOptional2 = moduleInstance.getCapability(cap, side);
            if (!lazyOptional2.isPresent()) continue;
            return lazyOptional2;
        }
        return LazyOptional.empty();
    }

    @Override
    @Nonnull
    public <T> List<LazyOptional<T>> getCapabilities(@Nonnull Capability<T> cap, @Nullable Direction side, @Nullable ModuleSlot priority) {
        ArrayList lazyOptionals = Lists.newArrayList();
        for (Map.Entry<ModuleSlot, ModuleInstance<?>> entry : this.byModuleSlot.entrySet()) {
            if (entry.getKey() == priority) {
                lazyOptionals.add(0, entry.getValue().getCapability(cap, side));
                continue;
            }
            lazyOptionals.add(entry.getValue().getCapability(cap, side));
        }
        return lazyOptionals;
    }

    @Override
    public void invalidateCapabilities() {
        this.byModuleSlot.values().forEach(ModuleInstance::invalidateCapabilities);
    }

    @Override
    public void sendClientUpdate(ModuleInstance<?> moduleInstance, int type, CompoundNBT compoundNBT) {
        for (Map.Entry<ModuleSlot, ModuleInstance<?>> entry : this.byModuleSlot.entrySet()) {
            if (entry.getValue() != moduleInstance) continue;
            TransportAPI.getNetworkHandler().sendModuleInstanceUpdate(this, entry.getKey(), type, compoundNBT);
        }
    }
}

