/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.block;

import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.ScaffoldingBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.FallingBlockEntity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.SlabType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class ScaffoldingSlabBlock
extends SlabBlock {
    public static final IntegerProperty DISTANCE_07 = BlockStateProperties.field_222510_au;
    public static final BooleanProperty RAILED = BooleanProperty.func_177716_a((String)"railed");
    private static final VoxelShape field_220121_d;
    private static final VoxelShape field_220123_f;
    private static final VoxelShape field_220124_g;

    public ScaffoldingSlabBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)RAILED, (Comparable)Boolean.valueOf(false)));
    }

    public static int getDistance(IBlockReader blockReader, BlockPos blockPos) {
        BlockPos.Mutable mutableBlockPos = blockPos.func_239590_i_().func_189536_c(Direction.DOWN);
        BlockState blockState = blockReader.func_180495_p((BlockPos)mutableBlockPos);
        int i = 7;
        if (blockState.func_177230_c() instanceof ScaffoldingSlabBlock) {
            i = (Integer)blockState.func_177229_b((Property)DISTANCE_07);
        } else if (blockState.func_177230_c() instanceof ScaffoldingBlock) {
            i = (Integer)blockState.func_177229_b((Property)ScaffoldingBlock.field_220118_a);
        } else if (blockState.func_224755_d(blockReader, (BlockPos)mutableBlockPos, Direction.UP)) {
            return 0;
        }
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockState nextCheckedState = blockReader.func_180495_p((BlockPos)mutableBlockPos.func_189533_g((Vector3i)blockPos).func_189536_c(direction));
            if (!(nextCheckedState.func_177230_c() instanceof ScaffoldingBlock ? (i = Math.min(i, (Integer)nextCheckedState.func_177229_b((Property)ScaffoldingBlock.field_220118_a) + 1)) == 1 : nextCheckedState.func_177230_c() instanceof ScaffoldingSlabBlock && (i = Math.min(i, (Integer)nextCheckedState.func_177229_b((Property)DISTANCE_07) + 1)) == 1)) continue;
            break;
        }
        return i;
    }

    protected void func_206840_a(@Nonnull StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{DISTANCE_07, RAILED});
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)field_204512_b)).booleanValue()) {
            world.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        if (!world.func_201670_d()) {
            world.func_205220_G_().func_205360_a(currentPos, (Object)this, 1);
        }
        return stateIn;
    }

    @ParametersAreNonnullByDefault
    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        return ScaffoldingSlabBlock.getDistance((IBlockReader)world, pos) < 7;
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        if (context.getEntity() instanceof AbstractMinecartEntity) {
            return VoxelShapes.func_197880_a();
        }
        switch ((SlabType)state.func_177229_b((Property)field_196505_a)) {
            case DOUBLE: {
                if (context.func_216378_a(VoxelShapes.func_197868_b(), pos, true)) {
                    return field_220121_d;
                }
                return (Integer)state.func_177229_b((Property)DISTANCE_07) != 0 && context.func_216378_a(field_220124_g, pos, true) ? field_220123_f : VoxelShapes.func_197880_a();
            }
            case TOP: {
                return field_196507_c;
            }
            case BOTTOM: {
                return field_196506_b;
            }
        }
        return super.func_220071_b(state, world, pos, context);
    }

    @ParametersAreNonnullByDefault
    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!worldIn.field_72995_K) {
            worldIn.func_205220_G_().func_205360_a(pos, (Object)this, 1);
        }
    }

    @ParametersAreNonnullByDefault
    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random rand) {
        int i = ScaffoldingSlabBlock.getDistance((IBlockReader)world, pos);
        BlockState blockstate = (BlockState)state.func_206870_a((Property)DISTANCE_07, (Comparable)Integer.valueOf(i));
        if ((Integer)blockstate.func_177229_b((Property)DISTANCE_07) == 7) {
            if ((Integer)state.func_177229_b((Property)DISTANCE_07) == 7) {
                world.func_217376_c((Entity)new FallingBlockEntity((World)world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, (BlockState)blockstate.func_206870_a((Property)field_204512_b, (Comparable)Boolean.FALSE)));
            } else {
                world.func_175655_b(pos, true);
            }
        } else if (state != blockstate) {
            world.func_180501_a(pos, blockstate, 3);
        }
    }

    public boolean isLadder(BlockState state, IWorldReader world, BlockPos pos, LivingEntity entity) {
        return state.func_177229_b((Property)field_196505_a) == SlabType.DOUBLE;
    }

    static {
        field_220123_f = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
        field_220124_g = VoxelShapes.func_197868_b().func_197751_a(0.0, -1.0, 0.0);
        VoxelShape voxelShape = Block.func_208617_a((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        VoxelShape voxelShape1 = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)2.0);
        VoxelShape voxelShape2 = Block.func_208617_a((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0);
        VoxelShape voxelShape3 = Block.func_208617_a((double)0.0, (double)0.0, (double)14.0, (double)2.0, (double)16.0, (double)16.0);
        VoxelShape voxelShape4 = Block.func_208617_a((double)14.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
        field_220121_d = VoxelShapes.func_216384_a((VoxelShape)voxelShape, (VoxelShape[])new VoxelShape[]{voxelShape1, voxelShape2, voxelShape3, voxelShape4});
    }
}

