/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.block.loader;

import com.google.common.collect.Maps;
import java.util.EnumMap;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import xyz.brassgoggledcoders.transport.block.loader.LoadType;
import xyz.brassgoggledcoders.transport.content.TransportItemTags;
import xyz.brassgoggledcoders.transport.tileentity.loader.BasicLoaderTileEntity;

public abstract class LoaderBlock
extends Block {
    public static final EnumMap<Direction, EnumProperty<LoadType>> PROPERTIES = LoaderBlock.createLoadTypeProperties();

    public LoaderBlock(AbstractBlock.Properties properties) {
        super(properties);
        BlockState defaultState = (BlockState)this.func_176194_O().func_177621_b();
        for (EnumProperty<LoadType> loadTypeEnumProperty : PROPERTIES.values()) {
            defaultState = (BlockState)defaultState.func_206870_a(loadTypeEnumProperty, (Comparable)((Object)LoadType.NONE));
        }
        this.func_180632_j(defaultState);
    }

    private static EnumMap<Direction, EnumProperty<LoadType>> createLoadTypeProperties() {
        EnumMap loadTypes = Maps.newEnumMap(Direction.class);
        for (Direction direction : Direction.values()) {
            loadTypes.put(direction, EnumProperty.func_177709_a((String)direction.name().toLowerCase(), LoadType.class));
        }
        return loadTypes;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        PROPERTIES.values().forEach(xva$0 -> builder.func_206894_a(new Property[]{xva$0}));
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
        ItemStack heldItemStack = player.func_184586_b(hand);
        if (heldItemStack.func_77973_b().func_206844_a(TransportItemTags.WRENCHES)) {
            state = player.func_213453_ef() ? (BlockState)state.func_235896_a_((Property)PROPERTIES.get(rayTraceResult.func_216354_b().func_176734_d())) : (BlockState)state.func_235896_a_((Property)PROPERTIES.get(rayTraceResult.func_216354_b()));
            world.func_175656_a(pos, state);
            this.handleTileEntity((IWorld)world, pos, basicLoaderTileEntity -> basicLoaderTileEntity.updateSide(rayTraceResult.func_216354_b()));
            return ActionResultType.SUCCESS;
        }
        if (!player.func_213453_ef()) {
            this.handleTileEntity((IWorld)world, pos, basicLoaderTileEntity -> basicLoaderTileEntity.onActivated(player, hand, rayTraceResult));
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    private void handleTileEntity(IWorld world, BlockPos pos, Consumer<BasicLoaderTileEntity> tileEntityConsumer) {
        Optional.ofNullable(world.func_175625_s(pos)).filter(tileEntity -> tileEntity instanceof BasicLoaderTileEntity).map(BasicLoaderTileEntity.class::cast).ifPresent(tileEntityConsumer);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return this.createLoaderTileEntity();
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public BlockState func_196271_a(@Nonnull BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        this.handleTileEntity(world, currentPos, basicLoaderTileEntity -> basicLoaderTileEntity.updateSide(facing));
        return super.func_196271_a(state, facing, facingState, world, currentPos, facingPos);
    }

    public abstract TileEntity createLoaderTileEntity();
}

