/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.cargoinstance.capability;

import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.container.addon.IContainerAddon;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import xyz.brassgoggledcoders.transport.api.cargo.CargoModule;
import xyz.brassgoggledcoders.transport.api.entity.IModularEntity;
import xyz.brassgoggledcoders.transport.cargoinstance.capability.CapabilityCargoModuleInstance;

public class FluidCargoModuleInstance
extends CapabilityCargoModuleInstance<IFluidHandler> {
    private final FluidTankComponent<?> fluidTank;
    private final LazyOptional<IFluidHandler> lazyFluidTank;

    public FluidCargoModuleInstance(CargoModule cargoModule, IModularEntity modularEntity) {
        this(cargoModule, modularEntity, 10);
    }

    public FluidCargoModuleInstance(CargoModule cargoModule, IModularEntity modularEntity, int buckets) {
        super(cargoModule, modularEntity, CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
        this.fluidTank = new FluidTankComponent("Tank", buckets * 1000, 80, 28);
        this.lazyFluidTank = LazyOptional.of(() -> this.fluidTank);
    }

    @Override
    public ActionResultType applyInteraction(PlayerEntity player, Vector3d vec, Hand hand) {
        if (FluidUtil.interactWithFluidHandler((PlayerEntity)player, (Hand)hand, this.fluidTank)) {
            return ActionResultType.SUCCESS;
        }
        return super.applyInteraction(player, vec, hand);
    }

    @Override
    protected LazyOptional<IFluidHandler> getLazyOptional() {
        return this.lazyFluidTank;
    }

    @Override
    protected CompoundNBT serializeCapability() {
        return this.fluidTank.writeToNBT(new CompoundNBT());
    }

    @Override
    protected void deserializeCapability(CompoundNBT nbt) {
        this.fluidTank.readFromNBT(nbt);
    }

    @Nonnull
    public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
        return this.fluidTank.getScreenAddons();
    }

    @Nonnull
    public List<IFactory<? extends IContainerAddon>> getContainerAddons() {
        return this.fluidTank.getContainerAddons();
    }
}

