/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.engine;

import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.api.client.IScreenAddonProvider;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.container.addon.IContainerAddon;
import com.hrznstudio.titanium.container.addon.IContainerAddonProvider;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import xyz.brassgoggledcoders.transport.api.engine.EngineModule;
import xyz.brassgoggledcoders.transport.api.engine.EngineModuleInstance;
import xyz.brassgoggledcoders.transport.api.engine.PoweredState;
import xyz.brassgoggledcoders.transport.api.entity.IModularEntity;
import xyz.brassgoggledcoders.transport.container.ModuleContainerProvider;

public class SolidFuelEngineModuleInstance
extends EngineModuleInstance
implements IScreenAddonProvider,
IContainerAddonProvider {
    private final InventoryComponent<?> itemStackHandler = new InventoryComponent("engine", 80, 35, 1).setInputFilter((stack, slot) -> ForgeHooks.getBurnTime((ItemStack)stack) > 0);
    private final LazyOptional<IItemHandler> optionalItemHandler = LazyOptional.of(() -> this.itemStackHandler);
    private int burnTime = 0;

    public SolidFuelEngineModuleInstance(EngineModule engineModule, IModularEntity powered) {
        super(engineModule, powered);
    }

    @Override
    public ActionResultType applyInteraction(PlayerEntity player, Vector3d vec, Hand hand) {
        this.getModularEntity().openContainer(player, new ModuleContainerProvider(this, this.getModularEntity()), packetBuffer -> packetBuffer.func_192572_a(Objects.requireNonNull(((EngineModule)((Object)((Object)this.getModule()))).getType().getRegistryName())));
        return ActionResultType.SUCCESS;
    }

    @Override
    public boolean isRunning() {
        return this.burnTime > 0;
    }

    @Override
    public void tick() {
        if (!this.getModularEntity().getTheWorld().func_201670_d()) {
            if (this.burnTime > 0) {
                this.burnTime -= this.getPoweredState().getBurnAmount();
            }
            if (this.burnTime <= 0) {
                int newBurnTime;
                ItemStack itemStack;
                this.burnTime = 0;
                if (this.getPoweredState() == PoweredState.RUNNING && !(itemStack = this.itemStackHandler.getStackInSlot(0)).func_190926_b() && (newBurnTime = ForgeHooks.getBurnTime((ItemStack)itemStack) * 2) > 0) {
                    if (itemStack.hasContainerItem()) {
                        this.itemStackHandler.setStackInSlot(0, itemStack.getContainerItem());
                    } else {
                        itemStack.func_190918_g(1);
                    }
                    this.burnTime += newBurnTime;
                }
            }
        }
        this.handleParticles((IParticleData)ParticleTypes.field_197594_E, 4);
    }

    @Override
    public double getMaximumSpeed() {
        return 0.25;
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY == cap ? this.optionalItemHandler.cast() : LazyOptional.empty();
    }

    @Nonnull
    public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
        return this.itemStackHandler.getScreenAddons();
    }

    @Nonnull
    public List<IFactory<? extends IContainerAddon>> getContainerAddons() {
        return this.itemStackHandler.getContainerAddons();
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compoundNBT = super.serializeNBT();
        compoundNBT.func_74768_a("burnTime", this.burnTime);
        compoundNBT.func_218657_a("itemStackHandler", (INBT)this.itemStackHandler.serializeNBT());
        return compoundNBT;
    }

    @Override
    public void deserializeNBT(CompoundNBT nbt) {
        super.deserializeNBT(nbt);
        this.burnTime = nbt.func_74762_e("burnTime");
        this.itemStackHandler.deserializeNBT(nbt.func_74775_l("itemStackHandler"));
    }

    @Override
    public void invalidateCapabilities() {
        super.invalidateCapabilities();
        this.optionalItemHandler.invalidate();
    }
}

