/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.item;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.AbstractRailBlock;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.item.MinecartItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.properties.RailShape;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.IForgeRegistry;
import xyz.brassgoggledcoders.transport.api.TransportAPI;
import xyz.brassgoggledcoders.transport.api.cargo.CargoModule;
import xyz.brassgoggledcoders.transport.api.entity.HullType;
import xyz.brassgoggledcoders.transport.api.item.IModularItem;
import xyz.brassgoggledcoders.transport.api.module.ModuleInstance;
import xyz.brassgoggledcoders.transport.content.TransportEntities;
import xyz.brassgoggledcoders.transport.content.TransportHullTypes;
import xyz.brassgoggledcoders.transport.content.TransportModuleSlots;
import xyz.brassgoggledcoders.transport.entity.CargoCarrierMinecartEntity;

public class CargoCarrierMinecartItem
extends MinecartItem
implements IModularItem<CargoCarrierMinecartEntity> {
    public CargoCarrierMinecartItem(Item.Properties properties) {
        super(AbstractMinecartEntity.Type.CHEST, properties);
    }

    public static CargoModule getCargo(@Nullable CompoundNBT cargo) {
        return Optional.ofNullable(cargo).map(compoundNBT -> compoundNBT.func_74779_i("name")).map(TransportAPI::getCargo).orElse(null);
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext context) {
        BlockPos blockPos;
        World world = context.func_195991_k();
        BlockState blockstate = world.func_180495_p(blockPos = context.func_195995_a());
        if (!blockstate.func_235714_a_((ITag)BlockTags.field_203437_y)) {
            return ActionResultType.FAIL;
        }
        ItemStack itemStack = context.func_195996_i();
        if (!world.field_72995_K) {
            CargoModule cargoModule;
            CompoundNBT cargoNBT;
            RailShape railshape = blockstate.func_177230_c() instanceof AbstractRailBlock ? ((AbstractRailBlock)blockstate.func_177230_c()).getRailDirection(blockstate, (IBlockReader)world, blockPos, null) : RailShape.NORTH_SOUTH;
            double d0 = 0.0;
            if (railshape.func_208092_c()) {
                d0 = 0.5;
            }
            CargoCarrierMinecartEntity cargoCarrierMinecartEntity = new CargoCarrierMinecartEntity(world, (double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o() + 0.0625 + d0, (double)blockPos.func_177952_p() + 0.5);
            if (itemStack.func_82837_s()) {
                cargoCarrierMinecartEntity.func_200203_b(itemStack.func_200301_q());
            }
            cargoCarrierMinecartEntity.setHullType(this.getHullType(itemStack.func_77978_p()));
            LazyOptional modularEntity = cargoCarrierMinecartEntity.getCapability(TransportAPI.MODULAR_ENTITY);
            CompoundNBT moduleNBT = itemStack.func_179543_a("modules");
            if (moduleNBT != null) {
                modularEntity.ifPresent(value -> value.deserializeNBT((INBT)moduleNBT));
            }
            if ((cargoNBT = itemStack.func_179543_a("cargo")) != null && cargoNBT.func_74764_b("name") && (cargoModule = TransportAPI.getCargo(cargoNBT.func_74779_i("name"))) != null) {
                modularEntity.ifPresent(value -> {
                    ModuleInstance<CargoModule> moduleInstance = value.add(cargoModule, TransportModuleSlots.CARGO.get(), false);
                    if (moduleInstance != null && cargoNBT.func_74764_b("instance")) {
                        moduleInstance.deserializeNBT(cargoNBT.func_74775_l("instance"));
                    }
                });
            }
            if (context.func_195999_j() != null) {
                cargoCarrierMinecartEntity.setOriginalPushes(context.func_195999_j());
            }
            world.func_217376_c((Entity)cargoCarrierMinecartEntity);
        }
        itemStack.func_190918_g(1);
        return ActionResultType.SUCCESS;
    }

    @OnlyIn(value=Dist.CLIENT)
    @ParametersAreNonnullByDefault
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        tooltip.add((ITextComponent)new TranslationTextComponent("text.transport.hull_type", new Object[]{this.getHullType(stack.func_77978_p()).getDisplayName()}));
        tooltip.addAll(this.getModuleListToolTip(stack.func_179543_a("modules")));
    }

    @Nonnull
    public ITextComponent func_200295_i(@Nonnull ItemStack stack) {
        CargoModule cargoModule = CargoCarrierMinecartItem.getCargo(stack.func_179543_a("cargo"));
        if (cargoModule != null) {
            return new TranslationTextComponent("text.transport.with", new Object[]{Items.field_151143_au.func_200295_i(stack), cargoModule.getDisplayName()});
        }
        return super.func_200295_i(stack);
    }

    private HullType getHullType(CompoundNBT compoundNBT) {
        HullType hullType;
        String hullTypeName;
        if (compoundNBT != null && !(hullTypeName = compoundNBT.func_74779_i("hull_type")).isEmpty() && (hullType = (HullType)((IForgeRegistry)TransportAPI.HULL_TYPE.get()).getValue(new ResourceLocation(hullTypeName))) != null) {
            return hullType;
        }
        return TransportHullTypes.IRON.get();
    }

    @Override
    public EntityType<CargoCarrierMinecartEntity> getEntityType() {
        return TransportEntities.CARGO_MINECART.get();
    }
}

