/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.item;

import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.IForgeRegistry;
import xyz.brassgoggledcoders.transport.api.TransportAPI;
import xyz.brassgoggledcoders.transport.api.entity.HullType;
import xyz.brassgoggledcoders.transport.api.item.IHulledItem;
import xyz.brassgoggledcoders.transport.api.item.IModularItem;
import xyz.brassgoggledcoders.transport.content.TransportEntities;
import xyz.brassgoggledcoders.transport.content.TransportHullTypes;
import xyz.brassgoggledcoders.transport.content.TransportItemTags;
import xyz.brassgoggledcoders.transport.entity.ModularBoatEntity;

public class ModularBoatItem
extends Item
implements IModularItem<ModularBoatEntity>,
IHulledItem {
    private static final Predicate<Entity> CAN_COLLIDE = EntityPredicates.field_180132_d.and(Entity::func_70067_L);

    public ModularBoatItem(Item.Properties properties) {
        super(properties);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World world, PlayerEntity player, @Nonnull Hand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        BlockRayTraceResult rayTraceResult = ModularBoatItem.func_219968_a((World)world, (PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.ANY);
        if (rayTraceResult.func_216346_c() == RayTraceResult.Type.MISS) {
            return ActionResult.func_226250_c_((Object)itemStack);
        }
        Vector3d vector3d = player.func_70676_i(1.0f);
        List list = world.func_175674_a((Entity)player, player.func_174813_aQ().func_216361_a(vector3d.func_186678_a(5.0)).func_186662_g(1.0), CAN_COLLIDE);
        if (!list.isEmpty()) {
            Vector3d vector3d1 = player.func_174824_e(1.0f);
            for (Entity entity : list) {
                AxisAlignedBB axisalignedbb = entity.func_174813_aQ().func_186662_g((double)entity.func_70111_Y());
                if (!axisalignedbb.func_72318_a(vector3d1)) continue;
                return ActionResult.func_226250_c_((Object)itemStack);
            }
        }
        if (rayTraceResult.func_216346_c() == RayTraceResult.Type.BLOCK) {
            Entity boatEntity = this.createBoatEntity(itemStack, world, (RayTraceResult)rayTraceResult);
            boatEntity.field_70177_z = player.field_70177_z;
            if (!world.func_226665_a__(boatEntity, boatEntity.func_174813_aQ().func_186662_g(-0.1))) {
                return ActionResult.func_226251_d_((Object)itemStack);
            }
            if (!world.field_72995_K) {
                world.func_217376_c(boatEntity);
                if (!player.field_71075_bZ.field_75098_d) {
                    itemStack.func_190918_g(1);
                }
            }
            player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
            return ActionResult.func_233538_a_((Object)itemStack, (boolean)world.func_201670_d());
        }
        return ActionResult.func_226250_c_((Object)itemStack);
    }

    @ParametersAreNonnullByDefault
    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            if (group == ItemGroup.field_78027_g) {
                CompoundNBT tagNBT = new CompoundNBT();
                tagNBT.func_74778_a("hull_type", TransportHullTypes.OAK.getId().toString());
                ItemStack itemStack = new ItemStack((IItemProvider)this);
                itemStack.func_77982_d(tagNBT);
                items.add((Object)itemStack);
            } else {
                for (Map.Entry hullType : ((IForgeRegistry)TransportAPI.HULL_TYPE.get()).getEntries()) {
                    Item hullItem = ((HullType)((Object)hullType.getValue())).func_199767_j();
                    if (!hullItem.func_206844_a(TransportItemTags.HULLS_BOAT)) continue;
                    CompoundNBT tagNBT = new CompoundNBT();
                    tagNBT.func_74778_a("hull_type", ((RegistryKey)hullType.getKey()).func_240901_a_().toString());
                    ItemStack itemStack = new ItemStack((IItemProvider)this);
                    itemStack.func_77982_d(tagNBT);
                    items.add((Object)itemStack);
                }
            }
        }
    }

    @Nonnull
    private Entity createBoatEntity(ItemStack itemStack, World world, RayTraceResult rayTraceResult) {
        ModularBoatEntity modularBoatEntity = new ModularBoatEntity(world, rayTraceResult.func_216347_e().field_72450_a, rayTraceResult.func_216347_e().field_72448_b, rayTraceResult.func_216347_e().field_72449_c);
        if (itemStack.func_82837_s()) {
            modularBoatEntity.func_200203_b(itemStack.func_200301_q());
        }
        modularBoatEntity.setHullType(this.getHullType(itemStack.func_77978_p()));
        LazyOptional modularEntity = modularBoatEntity.getCapability(TransportAPI.MODULAR_ENTITY);
        CompoundNBT moduleNBT = itemStack.func_179543_a("modules");
        if (moduleNBT != null) {
            modularEntity.ifPresent(value -> value.deserializeNBT((INBT)moduleNBT));
        }
        return modularBoatEntity;
    }

    @OnlyIn(value=Dist.CLIENT)
    @ParametersAreNonnullByDefault
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        tooltip.add((ITextComponent)new TranslationTextComponent("text.transport.hull_type", new Object[]{this.getHullType(stack.func_77978_p()).getDisplayName()}));
        tooltip.addAll(this.getModuleListToolTip(stack.func_179543_a("modules")));
    }

    private HullType getHullType(CompoundNBT compoundNBT) {
        HullType hullType;
        String hullTypeName;
        if (compoundNBT != null && !(hullTypeName = compoundNBT.func_74779_i("hull_type")).isEmpty() && (hullType = (HullType)((IForgeRegistry)TransportAPI.HULL_TYPE.get()).getValue(new ResourceLocation(hullTypeName))) != null) {
            return hullType;
        }
        return TransportHullTypes.OAK.get();
    }

    @Override
    public EntityType<ModularBoatEntity> getEntityType() {
        return TransportEntities.MODULAR_BOAT.get();
    }

    @Override
    @Nonnull
    public HullType getHullType(@Nonnull ItemStack itemStack) {
        return this.getHullType(itemStack.func_77978_p());
    }
}

