/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.pointmachine;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ComparatorBlock;
import net.minecraft.block.RedstoneWireBlock;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.item.minecart.CommandBlockMinecartEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.ComparatorMode;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import xyz.brassgoggledcoders.transport.api.pointmachine.IPointMachineBehavior;

public class ComparatorPointMachineBehavior
implements IPointMachineBehavior {
    @Override
    public boolean shouldDiverge(BlockState motorState, IBlockReader blockReader, BlockPos motorPos, BlockPos switchPos, @Nullable AbstractMinecartEntity minecartEntity) {
        Direction direction;
        if (minecartEntity != null && motorPos.func_177972_a(direction = (Direction)motorState.func_177229_b((Property)BlockStateProperties.field_208157_J)).equals((Object)switchPos)) {
            int comparatorLevel;
            int power = 0;
            if (blockReader instanceof IWorldReader) {
                power = this.getPowerOnSides((IWorldReader)blockReader, motorPos, direction);
            }
            if ((comparatorLevel = minecartEntity.getComparatorLevel()) < 0) {
                if (minecartEntity instanceof CommandBlockMinecartEntity) {
                    comparatorLevel = ((CommandBlockMinecartEntity)minecartEntity).func_145822_e().func_145760_g();
                } else if (minecartEntity instanceof IInventory) {
                    comparatorLevel = Container.func_94526_b((IInventory)((IInventory)minecartEntity));
                }
            }
            return motorState.func_177229_b((Property)ComparatorBlock.field_176463_b) == ComparatorMode.COMPARE == comparatorLevel >= power;
        }
        return false;
    }

    protected int getPowerOnSides(IWorldReader world, BlockPos pos, Direction direction) {
        Direction direction1 = direction.func_176746_e();
        Direction direction2 = direction.func_176735_f();
        return Math.max(this.getPowerOnSide(world, pos.func_177972_a(direction1), direction1), this.getPowerOnSide(world, pos.func_177972_a(direction2), direction2));
    }

    protected int getPowerOnSide(IWorldReader world, BlockPos pos, Direction side) {
        BlockState blockstate = world.func_180495_p(pos);
        Block block = blockstate.func_177230_c();
        if (blockstate.func_185897_m()) {
            if (block == Blocks.field_150451_bX) {
                return 15;
            }
            return block == Blocks.field_150488_af ? ((Integer)blockstate.func_177229_b((Property)RedstoneWireBlock.field_176351_O)).intValue() : world.func_175627_a(pos, side);
        }
        return 0;
    }
}

