/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.registrate.builder;

import javax.annotation.Nonnull;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import xyz.brassgoggledcoders.transport.api.TransportClientAPI;
import xyz.brassgoggledcoders.transport.api.module.Module;
import xyz.brassgoggledcoders.transport.api.renderer.IModuleRenderer;
import xyz.brassgoggledcoders.transport.repack.registrate.AbstractRegistrate;
import xyz.brassgoggledcoders.transport.repack.registrate.builders.AbstractBuilder;
import xyz.brassgoggledcoders.transport.repack.registrate.builders.BuilderCallback;
import xyz.brassgoggledcoders.transport.repack.registrate.util.OneTimeEventReceiver;
import xyz.brassgoggledcoders.transport.repack.registrate.util.nullness.NonNullSupplier;
import xyz.brassgoggledcoders.transport.repack.registrate.util.nullness.NonnullType;

public class ModuleBuilder<M extends Module<M>, E extends M, P, B extends ModuleBuilder<M, E, P, B>>
extends AbstractBuilder<M, E, P, B> {
    private final NonNullSupplier<E> moduleSupplier;
    private NonNullSupplier<NonNullSupplier<IModuleRenderer>> renderer;

    protected ModuleBuilder(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, Class<? super M> registryType, NonNullSupplier<E> moduleSupplier) {
        super(owner, parent, name, callback, registryType);
        this.moduleSupplier = moduleSupplier;
    }

    public B lang(String name) {
        return (B)((ModuleBuilder)this.lang(Module::getTranslationKey, name));
    }

    public B renderer(NonNullSupplier<NonNullSupplier<IModuleRenderer>> renderer) {
        if (this.renderer == null) {
            DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> this::registerRenderer);
        }
        this.renderer = renderer;
        return this.getSelf();
    }

    protected void registerRenderer() {
        OneTimeEventReceiver.addModListener(FMLClientSetupEvent.class, $ -> {
            NonNullSupplier<NonNullSupplier<IModuleRenderer>> renderer = this.renderer;
            if (renderer != null) {
                TransportClientAPI.registerModuleRenderer((Module)((Object)((Object)this.getEntry())), this.renderer.get().get());
            }
        });
    }

    @Override
    @Nonnull
    @NonnullType
    protected E createEntry() {
        return (E)((Object)((Module)((Object)this.moduleSupplier.get())));
    }

    protected B getSelf() {
        return (B)this;
    }
}

