/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.renderer.boat;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import xyz.brassgoggledcoders.transport.entity.HulledBoatEntity;
import xyz.brassgoggledcoders.transport.model.entity.HulledBoatModel;

public class HulledBoatRender<T extends HulledBoatEntity>
extends EntityRenderer<T> {
    private static final ResourceLocation DEFAULT_BOAT = new ResourceLocation("textures/entity/boat/oak.png");
    private final HulledBoatModel<T> boatModel = new HulledBoatModel();

    public HulledBoatRender(EntityRendererManager renderManager) {
        super(renderManager);
        this.field_76989_e = 0.8f;
    }

    public void render(T entity, float entityYaw, float partialTicks, MatrixStack matrixStack, @Nonnull IRenderTypeBuffer buffer, int packedLight) {
        float f2;
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, 0.375, 0.0);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f - entityYaw));
        float f = (float)entity.func_70268_h() - partialTicks;
        float f1 = entity.func_70271_g() - partialTicks;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f > 0.0f) {
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(MathHelper.func_76126_a((float)f) * f * f1 / 10.0f * (float)entity.func_70267_i()));
        }
        if (!MathHelper.func_180185_a((float)(f2 = entity.func_203056_b(partialTicks)), (float)0.0f)) {
            matrixStack.func_227863_a_(new Quaternion(new Vector3f(1.0f, 0.0f, 1.0f), entity.func_203056_b(partialTicks), true));
        }
        matrixStack.func_227862_a_(-1.0f, -1.0f, 1.0f);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
        this.renderAdditions(entity, entityYaw, partialTicks, matrixStack, buffer, packedLight);
        this.renderBoat(entity, partialTicks, matrixStack, buffer, packedLight);
        matrixStack.func_227865_b_();
        super.func_225623_a_(entity, entityYaw, partialTicks, matrixStack, buffer, packedLight);
    }

    protected void renderAdditions(T entity, float entityYaw, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight) {
    }

    protected void renderBoat(T entity, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight) {
        IVertexBuilder ivertexbuilder = buffer.getBuffer(this.boatModel.func_228282_a_(this.getEntityTexture(entity)));
        this.boatModel.setRotationAngles(entity, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
        this.boatModel.func_225598_a_(matrixStack, ivertexbuilder, packedLight, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        if (!entity.func_204231_K()) {
            IVertexBuilder vertexBuilder = buffer.getBuffer(RenderType.func_228651_i_());
            this.boatModel.func_228245_c_().func_228308_a_(matrixStack, vertexBuilder, packedLight, OverlayTexture.field_229196_a_);
        }
    }

    @Nonnull
    public ResourceLocation getEntityTexture(T entity) {
        ResourceLocation textureLocation = ((HulledBoatEntity)((Object)entity)).getHullType().getEntityTexture((Entity)entity);
        return textureLocation != null ? textureLocation : DEFAULT_BOAT;
    }
}

