/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.repack.registrate.util;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.EventBus;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OneTimeEventReceiver<T extends Event>
implements Consumer<T> {
    private static final Logger log;
    @Nullable
    private static final MethodHandle getBusId;
    private final IEventBus bus;
    private final Consumer<? super T> listener;

    public static <T extends Event> void addModListener(Class<? super T> evtClass, Consumer<? super T> listener) {
        OneTimeEventReceiver.addModListener(EventPriority.NORMAL, evtClass, listener);
    }

    public static <T extends Event> void addModListener(EventPriority priority, Class<? super T> evtClass, Consumer<? super T> listener) {
        OneTimeEventReceiver.addListener(FMLJavaModLoadingContext.get().getModEventBus(), priority, evtClass, listener);
    }

    public static <T extends Event> void addForgeListener(Class<? super T> evtClass, Consumer<? super T> listener) {
        OneTimeEventReceiver.addForgeListener(EventPriority.NORMAL, evtClass, listener);
    }

    public static <T extends Event> void addForgeListener(EventPriority priority, Class<? super T> evtClass, Consumer<? super T> listener) {
        OneTimeEventReceiver.addListener(MinecraftForge.EVENT_BUS, priority, evtClass, listener);
    }

    public static <T extends Event> void addListener(IEventBus bus, Class<? super T> evtClass, Consumer<? super T> listener) {
        OneTimeEventReceiver.addListener(bus, EventPriority.NORMAL, evtClass, listener);
    }

    public static <T extends Event> void addListener(IEventBus bus, EventPriority priority, Class<? super T> evtClass, Consumer<? super T> listener) {
        bus.addListener(priority, false, evtClass, new OneTimeEventReceiver<T>(bus, listener));
    }

    @Override
    public void accept(T event) {
        this.listener.accept(event);
        OneTimeEventReceiver.unregister(this.bus, this, event);
    }

    public static void unregister(IEventBus bus, Object listener, Event event) {
        bus.unregister(listener);
        try {
            MethodHandle mh = getBusId;
            if (mh != null) {
                event.getListenerList().getListeners(mh.invokeExact((EventBus)bus));
            }
        }
        catch (Throwable t) {
            log.warn("Failed to clear listener list of one-time event receiver, so the receiver has leaked. This is not a big deal.", t);
        }
    }

    public OneTimeEventReceiver(IEventBus bus, Consumer<? super T> listener) {
        this.bus = bus;
        this.listener = listener;
    }

    static {
        MethodHandle ret;
        log = LogManager.getLogger(OneTimeEventReceiver.class);
        try {
            ret = MethodHandles.lookup().unreflectGetter(ObfuscationReflectionHelper.findField(EventBus.class, (String)"busID"));
        }
        catch (IllegalAccessException e) {
            log.warn("Failed to set up EventBus reflection to release one-time event listeners, leaks will occur. This is not a big deal.");
            ret = null;
        }
        getBusId = ret;
    }
}

