/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.tileentity.loader;

import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.api.client.IScreenAddonProvider;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.container.addon.IContainerAddon;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import xyz.brassgoggledcoders.transport.capability.itemhandler.ItemHandlerDirectional;
import xyz.brassgoggledcoders.transport.tileentity.loader.BasicLoaderTileEntity;

public class ItemLoaderTileEntity
extends BasicLoaderTileEntity<IItemHandler>
implements IScreenAddonProvider {
    private final InventoryComponent<ItemLoaderTileEntity> inventoryComponent = new InventoryComponent("inventory", 44, 35, 5);
    private final LazyOptional<IItemHandler> internalLazyOptional = LazyOptional.of(() -> this.inventoryComponent);

    public ItemLoaderTileEntity(TileEntityType<ItemLoaderTileEntity> tileEntityType) {
        super(tileEntityType, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
    }

    @Override
    protected void transfer(IItemHandler from, IItemHandler to) {
        int moved = 0;
        int slotNumber = 0;
        do {
            ItemStack itemStack;
            if ((itemStack = from.extractItem(slotNumber, 16, true)).func_190926_b() || !ItemHandlerHelper.insertItem((IItemHandler)to, (ItemStack)itemStack, (boolean)true).func_190926_b()) continue;
            ItemStack movedItemStack = from.extractItem(slotNumber, 16, false);
            moved += movedItemStack.func_190916_E();
            ItemHandlerHelper.insertItem((IItemHandler)to, (ItemStack)movedItemStack, (boolean)false);
        } while (++slotNumber < from.getSlots() && moved < 32);
    }

    @Override
    protected LazyOptional<IItemHandler> getInternalCAP() {
        return this.internalLazyOptional;
    }

    @Override
    protected LazyOptional<IItemHandler> createOutputCAP() {
        return LazyOptional.of(() -> new ItemHandlerDirectional((IItemHandler)this.inventoryComponent, false));
    }

    @Override
    protected LazyOptional<IItemHandler> createInputCAP() {
        return LazyOptional.of(() -> new ItemHandlerDirectional((IItemHandler)this.inventoryComponent, true));
    }

    @Override
    protected CompoundNBT serializeCap() {
        return this.inventoryComponent.serializeNBT();
    }

    @Override
    protected void deserializeCap(CompoundNBT compoundNBT) {
        this.inventoryComponent.deserializeNBT(compoundNBT);
    }

    public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
        return this.inventoryComponent.getScreenAddons();
    }

    public List<IFactory<? extends IContainerAddon>> getContainerAddons() {
        return this.inventoryComponent.getContainerAddons();
    }
}

