/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.client.screen;

import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.api.client.assets.types.IBackgroundAsset;
import com.hrznstudio.titanium.client.screen.IScreenAddonConsumer;
import com.hrznstudio.titanium.client.screen.addon.interfaces.ICanMouseDrag;
import com.hrznstudio.titanium.client.screen.addon.interfaces.IClickable;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.hrznstudio.titanium.util.AssetUtil;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import org.lwjgl.glfw.GLFW;

public abstract class ScreenAddonScreen
extends Screen
implements IScreenAddonConsumer {
    public int x;
    public int y;
    private IAssetProvider assetProvider;
    private List<IScreenAddon> addonList;
    private boolean drawBackground;
    private boolean isMouseDragging;
    private int dragX;
    private int dragY;

    public ScreenAddonScreen(IAssetProvider assetProvider, boolean drawBackground) {
        super((ITextComponent)new StringTextComponent(""));
        this.assetProvider = assetProvider;
        this.drawBackground = drawBackground;
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        IBackgroundAsset background = IAssetProvider.getAsset(this.assetProvider, AssetTypes.BACKGROUND);
        this.x = this.field_230708_k_ / 2 - background.getArea().width / 2;
        this.y = this.field_230709_l_ / 2 - background.getArea().height / 2;
        this.addonList = this.guiAddons().stream().map(IFactory::create).collect(Collectors.toList());
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.pushMatrix();
        this.renderBackground(matrixStack, mouseX, mouseY, partialTicks);
        RenderSystem.popMatrix();
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        RenderSystem.pushMatrix();
        this.renderForeground(matrixStack, mouseX, mouseY, partialTicks);
        RenderSystem.popMatrix();
    }

    public void renderBackground(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        this.checkForMouseDrag(mouseX, mouseY);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.drawBackground) {
            this.func_238651_a_(stack, 0);
            AssetUtil.drawAsset(stack, this, this.assetProvider.getAsset(AssetTypes.BACKGROUND), this.x, this.y);
        }
        this.addonList.forEach(iGuiAddon -> iGuiAddon.drawBackgroundLayer(stack, this, this.assetProvider, this.x, this.y, mouseX, mouseY, partialTicks));
    }

    public void renderForeground(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        this.addonList.forEach(iGuiAddon -> iGuiAddon.drawForegroundLayer(stack, this, this.assetProvider, this.x, this.y, mouseX, mouseY));
        for (IScreenAddon iScreenAddon : this.addonList) {
            if (!iScreenAddon.isInside(this, mouseX - this.x, mouseY - this.y) || iScreenAddon.getTooltipLines().isEmpty()) continue;
            this.func_243308_b(stack, iScreenAddon.getTooltipLines(), mouseX, mouseY);
        }
    }

    public abstract List<IFactory<IScreenAddon>> guiAddons();

    private void checkForMouseDrag(int mouseX, int mouseY) {
        if (GLFW.glfwGetMouseButton((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)0) == 1) {
            if (!this.isMouseDragging) {
                this.isMouseDragging = true;
            } else {
                for (IScreenAddon iScreenAddon : this.addonList) {
                    if (!(iScreenAddon instanceof ICanMouseDrag) || !iScreenAddon.isInside(null, mouseX - this.x, mouseY - this.y)) continue;
                    ((ICanMouseDrag)((Object)iScreenAddon)).drag(mouseX - this.x, mouseY - this.y);
                }
            }
            this.dragX = mouseX;
            this.dragY = mouseY;
        } else {
            this.isMouseDragging = false;
        }
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        super.func_231044_a_(mouseX, mouseY, mouseButton);
        this.addonList.stream().filter(iScreenAddon -> iScreenAddon instanceof IClickable && iScreenAddon.isInside(this, mouseX - (double)this.x, mouseY - (double)this.y)).forEach(iScreenAddon -> ((IClickable)((Object)iScreenAddon)).handleClick(this, this.x, this.y, mouseX, mouseY, mouseButton));
        return false;
    }

    public List<IScreenAddon> getAddons() {
        return this.addonList;
    }
}

