/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.component.inventory;

import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IAsset;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.block.tile.ActiveTile;
import com.hrznstudio.titanium.client.screen.addon.FacingHandlerScreenAddon;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.sideness.IFacingComponent;
import com.hrznstudio.titanium.component.sideness.SidedComponentManager;
import com.hrznstudio.titanium.util.FacingUtil;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.List;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class SidedInventoryComponent<T extends IComponentHarness>
extends InventoryComponent<T>
implements IFacingComponent {
    private int color = DyeColor.WHITE.func_196060_f();
    private int facingHandlerX = 8;
    private int facingHandlerY = 84;
    private HashMap<FacingUtil.Sideness, IFacingComponent.FaceMode> facingModes = new HashMap();
    private HashMap<FacingUtil.Sideness, Integer> slotCache = new HashMap();
    private int position;
    private boolean hasFacingAddon;

    public SidedInventoryComponent(String name, int xPos, int yPos, int size, int position) {
        super(name, xPos, yPos, size);
        for (FacingUtil.Sideness value : FacingUtil.Sideness.values()) {
            this.facingModes.put(value, IFacingComponent.FaceMode.ENABLED);
        }
        this.position = position;
        this.setColorGuiEnabled(true);
        this.hasFacingAddon = true;
    }

    public SidedInventoryComponent<T> disableFacingAddon() {
        this.hasFacingAddon = false;
        return this;
    }

    public HashMap<FacingUtil.Sideness, IFacingComponent.FaceMode> getFacingModes() {
        return this.facingModes;
    }

    @Override
    public int getColor() {
        return new Color(this.color).getRGB();
    }

    public SidedInventoryComponent<T> setColor(int color) {
        this.color = color;
        return this;
    }

    public SidedInventoryComponent<T> setColor(DyeColor color) {
        this.color = color.getColorValue();
        return this;
    }

    @Override
    public Color getColorForSlotRendering(int slot) {
        return this.getSlotToColorRenderMap().getOrDefault(slot, new Color(this.color));
    }

    @Override
    public Rectangle getRectangle(IAsset asset) {
        int renderingOffset = 1;
        Rectangle rectangle = new Rectangle((Integer)this.getSlotPosition().apply(0).getLeft() - 1, (Integer)this.getSlotPosition().apply(0).getRight() - 1, (int)asset.getArea().getWidth() + (Integer)this.getSlotPosition().apply(0).getLeft(), (int)asset.getArea().getHeight() + (Integer)this.getSlotPosition().apply(0).getRight());
        for (int i = 0; i < this.getSlots(); ++i) {
            if ((double)((Integer)this.getSlotPosition().apply(i).getLeft()).intValue() < rectangle.getX()) {
                rectangle.setLocation((Integer)this.getSlotPosition().apply(i).getLeft(), rectangle.y);
            }
            if ((double)((Integer)this.getSlotPosition().apply(i).getRight()).intValue() < rectangle.getY()) {
                rectangle.setLocation(rectangle.x, (Integer)this.getSlotPosition().apply(i).getRight());
            }
            if ((double)((Integer)this.getSlotPosition().apply(i).getLeft()).intValue() + asset.getArea().getWidth() > (double)rectangle.width) {
                rectangle.setSize((Integer)this.getSlotPosition().apply(i).getLeft() + asset.getArea().width, rectangle.height);
            }
            if (!((double)((Integer)this.getSlotPosition().apply(i).getRight()).intValue() + asset.getArea().getHeight() > (double)rectangle.height)) continue;
            rectangle.setSize(rectangle.width, (Integer)this.getSlotPosition().apply(i).getRight() + asset.getArea().height);
        }
        return new Rectangle(this.getXPos() - renderingOffset - 2 + rectangle.x, this.getYPos() - renderingOffset - 2 + rectangle.y, rectangle.width + renderingOffset * 2 + 3, rectangle.height + renderingOffset * 2 + 3);
    }

    @Override
    public int getFacingHandlerX() {
        return this.facingHandlerX;
    }

    @Override
    public int getFacingHandlerY() {
        return this.facingHandlerY;
    }

    @Override
    public boolean work(World world, BlockPos pos, Direction blockFacing, int workAmount) {
        boolean hasWorked;
        Direction real;
        TileEntity entity;
        for (FacingUtil.Sideness sideness : this.facingModes.keySet()) {
            if (!this.facingModes.get((Object)sideness).equals((Object)IFacingComponent.FaceMode.PUSH) || (entity = world.func_175625_s(pos.func_177972_a(real = FacingUtil.getFacingFromSide(blockFacing, sideness)))) == null || !(hasWorked = entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, real.func_176734_d()).map(iItemHandler -> this.transfer(sideness, (IItemHandler)this, (IItemHandler)iItemHandler, workAmount)).orElse(false).booleanValue())) continue;
            return true;
        }
        for (FacingUtil.Sideness sideness : this.facingModes.keySet()) {
            if (!this.facingModes.get((Object)sideness).equals((Object)IFacingComponent.FaceMode.PULL) || (entity = world.func_175625_s(pos.func_177972_a(real = FacingUtil.getFacingFromSide(blockFacing, sideness)))) == null || !(hasWorked = entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, real.func_176734_d()).map(iItemHandler -> this.transfer(sideness, (IItemHandler)iItemHandler, (IItemHandler)this, workAmount)).orElse(false).booleanValue())) continue;
            return true;
        }
        return false;
    }

    @Override
    public SidedInventoryComponent<T> setFacingHandlerPos(int x, int y) {
        this.facingHandlerX = x;
        this.facingHandlerY = y;
        return this;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = super.serializeNBT();
        CompoundNBT compound = new CompoundNBT();
        for (FacingUtil.Sideness facing : this.facingModes.keySet()) {
            compound.func_74778_a(facing.name(), this.facingModes.get((Object)facing).name());
        }
        nbt.func_218657_a("FacingModes", (INBT)compound);
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        super.deserializeNBT(nbt);
        if (nbt.func_74764_b("FacingModes")) {
            CompoundNBT compound = nbt.func_74775_l("FacingModes");
            for (String face : compound.func_150296_c()) {
                this.facingModes.put(FacingUtil.Sideness.valueOf(face), IFacingComponent.FaceMode.valueOf(compound.func_74779_i(face)));
            }
        }
    }

    @Override
    public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
        List<IFactory<? extends IScreenAddon>> addons = super.getScreenAddons();
        if (this.hasFacingAddon) {
            addons.add(() -> new FacingHandlerScreenAddon(SidedComponentManager.ofRight(this.getFacingHandlerX(), this.getFacingHandlerY(), this.position, AssetTypes.BUTTON_SIDENESS_MANAGER, 4), this, AssetTypes.SLOT, this.getComponentHarness() instanceof ActiveTile ? ((ActiveTile)this.getComponentHarness()).getFacingDirection() : Direction.NORTH));
        }
        return addons;
    }

    private int getNextSlot(IItemHandler handler, int currentSlot) {
        for (int i = currentSlot; i < handler.getSlots(); ++i) {
            if (handler.getStackInSlot(i).func_190926_b()) continue;
            return i;
        }
        return 0;
    }

    private boolean transfer(FacingUtil.Sideness sideness, IItemHandler from, IItemHandler to, int workAmount) {
        if (from.getSlots() <= 0) {
            return false;
        }
        int slot = this.slotCache.getOrDefault((Object)sideness, this.getNextSlot(from, 0));
        if (slot >= from.getSlots()) {
            slot = 0;
        }
        ItemStack extracted = from.extractItem(slot, workAmount, true);
        int outSlot = this.isValidForAnySlot(to, extracted);
        if (!extracted.func_190926_b() && outSlot != -1) {
            ItemStack returned = to.insertItem(outSlot, extracted, false);
            return !from.extractItem(slot, extracted.func_190916_E() - returned.func_190916_E(), false).func_190926_b();
        }
        this.slotCache.put(sideness, this.getNextSlot(from, slot + 1));
        return false;
    }

    private int isValidForAnySlot(IItemHandler dest, ItemStack stack) {
        for (int i = 0; i < dest.getSlots(); ++i) {
            if (!dest.isItemValid(i, stack)) continue;
            if (dest.getStackInSlot(i).func_190926_b()) {
                return i;
            }
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)dest.getStackInSlot(i), (ItemStack)stack) || dest.getStackInSlot(i).func_190916_E() >= dest.getSlotLimit(i) || dest.getStackInSlot(i).func_190916_E() >= dest.getStackInSlot(i).func_77976_d()) continue;
            return i;
        }
        return -1;
    }
}

