/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.container;

import com.hrznstudio.titanium.Titanium;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.client.screen.asset.DefaultAssetProvider;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.hrznstudio.titanium.client.screen.asset.IHasAssetProvider;
import com.hrznstudio.titanium.container.IObjectContainer;
import com.hrznstudio.titanium.container.addon.IContainerAddonProvider;
import com.hrznstudio.titanium.container.addon.UpdatableSlotItemHandler;
import com.hrznstudio.titanium.container.impl.BasicInventoryContainer;
import com.hrznstudio.titanium.network.locator.ILocatable;
import com.hrznstudio.titanium.network.locator.LocatorFactory;
import com.hrznstudio.titanium.network.locator.LocatorInstance;
import com.hrznstudio.titanium.network.locator.instance.EmptyLocatorInstance;
import com.hrznstudio.titanium.network.locator.instance.HeldStackLocatorInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.world.World;
import net.minecraftforge.registries.ObjectHolder;

public class BasicAddonContainer
extends BasicInventoryContainer
implements IObjectContainer,
ILocatable {
    @ObjectHolder(value="titanium:addon_container")
    public static ContainerType<BasicAddonContainer> TYPE;
    private final IWorldPosCallable worldPosCallable;
    private final Object provider;
    private final LocatorInstance locatorInstance;

    public BasicAddonContainer(Object provider, LocatorInstance locatorInstance, IWorldPosCallable worldPosCallable, PlayerInventory playerInventory, int containerId) {
        this(provider, locatorInstance, TYPE, worldPosCallable, playerInventory, containerId);
    }

    public BasicAddonContainer(Object provider, LocatorInstance locatorInstance, ContainerType<?> containerType, IWorldPosCallable worldPosCallable, PlayerInventory playerInventory, int containerId) {
        super(containerType, playerInventory, containerId, BasicAddonContainer.findAssetProvider(provider));
        this.worldPosCallable = worldPosCallable;
        this.provider = provider;
        this.locatorInstance = locatorInstance;
        if (this.provider instanceof IContainerAddonProvider) {
            ((IContainerAddonProvider)this.provider).getContainerAddons().stream().map(IFactory::create).forEach(containAddon -> {
                containAddon.getSlots().forEach(arg_0 -> ((BasicAddonContainer)this).func_75146_a(arg_0));
                containAddon.getIntReferenceHolders().forEach(arg_0 -> ((BasicAddonContainer)this).func_216958_a(arg_0));
                containAddon.getIntArrayReferenceHolders().forEach(arg_0 -> ((BasicAddonContainer)this).func_216961_a(arg_0));
            });
        }
        this.initInventory();
    }

    private static IAssetProvider findAssetProvider(Object provider) {
        if (provider instanceof IHasAssetProvider) {
            return ((IHasAssetProvider)provider).getAssetProvider();
        }
        return DefaultAssetProvider.DEFAULT_PROVIDER;
    }

    @Override
    public boolean func_75145_c(PlayerEntity playerIn) {
        return (Boolean)this.worldPosCallable.func_221485_a((world, blockPos) -> playerIn.func_70092_e((double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o() + 0.5, (double)blockPos.func_177952_p() + 0.5) <= 64.0, (Object)true);
    }

    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, PlayerEntity player) {
        if (this.locatorInstance instanceof HeldStackLocatorInstance && (((HeldStackLocatorInstance)this.locatorInstance).isMainHand() ? player.field_71071_by.field_70461_c == slotId - 27 : slotId == 40)) {
            return ItemStack.field_190927_a;
        }
        return super.func_184996_a(slotId, dragType, clickTypeIn, player);
    }

    public static BasicAddonContainer create(int id, PlayerInventory inventory, PacketBuffer packetBuffer) {
        LocatorInstance instance = LocatorFactory.readPacketBuffer(packetBuffer);
        if (instance != null) {
            PlayerEntity playerEntity = inventory.field_70458_d;
            World world = playerEntity.func_130014_f_();
            BasicAddonContainer container = instance.locale(playerEntity).map(located -> new BasicAddonContainer(located, instance, instance.getWorldPosCallable(world), inventory, id)).orElse(null);
            if (container != null) {
                return container;
            }
        }
        Titanium.LOGGER.error("Failed to find locate instance to create Container for");
        return new BasicAddonContainer(new Object(), new EmptyLocatorInstance(), IWorldPosCallable.field_221489_a, inventory, id);
    }

    public Object getProvider() {
        return this.provider;
    }

    @Override
    public Object getObject() {
        return this.getProvider();
    }

    @Override
    public LocatorInstance getLocatorInstance() {
        return this.locatorInstance;
    }

    public void update() {
        this.field_75151_b.stream().filter(slot -> slot instanceof UpdatableSlotItemHandler).forEach(slot -> ((UpdatableSlotItemHandler)((Object)slot)).update());
    }
}

