/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.travellers_map.features;

import java.util.AbstractQueue;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.dark_roleplay.travellers_map.features.MappingHelper;
import net.dark_roleplay.travellers_map.features.mappers.Mapper;
import net.dark_roleplay.travellers_map.objects.data.ChunkLoadedTicket;
import net.dark_roleplay.travellers_map.util.MapManager;
import net.dark_roleplay.travellers_map.util.MapSegment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.concurrent.ThreadTaskExecutor;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunk;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;

public final class MapperQueue {
    private final Mapper mapper;
    private final AbstractQueue<ChunkPos> newChunksQueue = new ConcurrentLinkedQueue<ChunkPos>();
    private final AbstractQueue<ChunkPos> periodicalChunksQueue = new ConcurrentLinkedQueue<ChunkPos>();
    private TimerTask periodicTask;

    public MapperQueue(Mapper mapper) {
        this.mapper = mapper;
    }

    public void stopMapper() {
        this.newChunksQueue.clear();
        this.periodicalChunksQueue.clear();
    }

    public void initTimer(Timer timer) {
    }

    public void scheduleLoadedChunk(ChunkPos pos) {
        this.newChunksQueue.add(pos);
    }

    public void schedulePeriodicalChunk(ChunkPos pos) {
        this.periodicalChunksQueue.add(pos);
    }

    public void processLoadedChunksQueue() {
        if (Minecraft.func_71410_x().field_71441_e == null) {
            MappingHelper.killMapper();
            return;
        }
        MapperQueue.enqueToMainThread(() -> {
            ClientWorld world = Minecraft.func_71410_x().field_71441_e;
            for (int i = 0; i < this.mapper.getMaxChunksPerRun() && !this.newChunksQueue.isEmpty(); ++i) {
                ChunkPos pos = this.newChunksQueue.remove();
                if (world.func_217354_b(pos.field_77276_a, pos.field_77275_b)) {
                    Chunk chunk = world.func_212866_a_(pos.field_77276_a, pos.field_77275_b);
                    if (this.mapper.canMapChunk((World)world, (IChunk)chunk)) {
                        ChunkLoadedTicket ticket = ChunkLoadedTicket.loadChunk((IChunk)chunk);
                        MapSegment segment = MapManager.getOrCreateMapSegment((IChunk)chunk, ticket);
                        if (segment == null) {
                            return;
                        }
                        segment.updateChunk((World)world, (IChunk)chunk);
                        segment.markDirty();
                        continue;
                    }
                    this.newChunksQueue.add(pos);
                    continue;
                }
                --i;
            }
        });
    }

    private static void enqueToMainThread(Runnable runnable) {
        ThreadTaskExecutor executor = (ThreadTaskExecutor)LogicalSidedProvider.WORKQUEUE.get(LogicalSide.CLIENT);
        if (!executor.func_213162_bc()) {
            executor.func_213165_a(runnable);
        } else {
            runnable.run();
        }
    }
}

