/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.travellers_map.features;

import java.util.HashSet;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import net.dark_roleplay.travellers_map.features.MapperQueue;
import net.dark_roleplay.travellers_map.features.mappers.LightingColorMapper;
import net.minecraft.util.math.ChunkPos;

public class MappingHelper {
    private static final Set<MapperQueue> activeMappers = new HashSet<MapperQueue>();
    private static Timer chunkMapper;

    public static void initMapper() {
        activeMappers.add(new MapperQueue(LightingColorMapper.INSTANCE));
        chunkMapper = new Timer("TravellersMap - Chunk Mapper", true);
        chunkMapper.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                for (MapperQueue mapper : activeMappers) {
                    mapper.processLoadedChunksQueue();
                }
            }
        }, 250L, 250L);
        for (MapperQueue mapper : activeMappers) {
            mapper.initTimer(chunkMapper);
        }
    }

    public static void killMapper() {
        chunkMapper.cancel();
        for (MapperQueue mapper : activeMappers) {
            mapper.stopMapper();
        }
    }

    public static void scheduleLoadedChunk(ChunkPos pos) {
        for (MapperQueue mapper : activeMappers) {
            mapper.scheduleLoadedChunk(pos);
        }
    }

    public static void schedulePeriodicalChunk(ChunkPos pos) {
        for (MapperQueue mapper : activeMappers) {
            mapper.schedulePeriodicalChunk(pos);
        }
    }
}

