/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.travellers_map.features.mappers;

import net.dark_roleplay.travellers_map.features.color_palettes.ColorPalette;
import net.dark_roleplay.travellers_map.features.color_palettes.DefaultColorPalette;
import net.dark_roleplay.travellers_map.features.color_palettes.MonoColorPalette;
import net.dark_roleplay.travellers_map.features.mappers.Mapper;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.Heightmap;

public class LightingColorMapper
extends Mapper {
    public static Mapper INSTANCE = new LightingColorMapper(new DefaultColorPalette());
    public static Mapper INSTANCE_GRAYSCALE = new LightingColorMapper(new MonoColorPalette());
    private ColorPalette palette;

    public LightingColorMapper(ColorPalette palette) {
        this.palette = palette;
    }

    @Override
    public void mapChunk(World world, IChunk chunk, NativeImage img) {
        ChunkPos chunkPos = chunk.func_76632_l();
        BlockPos.PooledMutable pos = BlockPos.PooledMutable.func_185346_s();
        int x = Math.floorMod(chunkPos.field_77276_a, 32) * 16;
        int z = Math.floorMod(chunkPos.field_77275_b, 32) * 16;
        for (int x2 = 0; x2 < 16; ++x2) {
            for (int z2 = 0; z2 < 16; ++z2) {
                int y = chunk.func_201576_a(Heightmap.Type.WORLD_SURFACE, x2, z2);
                BlockState state = chunk.func_180495_p((BlockPos)pos.func_181079_c(chunkPos.field_77276_a << 4 | x2, y, chunkPos.field_77275_b << 4 | z2));
                MaterialColor color = state.func_185909_g((IBlockReader)Minecraft.func_71410_x().field_71441_e, (BlockPos)pos);
                if (color == null) continue;
                int brightness = 1;
                if (world.func_180495_p(pos.func_177982_a(0, 1, -1)).func_185909_g((IBlockReader)world, (BlockPos)pos) != MaterialColor.field_151660_b) {
                    --brightness;
                } else if (world.func_180495_p(pos.func_177982_a(0, -1, 0)).func_185909_g((IBlockReader)world, (BlockPos)pos) == MaterialColor.field_151660_b) {
                    ++brightness;
                }
                img.func_195700_a(x + x2, z + z2, this.palette.getRGBA(color.field_76290_q, brightness));
            }
        }
        pos.close();
    }

    @Override
    public int getMappingInterval() {
        return 1000;
    }

    @Override
    public int getMaxChunksPerRun() {
        return 20;
    }

    @Override
    public boolean canMapChunk(World world, IChunk chunk) {
        return world.func_217354_b(chunk.func_76632_l().field_77276_a, chunk.func_76632_l().field_77275_b - 1);
    }
}

