/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.travellers_map.objects.huds.minimap;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashSet;
import java.util.Set;
import net.dark_roleplay.travellers_map.util.MapManager;
import net.dark_roleplay.travellers_map.util.MapSegment;
import net.dark_roleplay.travellers_map.util.MapSegmentUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class MinimapHUD
extends AbstractGui {
    public static final MinimapHUD INSTANCE = new MinimapHUD();
    private static ResourceLocation MINIMAP_TEXTURES = new ResourceLocation("travellers_map", "textures/guis/minimaps.png");
    private float[] zoomLevels = new float[]{2.0f, 1.0f, 0.5f, 0.25f};
    private int currentZoomLevel = 1;
    private int width;
    private int height;
    private final Set<MapSegment> segments = new HashSet<MapSegment>();

    private MinimapHUD() {
    }

    public void render(int mouseX, int mouseY, float delta) {
        int centerX = this.width - 33;
        int centerY = 33;
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        BlockPos playerPos = player.func_180425_c();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableAlphaTest();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(MINIMAP_TEXTURES);
        MinimapHUD.blit2(centerX - 32, centerY - 32, 64, 64, 0.0f, 0.0f, 64, 64, 256, 256);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.pushMatrix();
        RenderSystem.enableDepthTest();
        RenderSystem.translatef((float)0.0f, (float)0.0f, (float)950.0f);
        RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        MinimapHUD.fill((int)4680, (int)2260, (int)-4680, (int)-2260, (int)-1);
        RenderSystem.translatef((float)0.0f, (float)0.0f, (float)-950.0f);
        RenderSystem.depthFunc((int)518);
        MinimapHUD.blit((int)(centerX - 32), (int)(centerY - 32), (int)64, (int)64, (float)64.0f, (float)0.0f, (int)64, (int)64, (int)256, (int)256);
        RenderSystem.depthFunc((int)515);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        this.segments.clear();
        this.getAndDrawMapSegment((PlayerEntity)player, centerX, centerY, 0, 0);
        this.getAndDrawMapSegment((PlayerEntity)player, centerX, centerY, -128, 0);
        this.getAndDrawMapSegment((PlayerEntity)player, centerX, centerY, 128, 0);
        this.getAndDrawMapSegment((PlayerEntity)player, centerX, centerY, 0, -128);
        this.getAndDrawMapSegment((PlayerEntity)player, centerX, centerY, 0, 128);
        this.getAndDrawMapSegment((PlayerEntity)player, centerX, centerY, -128, -128);
        this.getAndDrawMapSegment((PlayerEntity)player, centerX, centerY, -128, 128);
        this.getAndDrawMapSegment((PlayerEntity)player, centerX, centerY, 128, -128);
        this.getAndDrawMapSegment((PlayerEntity)player, centerX, centerY, 128, 128);
        RenderSystem.depthFunc((int)518);
        RenderSystem.translatef((float)0.0f, (float)0.0f, (float)-950.0f);
        RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        MinimapHUD.fill((int)4680, (int)2260, (int)-4680, (int)-2260, (int)-16777216);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.translatef((float)0.0f, (float)0.0f, (float)950.0f);
        RenderSystem.depthFunc((int)515);
        RenderSystem.popMatrix();
        this.drawPlayerMarker(centerX, centerY);
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    private void getAndDrawMapSegment(PlayerEntity player, int centerX, int centerY, int offsetX, int offsetZ) {
        MapSegment map = MapManager.getMapSegment(MapSegmentUtil.getSegment(player.func_180425_c().func_177982_a(offsetX, 0, offsetZ)));
        if (map != null && !this.segments.contains(map)) {
            this.segments.add(map);
            this.drawMapSegment(map, player.func_213303_ch(), centerX, centerY, offsetX, offsetZ);
        }
    }

    private void drawMapSegment(MapSegment map, Vec3d playerPos, int centerX, int centerY, int offsetX, int offsetZ) {
        map.getDynTexture().func_229148_d_();
        map.updadteGPU();
        int offset = (int)(128.0f * this.zoomLevels[this.currentZoomLevel]);
        int size = (int)(256.0f * this.zoomLevels[this.currentZoomLevel]);
        double relativeX = (playerPos.field_72450_a - (double)(((int)playerPos.field_72450_a + offsetX >> 9) * 512) - 256.0) * (double)(0.5f * this.zoomLevels[this.currentZoomLevel]);
        double relativeZ = (playerPos.field_72449_c - (double)(((int)playerPos.field_72449_c + offsetZ >> 9) * 512) - 256.0) * (double)(0.5f * this.zoomLevels[this.currentZoomLevel]);
        MinimapHUD.blit2((double)(centerX - offset) - relativeX, (double)(centerY - offset) - relativeZ, size, size, 0.0f, 0.0f, 256, 256, 256, 256);
    }

    private void drawPlayerMarker(int centerX, int centerY) {
        this.hLine(centerX - 3, centerX + 1, centerY, -1);
        this.vLine(centerX - 1, centerY - 3, centerY + 3, -1);
    }

    public static void blit2(double x0, double y0, int destWidth, int destHeight, float u0, float v0, int srcWidth, int srcHeight, int texWidth, int texHeight) {
        MinimapHUD.innerBlit2(x0, x0 + (double)destWidth, y0, y0 + (double)destHeight, 0, srcWidth, srcHeight, u0, v0, texWidth, texHeight);
    }

    private static void innerBlit2(double x0, double x1, double y0, double y1, int z, int width, int height, float u0, float v0, int texWidth, int texHeight) {
        MinimapHUD.innerBlit2(x0, x1, y0, y1, z, (u0 + 0.0f) / (float)texWidth, (u0 + (float)width) / (float)texWidth, (v0 + 0.0f) / (float)texHeight, (v0 + (float)height) / (float)texHeight);
    }

    protected static void innerBlit2(double x0, double x1, double y0, double y1, int z, float u0, float u1, float v0, float v1) {
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_225582_a_(x0, y1, (double)z).func_225583_a_(u0, v1).func_181675_d();
        bufferbuilder.func_225582_a_(x1, y1, (double)z).func_225583_a_(u1, v1).func_181675_d();
        bufferbuilder.func_225582_a_(x1, y0, (double)z).func_225583_a_(u1, v0).func_181675_d();
        bufferbuilder.func_225582_a_(x0, y0, (double)z).func_225583_a_(u0, v0).func_181675_d();
        bufferbuilder.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
    }

    public static void increaseZoom() {
        MinimapHUD.INSTANCE.currentZoomLevel = Math.max(0, MinimapHUD.INSTANCE.currentZoomLevel - 1);
    }

    public static void decreaseZoom() {
        MinimapHUD.INSTANCE.currentZoomLevel = Math.min(3, MinimapHUD.INSTANCE.currentZoomLevel + 1);
    }
}

