/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.travellers_map.util;

import java.io.File;
import java.net.SocketAddress;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.dark_roleplay.travellers_map.features.MappingHelper;
import net.dark_roleplay.travellers_map.objects.data.IMapSegmentTicket;
import net.dark_roleplay.travellers_map.util.IOHandler;
import net.dark_roleplay.travellers_map.util.MapSegment;
import net.dark_roleplay.travellers_map.util.MapSegmentUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.world.chunk.IChunk;

public class MapManager {
    private static UUID WORLD_UUID = null;
    private static File WORLD_FOLDER = null;
    private static Map<Long, MapSegment> MAPS = new ConcurrentHashMap<Long, MapSegment>();

    public static void setUpWorldUUIDForRemote() {
        SocketAddress adress = Minecraft.func_71410_x().func_110437_J().address();
        System.out.println(adress);
    }

    public static void setWorldUUID(UUID uuid) {
        WORLD_UUID = uuid;
        WORLD_FOLDER = IOHandler.getOrCreateUniqueFolder(uuid);
        MAPS.clear();
        MappingHelper.initMapper();
    }

    public static MapSegment getMapSegment(long ident) {
        return MAPS.get(ident);
    }

    public static MapSegment getOrCreateMapSegment(IChunk chunk, IMapSegmentTicket ticket) {
        if (WORLD_FOLDER == null) {
            return null;
        }
        int segmentX = chunk.func_76632_l().field_77276_a >> 5;
        int segmentZ = chunk.func_76632_l().field_77275_b >> 5;
        long segmentIdentifier = MapSegmentUtil.getSegment(chunk);
        MapSegment segment = MAPS.get(segmentIdentifier);
        if (segment == null) {
            String name = "m_" + segmentX + "_" + segmentZ;
            File mapFile = new File(WORLD_FOLDER, name + ".png");
            segment = new MapSegment(name, mapFile, segmentIdentifier, new IMapSegmentTicket[0]);
            MAPS.put(segmentIdentifier, segment);
        }
        segment.addTicket(ticket);
        return segment;
    }

    public static void performUpdates() {
        for (MapSegment segment : MAPS.values()) {
            segment.update();
        }
    }

    public static void freeMapSegment(long ident) {
        if (MAPS.containsKey(ident)) {
            MAPS.remove(ident);
        }
    }
}

