/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.travellers_map.util;

import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.dark_roleplay.travellers_map.features.mappers.LightingColorMapper;
import net.dark_roleplay.travellers_map.objects.data.IMapSegmentTicket;
import net.dark_roleplay.travellers_map.util.MapManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunk;

public class MapSegment {
    private File mapFile;
    private long identifier;
    private DynamicTexture dynTexture;
    private NativeImage mapImage;
    private ResourceLocation mapLocation;
    private Set<IMapSegmentTicket> tickets = new HashSet<IMapSegmentTicket>();
    boolean dirtyIO = false;
    boolean dirtyGPU = false;
    private String segmentName;

    public MapSegment(String segmentName, File mapFile, long identifier, IMapSegmentTicket ... tickets) {
        this.segmentName = segmentName;
        this.mapFile = mapFile;
        this.identifier = identifier;
        try {
            this.mapImage = mapFile.exists() ? NativeImage.func_195713_a((InputStream)new FileInputStream(mapFile)) : new NativeImage(NativeImage.PixelFormat.RGBA, 512, 512, true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (IMapSegmentTicket ticket : tickets) {
            this.tickets.add(ticket);
        }
    }

    public void addTicket(IMapSegmentTicket ticket) {
        this.tickets.add(ticket);
    }

    public DynamicTexture getDynTexture() {
        if (this.dynTexture == null) {
            this.dynTexture = new DynamicTexture(this.mapImage);
            this.mapLocation = Minecraft.func_71410_x().func_110434_K().func_110578_a(this.segmentName, this.dynTexture);
        }
        return this.dynTexture;
    }

    public void updateChunk(World world, IChunk chunk) {
        LightingColorMapper.INSTANCE.mapChunk(world, chunk, this.mapImage);
    }

    public void markDirty() {
        this.dirtyIO = true;
        this.dirtyGPU = true;
    }

    public void updadteGPU() {
        if (this.dirtyGPU) {
            this.dynTexture.func_110564_a();
            this.dirtyGPU = false;
        }
    }

    public void update() {
        if (this.dirtyIO) {
            try {
                this.mapImage.func_209271_a(this.mapFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.dirtyIO = false;
        }
        Iterator<IMapSegmentTicket> iter = this.tickets.iterator();
        while (iter.hasNext()) {
            if (iter.next().isActive()) continue;
            iter.remove();
        }
        if (this.tickets.isEmpty()) {
            this.free();
        }
    }

    public void free() {
        RenderSystem.recordRenderCall(() -> Minecraft.func_71410_x().func_110434_K().func_147645_c(this.mapLocation));
        MapManager.freeMapSegment(this.identifier);
    }
}

