/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified;

import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.carver.WorldCarver;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.telepathicgrunt.ultraamplified.ClientEvents;
import net.telepathicgrunt.ultraamplified.blocks.BlockColorManager;
import net.telepathicgrunt.ultraamplified.blocks.UABlocks;
import net.telepathicgrunt.ultraamplified.capabilities.CapabilityPlayerPosAndDim;
import net.telepathicgrunt.ultraamplified.config.UAConfig;
import net.telepathicgrunt.ultraamplified.utils.ConfigHelper;
import net.telepathicgrunt.ultraamplified.world.biome.UABiomes;
import net.telepathicgrunt.ultraamplified.world.biome.surfacebuilder.UASurfaceBuilders;
import net.telepathicgrunt.ultraamplified.world.dimension.TimeSyncNetworkPacket;
import net.telepathicgrunt.ultraamplified.world.feature.ContainUndergroundLiquids;
import net.telepathicgrunt.ultraamplified.world.feature.GlowPatch;
import net.telepathicgrunt.ultraamplified.world.feature.UAFeatures;
import net.telepathicgrunt.ultraamplified.world.feature.carver.CaveCavityCarver;
import net.telepathicgrunt.ultraamplified.world.feature.carver.RavineCarver;
import net.telepathicgrunt.ultraamplified.world.feature.carver.SuperLongRavineCarver;
import net.telepathicgrunt.ultraamplified.world.feature.carver.UACarvers;
import net.telepathicgrunt.ultraamplified.world.feature.carver.UnderwaterCaveCarver;
import net.telepathicgrunt.ultraamplified.world.feature.placement.UAPlacements;
import net.telepathicgrunt.ultraamplified.world.worldtypes.UAWorldType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="ultra_amplified_dimension")
public class UltraAmplified {
    public static final String MODID = "ultra_amplified_dimension";
    public static final Logger LOGGER = LogManager.getLogger((String)"ultra_amplified_dimension");
    public static UAConfig.UAConfigValues UAConfig = null;
    public static WorldType UltraAmplifiedWorldType;

    public UltraAmplified() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        modEventBus.addListener(this::setup);
        modEventBus.register((Object)new BlockColorManager());
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> ClientEvents.subscribeClientEvents(modEventBus, forgeBus));
        UAConfig = ConfigHelper.register(ModConfig.Type.SERVER, (builder, subscriber) -> new UAConfig.UAConfigValues((ForgeConfigSpec.Builder)builder, (ConfigHelper.Subscriber)subscriber));
    }

    public void setup(FMLCommonSetupEvent event) {
        TimeSyncNetworkPacket.init();
        UltraAmplifiedWorldType = new UAWorldType();
        CapabilityPlayerPosAndDim.register();
        RavineCarver.setFillerMap();
        SuperLongRavineCarver.setFillerMap();
        SuperLongRavineCarver.setLavaFloorMap();
        UnderwaterCaveCarver.setFillerMap();
        CaveCavityCarver.setFillerMap();
        CaveCavityCarver.setLavaFloorMap();
        GlowPatch.setFillerMap();
        ContainUndergroundLiquids.setFillerMap();
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void registerBiomes(RegistryEvent.Register<Biome> event) {
            UABiomes.registerBiomes(event);
        }

        @SubscribeEvent
        public static void onRegisterBlocks(RegistryEvent.Register<Block> event) {
            UABlocks.registerBlocks(event);
        }

        @SubscribeEvent
        public static void onRegisterItems(RegistryEvent.Register<Item> event) {
            UABlocks.registerBlockItems(event);
        }

        @SubscribeEvent
        public static void onRegisterFeatures(RegistryEvent.Register<Feature<?>> event) {
            UAFeatures.registerFeatures(event);
        }

        @SubscribeEvent
        public static void onRegisterPlacements(RegistryEvent.Register<Placement<?>> event) {
            UAPlacements.registerPlacements(event);
        }

        @SubscribeEvent
        public static void onRegisterSurfacebuilders(RegistryEvent.Register<SurfaceBuilder<?>> event) {
            UASurfaceBuilders.registerSurfaceBuilders(event);
        }

        @SubscribeEvent
        public static void onRegisterCarvers(RegistryEvent.Register<WorldCarver<?>> event) {
            UACarvers.registerCarvers(event);
        }
    }
}

