/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.config;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;
import net.telepathicgrunt.ultraamplified.utils.ConfigHelper;

@Mod.EventBusSubscriber
public class UAConfig {

    public static class UAConfigValues {
        public ConfigHelper.ConfigValueListener<Boolean> importModdedFeatures;
        public ConfigHelper.ConfigValueListener<Boolean> importModdedStructure;
        public ConfigHelper.ConfigValueListener<Boolean> importModdedMobs;
        public ConfigHelper.ConfigValueListener<Boolean> importOverworldModdedBiomes;
        public ConfigHelper.ConfigValueListener<Boolean> importAllModdedBiomes;
        public ConfigHelper.ConfigValueListener<String> blacklistedBiomeList;
        public ConfigHelper.ConfigValueListener<String> blacklistedStructureList;
        public ConfigHelper.ConfigValueListener<Double> xzTerrainModifier;
        public ConfigHelper.ConfigValueListener<Double> xzScaleModifier;
        public ConfigHelper.ConfigValueListener<Double> yTerrainModifier;
        public ConfigHelper.ConfigValueListener<Double> yScaleModifier;
        public ConfigHelper.ConfigValueListener<Integer> yMaximum;
        public ConfigHelper.ConfigValueListener<Boolean> secretSetting;
        public ConfigHelper.ConfigValueListener<Boolean> bedExplodes;
        public ConfigHelper.ConfigValueListener<Boolean> heavyFog;
        public ConfigHelper.ConfigValueListener<Boolean> forceExitToOverworld;
        public ConfigHelper.ConfigValueListener<Boolean> allowNetherPortal;
        public ConfigHelper.ConfigValueListener<String> portalActivationItem;
        public ConfigHelper.ConfigValueListener<String> portalCornerBlocks;
        public ConfigHelper.ConfigValueListener<String> portalCeilingBlocks;
        public ConfigHelper.ConfigValueListener<String> portalFloorBlocks;
        public ConfigHelper.ConfigValueListener<Integer> coalOreSpawnrate;
        public ConfigHelper.ConfigValueListener<Integer> ironOreSpawnrate;
        public ConfigHelper.ConfigValueListener<Integer> redstoneOreSpawnrate;
        public ConfigHelper.ConfigValueListener<Integer> lapisOreSpawnrate;
        public ConfigHelper.ConfigValueListener<Integer> diamondOreSpawnrate;
        public ConfigHelper.ConfigValueListener<Integer> goldOreSpawnrate;
        public ConfigHelper.ConfigValueListener<Integer> emeraldOreSpawnrate;
        public ConfigHelper.ConfigValueListener<Integer> silverfishSpawnrate;
        public ConfigHelper.ConfigValueListener<Integer> quartzOreSpawnrate;
        public ConfigHelper.ConfigValueListener<Integer> glowstoneSpawnrate;
        public ConfigHelper.ConfigValueListener<Integer> magmaSpawnrate;
        public ConfigHelper.ConfigValueListener<Integer> lavaSpawnrate;
        public ConfigHelper.ConfigValueListener<Integer> glowstoneVariantsSpawnrate;
        public ConfigHelper.ConfigValueListener<Boolean> rootGen;
        public ConfigHelper.ConfigValueListener<Integer> dungeonSpawnrate;
        public ConfigHelper.ConfigValueListener<Integer> ravineSpawnrate;
        public ConfigHelper.ConfigValueListener<Integer> caveCavitySpawnrate;
        public ConfigHelper.ConfigValueListener<Integer> oceanCaveSpawnrate;
        public ConfigHelper.ConfigValueListener<Boolean> pillarGen;
        public ConfigHelper.ConfigValueListener<Boolean> honeyLakeGen;
        public ConfigHelper.ConfigValueListener<Boolean> slimeLakeGen;
        public ConfigHelper.ConfigValueListener<Boolean> waterLakeGen;
        public ConfigHelper.ConfigValueListener<Boolean> lavaLakeGen;
        public ConfigHelper.ConfigValueListener<Integer> waterfallSpawnrate;
        public ConfigHelper.ConfigValueListener<Integer> lavafallSpawnrate;
        public ConfigHelper.ConfigValueListener<Integer> endIslandSpawnrate;
        public ConfigHelper.ConfigValueListener<Boolean> chestGeneration;
        public ConfigHelper.ConfigValueListener<Integer> sunShrineSpawnrate;
        public ConfigHelper.ConfigValueListener<Integer> stonehengeSpawnrate;
        public ConfigHelper.ConfigValueListener<Integer> hangingRuinsSpawnrate;
        public ConfigHelper.ConfigValueListener<Boolean> miniStructureGeneration;
        public ConfigHelper.ConfigValueListener<Integer> villageSpawnrate;
        public ConfigHelper.ConfigValueListener<Integer> villageZombieSpawnrate;
        public ConfigHelper.ConfigValueListener<Integer> mineshaftSpawnrate;
        public ConfigHelper.ConfigValueListener<Boolean> mineshaftAbovegroundAllowed;
        public ConfigHelper.ConfigValueListener<Boolean> mineshaftUndergroundAllowed;
        public ConfigHelper.ConfigValueListener<Integer> mansionSpawnrate;
        public ConfigHelper.ConfigValueListener<Integer> desertTempleSpawnrate;
        public ConfigHelper.ConfigValueListener<Integer> jungleTempleSpawnrate;
        public ConfigHelper.ConfigValueListener<Integer> iglooSpawnrate;
        public ConfigHelper.ConfigValueListener<Integer> mushroomTempleSpawnrate;
        public ConfigHelper.ConfigValueListener<Integer> iceSpikeTempleSpawnrate;
        public ConfigHelper.ConfigValueListener<Integer> witchHutSpawnrate;
        public ConfigHelper.ConfigValueListener<Integer> oceanMonumentSpawnrate;
        public ConfigHelper.ConfigValueListener<Integer> oceanRuinsSpawnrate;
        public ConfigHelper.ConfigValueListener<Integer> shipwreckSpawnrate;
        public ConfigHelper.ConfigValueListener<Integer> strongholdSpawnrate;
        public ConfigHelper.ConfigValueListener<Double> silverfishStrongholdSpawnrate;
        public ConfigHelper.ConfigValueListener<Boolean> allowSilverfishSpawnerStronghold;
        public ConfigHelper.ConfigValueListener<Double> strongholdSizeSH;
        public ConfigHelper.ConfigValueListener<Integer> netherFortressSpawnrate;
        public ConfigHelper.ConfigValueListener<Integer> stoneFortressSpawnrate;
        public ConfigHelper.ConfigValueListener<Boolean> allowSilverfishSpawnerFortress;
        public ConfigHelper.ConfigValueListener<Boolean> allowNaturalSilverfishFortress;
        public ConfigHelper.ConfigValueListener<Integer> endCitySpawnrate;
        public ConfigHelper.ConfigValueListener<Integer> pillageOutpostRarity;
        public ConfigHelper.ConfigValueListener<Integer> biomeSize;
        public ConfigHelper.ConfigValueListener<Integer> mutatedBiomeSpawnrate;
        public ConfigHelper.ConfigValueListener<Integer> seaLevel;
        public ConfigHelper.ConfigValueListener<Boolean> lavaOcean;
        public ConfigHelper.ConfigValueListener<Boolean> plains;
        public ConfigHelper.ConfigValueListener<Boolean> desert;
        public ConfigHelper.ConfigValueListener<Boolean> forest;
        public ConfigHelper.ConfigValueListener<Boolean> taiga;
        public ConfigHelper.ConfigValueListener<Boolean> rockyField;
        public ConfigHelper.ConfigValueListener<Boolean> swamplands;
        public ConfigHelper.ConfigValueListener<Boolean> netherland;
        public ConfigHelper.ConfigValueListener<Boolean> endField;
        public ConfigHelper.ConfigValueListener<Boolean> snowyTundra;
        public ConfigHelper.ConfigValueListener<Boolean> icedTerrain;
        public ConfigHelper.ConfigValueListener<Boolean> mushroom;
        public ConfigHelper.ConfigValueListener<Boolean> stonePlains;
        public ConfigHelper.ConfigValueListener<Boolean> bambooJungle;
        public ConfigHelper.ConfigValueListener<Boolean> jungle;
        public ConfigHelper.ConfigValueListener<Boolean> frozenDesert;
        public ConfigHelper.ConfigValueListener<Boolean> birchForest;
        public ConfigHelper.ConfigValueListener<Boolean> darkForest;
        public ConfigHelper.ConfigValueListener<Boolean> snowyTaiga;
        public ConfigHelper.ConfigValueListener<Boolean> giantTreeTaiga;
        public ConfigHelper.ConfigValueListener<Boolean> savanna;
        public ConfigHelper.ConfigValueListener<Boolean> badlands;
        public ConfigHelper.ConfigValueListener<Boolean> spikyBadlands;
        public ConfigHelper.ConfigValueListener<Boolean> iceSpike;
        public ConfigHelper.ConfigValueListener<Boolean> frozenOcean;
        public ConfigHelper.ConfigValueListener<Boolean> coldOcean;
        public ConfigHelper.ConfigValueListener<Boolean> ocean;
        public ConfigHelper.ConfigValueListener<Boolean> lukewarmOcean;
        public ConfigHelper.ConfigValueListener<Boolean> warmOcean;

        public UAConfigValues(ForgeConfigSpec.Builder builder, ConfigHelper.Subscriber subscriber) {
            builder.push("Mod Compatibility Options");
            this.importModdedFeatures = subscriber.subscribe(builder.comment("\r\n Attempt to add modded features from vanilla biomes into Ultra Amplified version of that biome.\r\n Only works if other mod added the feature by addFeature(...) to vanilla biome and registered the feature correctly without the 'minecraft' namespace.").translation("ultraamplified.config.compatibility.importmoddedfeatures").define("importModdedFeatures", false));
            this.importModdedStructure = subscriber.subscribe(builder.comment("\r\n Attempt to add modded structures from vanilla biomes into Ultra Amplified version of that biome.\r\n Only works if other mod added the structure by addFeature(...) to vanilla biome and registered the structure correctly without the 'minecraft' namespace.").translation("ultraamplified.config.compatibility.importmoddedstructure").define("importModdedStructure", false));
            this.importModdedMobs = subscriber.subscribe(builder.comment("\r\n Attempt to add modded mobs from vanilla biomes into Ultra Amplified version of that biome.\r\n Only works if other mod added the mob by addSpawn(...) to vanilla biome and registered the mob correctly without the 'minecraft' namespace.").translation("ultraamplified.config.compatibility.importmoddedmobs").define("importModdedMobs", false));
            this.importOverworldModdedBiomes = subscriber.subscribe(builder.comment("\r\n Attempt to add modded biomes from Overworld into Ultra Amplified dimension. (or into Overworld in Ultra Amplified worldtype)\r\n Only works if other mod added the biome to the BiomeDictionary with the BiomeType of DESERT, WARM, COOL, or ICY type.").translation("ultraamplified.config.compatibility.importmoddedbiomes").define("importModdedBiomes", false));
            this.importAllModdedBiomes = subscriber.subscribe(builder.comment("\r\n Attempt to add all registered modded biomes into Ultra Amplified dimension or worldtype.\r\n You may want to turn up biome size to 4 or 5 as this may make biomes very crowded. Also overrides importModdedBiomes setting.").translation("ultraamplified.config.compatibility.importmoddedbiomes").define("importAllModdedBiomes", false));
            this.blacklistedBiomeList = subscriber.subscribe(builder.comment("\r\n Blacklist either all of a mod's biomes or its specific biomes from being imported into Ultra Amplified dimension/worldtype.\r\n To blacklist all of a mod's biomes, type out its id like so with :* attached at end. Example: \"example_mod_id:*\"\r\n To blacklist a specific mod's biome, type out the resourcelocation. Example: \"example_mod_id:lava_desert\"\r\n NOTE: Seperate each entry with a comma. Example: \"example_mod_id_1:lava_desert, example_mod_id_2:*, example_mod_id_1:ender_forest\"\r\n Also, any entry using ultra_amplified_dimension or minecraft id will be ignored as I already handle those ids internally.").translation("ultraamplified.config.compatibility.blacklistedbiomelist").define("blacklistedBiomeList", (Object)""));
            this.blacklistedStructureList = subscriber.subscribe(builder.comment("\r\n Blacklist either all of a mod's structures or specific structures from being imported into Ultra Amplified dimension/worldtype.\r\n To blacklist all structures in a mod, type out its id like so with :* attached at end. Example: \"example_mod_id:*\"\r\n To blacklist a specific mod's structure, type out the resourcelocation. Example: \"example_mod_id:wizard_tower\"\r\n NOTE: Seperate each entry with a comma. Example: \"example_mod_id_1:wizard_tower, example_mod_id_2:*, example_mod_id_1:super_village\"\r\n Also, any entry using ultra_amplified_dimension or minecraft id will be ignored as I already handle those ids internally.").translation("ultraamplified.config.compatibility.blacklistedfeaturelist").define("blacklistedFeatureList", (Object)""));
            builder.pop();
            builder.push("General Dimension Options");
            this.heavyFog = subscriber.subscribe(builder.comment("\r\n Adds very heavy fog to make the world look more spoky and limit visibility.\n This is not the same as distance fog which does not make chunks near you foggy.").translation("ultraamplified.config.dimension.heavyfog").define("heavyFog", false));
            this.bedExplodes = subscriber.subscribe(builder.comment("\r\n Should beds explode in the Ultra Amplified Dimension?").translation("ultraamplified.config.dimension.bedexplodes").define("bedExplodes", false));
            this.allowNetherPortal = subscriber.subscribe(builder.comment("\r\n Lets Nether Portals be able to be created in Ultra Amplified DImension.\n Using the portal in this dimension will take you to the Nether but Nether \n Portals in the Nether will take you to the Overworld instead. So this option \n is good if you want a second way of escaping the Ultra Amplified Dimension.").translation("ultraamplified.config.dimension.allownetherportal").define("allowNetherPortal", false));
            this.forceExitToOverworld = subscriber.subscribe(builder.comment("\r\n Should beds explode in the Ultra Amplified Dimension? Makes leaving the Ultra Amplified dimension always places you back\r\n in the Overworld regardless of which dimension you originally \r\n came from. Use this option if this dimension becomes locked in  \r\n with another dimension so you are stuck teleporting between the \r\n two and cannot get back to the Overworld\r\n").translation("ultraamplified.config.dimension.forceexittooverworld").define("forceExitToOverworld", false));
            this.portalActivationItem = subscriber.subscribe(builder.comment("\r\n What item the player needs to hold and right click on the\r\n Polished Diorite to create the portal?\r\n The default entry is minecraft:flint_and_steel\r\n Note: set this to \"\" to disable portal creation completely.").translation("ultraamplified.config.dimension.portalactivationitem").define("portalActivationItem", (Object)"minecraft:flint_and_steel"));
            this.portalCornerBlocks = subscriber.subscribe(builder.comment("\r\n What corner blocks should we use to make a portal frame instead of Polish Granite?\r\n The default entry is minecraft:polish_granite").translation("ultraamplified.config.dimension.portalcornerblocks").define("portalCornerBlocks", (Object)"minecraft:polished_granite"));
            this.portalCeilingBlocks = subscriber.subscribe(builder.comment("\r\n What ceiling blocks should we use to make a portal frame instead of Polish Andesite Slab?\r\n The default entry is minecraft:polish_andesite").translation("ultraamplified.config.dimension.portalceilingblocks").define("portalCeilingBlocks", (Object)"minecraft:polished_andesite_slab"));
            this.portalFloorBlocks = subscriber.subscribe(builder.comment("\r\n What floor blocks should we use to make a portal frame instead of Polish Andesite Slab?\r\n The default entry is minecraft:polish_andesite").translation("ultraamplified.config.dimension.portalfloorblocks").define("portalFloorBlocks", (Object)"minecraft:polished_andesite_slab"));
            builder.pop();
            builder.push("Terrain Options");
            this.secretSetting = subscriber.subscribe(builder.comment("\r\n Does something neat! Give it a try lol\n You might want to use this on a fresh new world...\n Changes the terrain's look!").translation("ultraamplified.config.terrain.secretsettings").define("secretSettings", false));
            this.yMaximum = subscriber.subscribe(builder.comment("\r\n Maxium height the terrain can generate up to.\r\n Default is 245.").translation("ultraamplified.config.terrain.ymaximum").defineInRange("yMaximum", 245, 100, 0x7FFFFFFE));
            this.xzTerrainModifier = subscriber.subscribe(builder.comment("\r\n Changes the xz terrain modifier.\n I believe lower numbers will make the layers longer in the xz plane.\n Default value is 684.412D").translation("ultraamplified.config.terrain.xzterrainmodifier").defineInRange("xzTerrainModifier", 684.412, 1.0, 1.0E7));
            this.xzScaleModifier = subscriber.subscribe(builder.comment("\r\n Changes the xz terrain scale.\n Not exactly sure what this does.\n Default value is 8.55515F").translation("ultraamplified.config.terrain.xzscalemodifier").defineInRange("xzScaleModifier", (double)8.55515f, 1.0, 1.0E7));
            this.yTerrainModifier = subscriber.subscribe(builder.comment("\r\n Changes the y terrain modifier.\n I believe lower numbers will make less layers and thicken layers that do spawn.\n Default value is 68419.786D").translation("ultraamplified.config.terrain.yterrainmodifier").defineInRange("yTerrainModifier", 68419.786, 1.0, 1.0E7));
            this.yScaleModifier = subscriber.subscribe(builder.comment("\r\n Changes the y terrain scale.\n Not exactly sure what this does.\n Default value is 428.613D").translation("ultraamplified.config.terrain.yscalemodifier").defineInRange("yScaleModifier", 428.613, 1.0, 1.0E7));
            this.seaLevel = subscriber.subscribe(builder.comment("\r\n Sea Level. Default is 75.").translation("ultraamplified.config.terrain.sealevel").defineInRange("seaLevel", 75, 0, 250));
            this.lavaOcean = subscriber.subscribe(builder.comment("\r\n Replace the water at sea level with lava instead. DO NOT CHANGE THIS OPTION IN AN ALREADY GENERATED DIMENSION. IT WILL CRASH DUE TO LAVA OCEAN UPDATING NEXT TO OCEAN WATER!!").translation("ultraamplified.config.terrain.lavaocean").define("lavaOcean", false));
            this.endIslandSpawnrate = subscriber.subscribe(builder.comment("\r\n How often End Islands will spawn in the End Biome.\n 0 for no End Islands and 100 for max spawnrate.").translation("ultraamplified.config.terrain.endislandspawnrate").defineInRange("endIslandSpawnrate", 6, 0, 100));
            builder.pop();
            builder.push("Structure/Feature Options");
            builder.push("Feature Options");
            this.dungeonSpawnrate = subscriber.subscribe(builder.comment("\r\n How often Dungeons will spawn.\r\n 0 for no Dungeons and 1000 for max spawnrate.").translation("ultraamplified.config.feature.dungeonspawnrate").defineInRange("dungeonSpawnrate", 30, 0, 1000));
            this.ravineSpawnrate = subscriber.subscribe(builder.comment("\r\n How often Ravines will spawn.\r\n 0 for no Ravines and 100 for max spawnrate.").translation("ultraamplified.config.feature.ravinespawnrate").defineInRange("ravineSpawnrate", 25, 0, 100));
            this.caveCavitySpawnrate = subscriber.subscribe(builder.comment("\r\n How often Cave Cavity will spawn.\r\n 0 for no Cave Cavity and 22 for max spawnrate.").translation("ultraamplified.config.feature.cavecavityspawnrate").defineInRange("caveCavitySpawnrate", 5, 0, 22));
            this.oceanCaveSpawnrate = subscriber.subscribe(builder.comment("\r\n How often Underwater Caves will spawn in ocean biomes.\r\n 0 for no Underwater Caves and 100 for max spawnrate.").translation("ultraamplified.config.feature.oceancavespawnrate").defineInRange("oceanCaveSpawnrate", 20, 0, 100));
            this.pillarGen = subscriber.subscribe(builder.comment("\r\n Controls whether pillars features (both ramp and straight kind) spawn or not.").translation("ultraamplified.config.feature.pillargen").define("pillarGen", true));
            this.honeyLakeGen = subscriber.subscribe(builder.comment("\r\n Controls whether Honey Lakes spawn or not.").translation("ultraamplified.config.feature.honeylakegen").define("honeyLakeGen", true));
            this.slimeLakeGen = subscriber.subscribe(builder.comment("\r\n Controls whether Slime Lakes spawn or not.").translation("ultraamplified.config.feature.slimelakegen").define("slimeLakeGen", true));
            this.waterLakeGen = subscriber.subscribe(builder.comment("\r\n Controls whether Water Lakes spawn or not.").translation("ultraamplified.config.feature.waterlakegen").define("waterLakeGen", true));
            this.lavaLakeGen = subscriber.subscribe(builder.comment("\r\n Controls whether Lava Lakes spawn or not.").translation("ultraamplified.config.feature.lavalakegen").define("lavaLakeGen", true));
            this.glowstoneVariantsSpawnrate = subscriber.subscribe(builder.comment("\r\n Controls how often patches of Glowdirt and other modded Glowstone variants spawn.\r\n 0 for no patches and 1000 for max amount of patches.").translation("ultraamplified.config.feature.glowstonevariantsspawnrate").defineInRange("glowstoneVariantsSpawnrate", 50, 0, 1000));
            this.rootGen = subscriber.subscribe(builder.comment("\r\n Controls whether roots and short vines spawn or not on the underside of the floating land.").translation("ultraamplified.config.feature.rootgen").define("rootGen", true));
            this.waterfallSpawnrate = subscriber.subscribe(builder.comment("\r\n How often waterfalls will spawn.\n 0 for no waterfalls and 1000 for max spawnrate.").translation("ultraamplified.config.terrain.waterfallspawnrate").defineInRange("waterfallSpawnrate", 35, 0, 1000));
            this.lavafallSpawnrate = subscriber.subscribe(builder.comment("\r\n How often lavafalls will spawn.\n 0 for no lavafalls and 1000 for max spawnrate.").translation("ultraamplified.config.terrain.lavafallspawnrate").defineInRange("lavafallSpawnrate", 14, 0, 1000));
            builder.pop();
            builder.push("Mini-structure Options");
            this.miniStructureGeneration = subscriber.subscribe(builder.comment("\r\n Controls whether Desert Wells, Hay Piles, Sun Shrines, Stonehenges, and Crosses spawn or not.").translation("ultraamplified.config.structure.ministructuregeneration").define("miniStructureGeneration", true));
            this.sunShrineSpawnrate = subscriber.subscribe(builder.comment("\r\n How rare are Sun Shrines.\r\n 1 for Sun Shrines spawning in most chunks and 1000 for very rare spawn.\r\n Spawns mainly in relic variant of biomes.").translation("ultraamplified.config.structure.sunshrinespawnrate").defineInRange("sunShrineSpawnrate", 130, 1, 100));
            this.stonehengeSpawnrate = subscriber.subscribe(builder.comment("\r\n How rare are Stonehenges.\r\n 1 for Stonehenges spawning in most chunks and 1000 for very rare spawn.\r\n Spawns mainly in relic variant of biomes.").translation("ultraamplified.config.structure.stonehengespawnrate").defineInRange("stonehengeSpawnrate", 15, 1, 100));
            this.hangingRuinsSpawnrate = subscriber.subscribe(builder.comment("\r\n How rare are Hanging Ruins.\r\n 1000 for Hanging Ruins spawning in most chunks and 0 for no spawn.\r\n NOTE: this is backwards than other spawnrates.\r\n This is because other structures need have finer control on chances less than 1%.\r\n Spawns in most biomes except for oceans, Netherland, and Iced Terrain Biomes and more often in Rocky Fields variants and Stone Fields biomes.").translation("ultraamplified.config.structure.hangingruinsspawnrate").defineInRange("hangingRuinsSpawnrate", 60, 0, 1000));
            builder.pop();
            builder.push("Structure Options");
            this.chestGeneration = subscriber.subscribe(builder.comment("\r\n Controls whether loot chests spawn or not in all structures.").translation("ultraamplified.config.structure.chestgeneration").define("chestGeneration", true));
            builder.push("Villages");
            this.villageSpawnrate = subscriber.subscribe(builder.comment("\r\n How rare are Villages.\r\n 1 for Village spawning in most chunks and 101 for no spawn.").translation("ultraamplified.config.structure.villagespawnrate").defineInRange("villageSpawnrate", 16, 1, 101));
            this.villageZombieSpawnrate = subscriber.subscribe(builder.comment("\r\n What percentage of Classic Styled Villages are Zombie Villages.\r\n 0 for no Zombie Village spawning and 100 for all Villages being zombified.").translation("ultraamplified.config.structure.villagezombiespawnrate").defineInRange("villageZombieSpawnrate", 10, 0, 100));
            builder.pop();
            builder.push("Mineshaft");
            this.mineshaftSpawnrate = subscriber.subscribe(builder.comment("\r\n How often Mineshafts will spawn.\r\n 0 for no Mineshafts and 1000 for max spawnrate.").translation("ultraamplified.config.structure.mineshaftspawnrate").defineInRange("mineshaftSpawnrate", 22, 0, 1000));
            this.mineshaftAbovegroundAllowed = subscriber.subscribe(builder.comment("\r\n Can aboveground floating Mineshafts spawn?").translation("ultraamplified.config.structure.mineshaftabovegroundallowed").define("mineshaftAbovegroundAllowed", true));
            this.mineshaftUndergroundAllowed = subscriber.subscribe(builder.comment("\r\n Can undergound giant pit Mineshafts spawn?").translation("ultraamplified.config.structure.mineshaftundergroundallowed").define("mineshaftUndergroundAllowed", true));
            builder.pop();
            builder.push("Woodland Mansion");
            this.mansionSpawnrate = subscriber.subscribe(builder.comment("\r\n How rare are Woodland Mansion.\n 1 for Woodland Mansion spawning in most chunks and 101 for no spawn.").translation("ultraamplified.config.structure.mansionspawnrate").defineInRange("mansionSpawnrate", 18, 1, 101));
            builder.pop();
            builder.push("Desert Temple");
            this.desertTempleSpawnrate = subscriber.subscribe(builder.comment("\r\n How rare are Desert Temples.\n 1 for spawning in most chunks and 101 for no spawn.").translation("ultraamplified.config.structure.deserttemplespawnrate").defineInRange("desertTempleSpawnrate", 20, 1, 101));
            builder.pop();
            builder.push("Jungle Temple");
            this.jungleTempleSpawnrate = subscriber.subscribe(builder.comment("\r\n How rare are Jungle Temples.\n 1 for a spawning in most chunks and 101 for no spawn.").translation("ultraamplified.config.structure.jungletemplespawnrate").defineInRange("jungleTempleSpawnrate", 20, 1, 101));
            builder.pop();
            builder.push("Igloo");
            this.iglooSpawnrate = subscriber.subscribe(builder.comment("\r\n How rare are igloos.\n 1 for spawning in most chunks and 101 for no spawn.").translation("ultraamplified.config.structure.igloospawnrate").defineInRange("iglooSpawnrate", 14, 1, 101));
            builder.pop();
            builder.push("Mushroom Temple");
            this.mushroomTempleSpawnrate = subscriber.subscribe(builder.comment("\r\n How rare are Mushroom Temples.\n 1 for spawning in most chunks and 101 for no spawn.").translation("ultraamplified.config.structure.mushroomtemplespawnrate").defineInRange("mushroomTempleSpawnrate", 12, 1, 101));
            builder.pop();
            builder.push("Ice Spike Temple");
            this.iceSpikeTempleSpawnrate = subscriber.subscribe(builder.comment("\r\n How rare are Ice Spike Temples.\n 1 for spawning in most chunks and 101 for no spawn.").translation("ultraamplified.config.structure.icespiketemplespawnrate").defineInRange("iceSpikeTempleSpawnrate", 20, 1, 101));
            builder.pop();
            builder.push("Witch Hut");
            this.witchHutSpawnrate = subscriber.subscribe(builder.comment("\r\n How rare are Witch Huts.\n 1 for spawning in most chunks and 101 for no spawn.").translation("ultraamplified.config.structure.witchhutspawnrate").defineInRange("witchHutSpawnrate", 14, 1, 101));
            builder.pop();
            builder.push("Ocean Monument");
            this.oceanMonumentSpawnrate = subscriber.subscribe(builder.comment("\r\n How rare are Ocean Monuments.\n 1 for spawning in most chunks and 101 for no spawn.").translation("ultraamplified.config.structure.oceanmonumentspawnrate").defineInRange("oceanMonumentSpawnrate", 22, 1, 101));
            builder.pop();
            builder.push("Ocean Ruins");
            this.oceanRuinsSpawnrate = subscriber.subscribe(builder.comment("\r\n How rare are Ocean Ruins.\n 1 for spawning in most chunks and 101 for no spawn.").translation("ultraamplified.config.structure.oceanruinsspawnrate").defineInRange("oceanRuinsSpawnrate", 7, 1, 101));
            builder.pop();
            builder.push("Shipwreck");
            this.shipwreckSpawnrate = subscriber.subscribe(builder.comment("\r\n How rare are Shipwrecks.\n 1 for spawning in most chunks and 101 for no spawn.").translation("ultraamplified.config.structure.shipwreckspawnrate").defineInRange("shipwreckSpawnrate", 7, 1, 101));
            builder.pop();
            builder.push("Stronghold");
            this.strongholdSpawnrate = subscriber.subscribe(builder.comment("\r\n How rare are Strongholds.\n 1 for spawning in most chunks and 501 for no spawn.").translation("ultraamplified.config.structure.strongholdspawnrate").defineInRange("strongholdSpawnrate", 62, 1, 501));
            this.silverfishStrongholdSpawnrate = subscriber.subscribe(builder.comment("\r\n How often Silverfish Blocks will generate in Strongholds.\n 0 for no Silverfish Blocks and 100 for max spawnrate.").translation("ultraamplified.config.structure.silverfishstrongholdspawnrate").defineInRange("silverfishStrongholdSpawnrate", 4.0, 0.0, 100.0));
            this.allowSilverfishSpawnerStronghold = subscriber.subscribe(builder.comment("\r\n Can Silverfish Mob Spawners generate in Stronghold?.").translation("ultraamplified.config.structure.allowsilverfishspawnerstronghold").define("allowSilverfishSpawnerStronghold", true));
            this.strongholdSizeSH = subscriber.subscribe(builder.comment("\r\n How large the Stronghold is on average as a percentage.\r\n Note: The Stonghold is much larger by default. To get something \r\n closer to vanilla stronghold size, use the value of 60.\n 10 for supertiny Strongholds and 2000 for supermassive Strongholds.").translation("repurposedstructures.config.structure.stronghold.strongholdsizesh").defineInRange("strongholdSizeSH", 100.0, 10.0, 2000.0));
            builder.pop();
            builder.push("Nether Fortress");
            this.netherFortressSpawnrate = subscriber.subscribe(builder.comment("\r\n How rare are Nether Fortresses that spawn \r\n aboveground in the Netherland biome (between y = 85 and 130).\n 1 for spawning in most chunks and 101 for no spawn.").translation("ultraamplified.config.structure.netherfortressspawnrate").defineInRange("netherFortressSpawnrate", 6, 1, 101));
            builder.pop();
            builder.push("Stone Fortress");
            this.stoneFortressSpawnrate = subscriber.subscribe(builder.comment("\r\n How rare are Stone Fortresses that spawn underground (below y = 65).\n 1 for spawning in most chunks and 101 for no spawn.").translation("ultraamplified.config.structure.stonefortressspawnrate").defineInRange("stoneFortressSpawnrate", 14, 1, 101));
            this.allowSilverfishSpawnerFortress = subscriber.subscribe(builder.comment("\r\n Can Silverfish Mob Spawners generate in Stone Fortresses?").translation("ultraamplified.config.structure.allowsilverfishspawnerfortress").define("allowSilverfishSpawnerFortress", true));
            this.allowNaturalSilverfishFortress = subscriber.subscribe(builder.comment("\r\n Can Silverfish spawn naturally over time in Stone Fortresses?").translation("ultraamplified.config.structure.allownaturalsilverfishfortress").define("allowNaturalSilverfishFortress", true));
            builder.pop();
            builder.push("End City");
            this.endCitySpawnrate = subscriber.subscribe(builder.comment("\r\n How rare are End Cities.\n 1 for spawning in most chunks and 101 for no spawn.").translation("ultraamplified.config.structure.endcityspawnrate").defineInRange("endCitySpawnrate", 22, 1, 101));
            builder.pop();
            builder.push("Outpost");
            this.pillageOutpostRarity = subscriber.subscribe(builder.comment("\r\n How rare are Pillager Outposts.\n 1 for spawning in most chunks and 101 for no spawn.").translation("ultraamplified.config.structure.pillageoutpostrarity").defineInRange("pillageOutpostRarity", 20, 1, 101));
            builder.pop();
            builder.pop();
            builder.pop();
            builder.push("Biome Options");
            this.biomeSize = subscriber.subscribe(builder.comment("\r\n How large the biomes are.\n Bigger number means bigger biomes.").translation("ultraamplified.config.biome.biomesize").defineInRange("biomeSize", 3, 1, 8));
            this.mutatedBiomeSpawnrate = subscriber.subscribe(builder.comment("\r\n How often the mutated form of a biome will generate\n 0 for no mutated biomes and 10 for all biomes to be mutated.").translation("ultraamplified.config.biome.mutatedbiomespawnrate").defineInRange("mutatedBiomeSpawnrate", 2, 0, 10));
            builder.push("Allowed Biome Options");
            this.plains = subscriber.subscribe(builder.comment("\r\n Should this biome be allowed to spawn?").translation("ultraamplified.config.biome.plains").define("plains", true));
            this.desert = subscriber.subscribe(builder.comment("\r\n Should this biome be allowed to spawn?").translation("ultraamplified.config.biome.desert").define("desert", true));
            this.forest = subscriber.subscribe(builder.comment("\r\n Should this biome be allowed to spawn?").translation("ultraamplified.config.biome.forest").define("forest", true));
            this.taiga = subscriber.subscribe(builder.comment("\r\n Should this biome be allowed to spawn?").translation("ultraamplified.config.biome.taiga").define("taiga", true));
            this.rockyField = subscriber.subscribe(builder.comment("\r\n Should this biome be allowed to spawn?").translation("ultraamplified.config.biome.rockyfield").define("rockyField", true));
            this.swamplands = subscriber.subscribe(builder.comment("\r\n Should this biome be allowed to spawn?").translation("ultraamplified.config.biome.swamplands").define("swamplands", true));
            this.netherland = subscriber.subscribe(builder.comment("\r\n Should this biome be allowed to spawn?").translation("ultraamplified.config.biome.netherland").define("netherland", true));
            this.endField = subscriber.subscribe(builder.comment("\r\n Should this biome be allowed to spawn?").translation("ultraamplified.config.biome.end").define("end", true));
            this.snowyTundra = subscriber.subscribe(builder.comment("\r\n Should this biome be allowed to spawn?").translation("ultraamplified.config.biome.snowytundra").define("snowyTundra", true));
            this.icedTerrain = subscriber.subscribe(builder.comment("\r\n Should this biome be allowed to spawn?").translation("ultraamplified.config.biome.icedterrain").define("icedTerrain", true));
            this.mushroom = subscriber.subscribe(builder.comment("\r\n Should this biome be allowed to spawn?").translation("ultraamplified.config.biome.mushroom").define("mushroom", true));
            this.stonePlains = subscriber.subscribe(builder.comment("\r\n Should this biome be allowed to spawn?").translation("ultraamplified.config.biome.stoneplains").define("stonePlains", true));
            this.bambooJungle = subscriber.subscribe(builder.comment("\r\n Should this biome be allowed to spawn?").translation("ultraamplified.config.biome.bamboojungle").define("bambooJungle", true));
            this.jungle = subscriber.subscribe(builder.comment("\r\n Should this biome be allowed to spawn?").translation("ultraamplified.config.biome.jungle").define("jungle", true));
            this.frozenDesert = subscriber.subscribe(builder.comment("\r\n Should this biome be allowed to spawn?").translation("ultraamplified.config.biome.frozendesert").define("frozenDesert", true));
            this.birchForest = subscriber.subscribe(builder.comment("\r\n Should this biome be allowed to spawn?").translation("ultraamplified.config.biome.birchforest").define("birchForest", true));
            this.darkForest = subscriber.subscribe(builder.comment("\r\n Should this biome be allowed to spawn?").translation("ultraamplified.config.biome.darkforest").define("darkForest", true));
            this.snowyTaiga = subscriber.subscribe(builder.comment("\r\n Should this biome be allowed to spawn?").translation("ultraamplified.config.biome.snowytaiga").define("snowyTaiga", true));
            this.giantTreeTaiga = subscriber.subscribe(builder.comment("\r\n Should this biome be allowed to spawn?").translation("ultraamplified.config.biome.gianttreetaiga").define("giantTreeTaiga", true));
            this.savanna = subscriber.subscribe(builder.comment("\r\n Should this biome be allowed to spawn?").translation("ultraamplified.config.biome.savanna").define("savanna", true));
            this.badlands = subscriber.subscribe(builder.comment("\r\n Should this biome be allowed to spawn?").translation("ultraamplified.config.biome.badlands").define("badlands", true));
            this.spikyBadlands = subscriber.subscribe(builder.comment("\r\n Should Spiky Badlands and Dissected Plateau Badlands be allowed to spawn?").translation("ultraamplified.config.biome.spikybadlands").define("spikyBadlands", true));
            this.iceSpike = subscriber.subscribe(builder.comment("\r\n Should this biome be allowed to spawn?").translation("ultraamplified.config.biome.icespike").define("iceSpike", true));
            this.frozenOcean = subscriber.subscribe(builder.comment("\r\n Should this biome be allowed to spawn?").translation("ultraamplified.config.biome.frozenocean").define("frozenOcean", true));
            this.coldOcean = subscriber.subscribe(builder.comment("\r\n Should this biome be allowed to spawn?").translation("ultraamplified.config.biome.coldocean").define("coldOcean", true));
            this.ocean = subscriber.subscribe(builder.comment("\r\n Should this biome be allowed to spawn?").translation("ultraamplified.config.biome.ocean").define("ocean", true));
            this.lukewarmOcean = subscriber.subscribe(builder.comment("\r\n Should this biome be allowed to spawn?").translation("ultraamplified.config.biome.lukewarmocean").define("lukewarmOcean", true));
            this.warmOcean = subscriber.subscribe(builder.comment("\r\n Should this biome be allowed to spawn?").translation("ultraamplified.config.biome.warmocean").define("warmOcean", true));
            builder.pop();
            builder.pop();
            builder.push("Main Ores Options");
            this.coalOreSpawnrate = subscriber.subscribe(builder.comment("\r\n How often Coal Ores will spawn.\n 0 for no Coal Ores and 1000 for max spawnrate.").translation("ultraamplified.config.ore.coalorespawnrate").defineInRange("coalOreSpawnrate", 35, 0, 1000));
            this.ironOreSpawnrate = subscriber.subscribe(builder.comment("\r\n How often Iron Ores will spawn.\n 0 for no Iron Ores and 1000 for max spawnrate.").translation("ultraamplified.config.ore.ironorespawnrate").defineInRange("ironOreSpawnrate", 50, 0, 1000));
            this.redstoneOreSpawnrate = subscriber.subscribe(builder.comment("\r\n How often Redstone Ores will spawn.\n 0 for no Redstone Ores and 1000 for max spawnrate.").translation("ultraamplified.config.ore.redstoneorespawnrate").defineInRange("redstoneOreSpawnrate", 12, 0, 1000));
            this.lapisOreSpawnrate = subscriber.subscribe(builder.comment("\r\n How often Lapis Lazuli Ores will spawn.\n 0 for no Lapis Lazuli Ores and 1000 for max spawnrate.").translation("ultraamplified.config.ore.lapisorespawnrate").defineInRange("lapisOreSpawnrate", 2, 0, 1000));
            this.diamondOreSpawnrate = subscriber.subscribe(builder.comment("\r\n How often Diamond Ores will spawn.\n 0 for no Diamond Ores and 1000 for max spawnrate.").translation("ultraamplified.config.ore.diamondorespawnrate").defineInRange("diamondOreSpawnrate", 1, 0, 1000));
            this.goldOreSpawnrate = subscriber.subscribe(builder.comment("\r\n How often Gold Ores will spawn.\n 0 for no Gold Ores and 1000 for max spawnrate.").translation("ultraamplified.config.ore.goldorespawnrate").defineInRange("goldOreSpawnrate", 2, 0, 1000));
            builder.push("Rocky Fields Ores and Features Options");
            this.emeraldOreSpawnrate = subscriber.subscribe(builder.comment("\r\n How often Emerald Ores will spawn in all Rocky Fields variant biomes in the form of a percentage.\n 0 for no Emerald Ores and 1000 for max spawnrate.").translation("ultraamplified.config.ore.emeraldorespawnrate").defineInRange("emeraldOreSpawnrate", 100, 0, 1000));
            this.silverfishSpawnrate = subscriber.subscribe(builder.comment("\r\n How often Silverfish Blocks will spawn in all Rocky Fields variant biomes.\n 0 for no Silverfish Blocks and 1000 for max spawnrate.").translation("ultraamplified.config.ore.silverfishspawnrate").defineInRange("silverfishSpawnrate", 18, 0, 1000));
            builder.pop();
            builder.push("Netherland Ores and Features Options");
            this.quartzOreSpawnrate = subscriber.subscribe(builder.comment("\r\n How often Quartz Ores will spawn.\n 0 for no Quartz Ores and 1000 for max spawnrate.").translation("ultraamplified.config.ore.quartzorespawnrate").defineInRange("quartzOreSpawnrate", 14, 0, 1000));
            this.glowstoneSpawnrate = subscriber.subscribe(builder.comment("\r\n How often Glowstone will spawn in Netherland biome.\n 0 for no Glowstone and 1000 for max spawnrate.").translation("ultraamplified.config.ore.glowstonespawnrate").defineInRange("glowstoneSpawnrate", 20, 0, 1000));
            this.magmaSpawnrate = subscriber.subscribe(builder.comment("\r\n How often Magma Blocks will spawn below Y = 100 in Netherland biome.\n 0 for no Magma Blocks and 1000 for max spawnrate.\n Note: Will not affect the flat Magma layer separating water from lava below sealevel.").translation("ultraamplified.config.ore.magmaspawnrate").defineInRange("magmaSpawnrate", 5, 0, 1000));
            this.lavaSpawnrate = subscriber.subscribe(builder.comment("\r\n How often single Lava Blocks will spawn in Netherland biome.\n 0 for no single Lava Blocks and 1000 for max spawnrate.").translation("ultraamplified.config.ore.lavaspawnrate").defineInRange("lavaSpawnrate", 70, 0, 1000));
            builder.pop();
            builder.pop();
        }
    }
}

