/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.extrabehavior;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SlabBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.SlabType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.telepathicgrunt.ultraamplified.UltraAmplified;
import net.telepathicgrunt.ultraamplified.blocks.UABlocks;
import net.telepathicgrunt.ultraamplified.world.feature.AmplifiedPortalFrame;

@Mod.EventBusSubscriber(modid="ultra_amplified_dimension", bus=Mod.EventBusSubscriber.Bus.MOD)
public class AmplifiedPortalCreation {
    private static final Block POLISHED_DIORITE = Blocks.field_196655_f;

    public static boolean checkForGeneratedPortal(IWorld worldUA) {
        BlockPos pos = new BlockPos(8, worldUA.getMaxHeight(), 8);
        worldUA.func_217349_x(pos);
        while (pos.func_177956_o() >= 0) {
            if (worldUA.func_180495_p(pos) == ((Block)UABlocks.AMPLIFIEDPORTAL.get()).func_176223_P()) {
                return true;
            }
            pos = pos.func_177977_b();
        }
        return false;
    }

    public static void generatePortal(IWorld worldUA) {
        AmplifiedPortalFrame amplifiedportalfeature = new AmplifiedPortalFrame();
        BlockPos pos = new BlockPos(8, worldUA.getMaxHeight(), 8);
        worldUA.func_217349_x(pos);
        pos = worldUA.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, pos);
        if (pos.func_177956_o() > 252) {
            pos = pos.func_177979_c(3);
        } else if (pos.func_177956_o() < 6) {
            pos = new BlockPos(pos.func_177958_n(), 6, pos.func_177952_p());
        }
        amplifiedportalfeature.place(worldUA, new Random(), pos, IFeatureConfig.field_202429_e);
    }

    public static boolean isValid(IWorld world, BlockPos pos, Entity entity) {
        SlabType type;
        int z;
        int x;
        BlockState blockFloor;
        BlockState blockCeiling;
        ForgeRegistry registry = (ForgeRegistry)ForgeRegistries.BLOCKS;
        if (!registry.containsKey(new ResourceLocation(UltraAmplified.UAConfig.portalCornerBlocks.get()))) {
            if (entity instanceof ServerPlayerEntity) {
                StringTextComponent message = new StringTextComponent("\u00a7eUltra Amplified Dimension: \u00a7fI could not find the block with the resourcelocation that was put in the portal frame corner config! Here is what was in the config: \u00a7c" + UltraAmplified.UAConfig.portalCornerBlocks.get());
                entity.func_145747_a((ITextComponent)message);
            }
            return false;
        }
        Block blockCorner = (Block)registry.getValue(new ResourceLocation(UltraAmplified.UAConfig.portalCornerBlocks.get()));
        if (registry.containsKey(new ResourceLocation(UltraAmplified.UAConfig.portalCeilingBlocks.get()))) {
            blockCeiling = ((Block)registry.getValue(new ResourceLocation(UltraAmplified.UAConfig.portalCeilingBlocks.get()))).func_176223_P();
            if (blockCeiling.func_177230_c() instanceof SlabBlock) {
                blockCeiling = (BlockState)blockCeiling.func_206870_a((IProperty)SlabBlock.field_196505_a, (Comparable)SlabType.TOP);
            }
        } else {
            if (entity instanceof ServerPlayerEntity) {
                StringTextComponent message = new StringTextComponent("\u00a7eUltra Amplified Dimension: \u00a7fI could not find the block with the resourcelocation that was put in the portal frame ceiling config! Here is what was in the config: \u00a7c" + UltraAmplified.UAConfig.portalCeilingBlocks.get());
                entity.func_145747_a((ITextComponent)message);
            }
            return false;
        }
        if (registry.containsKey(new ResourceLocation(UltraAmplified.UAConfig.portalFloorBlocks.get()))) {
            blockFloor = ((Block)registry.getValue(new ResourceLocation(UltraAmplified.UAConfig.portalFloorBlocks.get()))).func_176223_P();
            if (blockFloor.func_177230_c() instanceof SlabBlock) {
                blockFloor = (BlockState)blockFloor.func_206870_a((IProperty)SlabBlock.field_196505_a, (Comparable)SlabType.BOTTOM);
            }
        } else {
            if (entity instanceof ServerPlayerEntity) {
                StringTextComponent message = new StringTextComponent("\u00a7eUltra Amplified Dimension: \u00a7fI could not find the block with the resourcelocation that was put in the portal frame floor config! Here is what was in the config: \u00a7c" + UltraAmplified.UAConfig.portalFloorBlocks.get());
                entity.func_145747_a((ITextComponent)message);
            }
            return false;
        }
        for (x = -1; x <= 1; ++x) {
            for (z = -1; z <= 1; ++z) {
                if (Math.abs(x * z) == 1) {
                    if (world.func_180495_p(pos.func_177982_a(x, -1, z)).func_177230_c() == blockCorner) continue;
                    return false;
                }
                BlockState currentFloor = world.func_180495_p(pos.func_177982_a(x, -1, z));
                if (currentFloor.func_177230_c() instanceof SlabBlock) {
                    type = (SlabType)currentFloor.func_177229_b((IProperty)SlabBlock.field_196505_a);
                    currentFloor = (BlockState)currentFloor.func_177230_c().func_176223_P().func_206870_a((IProperty)SlabBlock.field_196505_a, (Comparable)type);
                } else {
                    currentFloor = currentFloor.func_177230_c().func_176223_P();
                }
                if (currentFloor == blockFloor) continue;
                return false;
            }
        }
        if (world.func_180495_p(pos.func_177982_a(0, 0, 0)).func_177230_c() != POLISHED_DIORITE) {
            return false;
        }
        for (x = -1; x <= 1; ++x) {
            for (z = -1; z <= 1; ++z) {
                if (Math.abs(x * z) == 1) {
                    if (world.func_180495_p(pos.func_177982_a(x, 1, z)).func_177230_c() == blockCorner) continue;
                    return false;
                }
                BlockState currentCeiling = world.func_180495_p(pos.func_177982_a(x, 1, z));
                if (currentCeiling.func_177230_c() instanceof SlabBlock) {
                    type = (SlabType)currentCeiling.func_177229_b((IProperty)SlabBlock.field_196505_a);
                    currentCeiling = (BlockState)currentCeiling.func_177230_c().func_176223_P().func_206870_a((IProperty)SlabBlock.field_196505_a, (Comparable)type);
                } else {
                    currentCeiling = currentCeiling.func_177230_c().func_176223_P();
                }
                if (currentCeiling == blockCeiling) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean trySpawnPortal(IWorld world, BlockPos pos, Entity entity) {
        boolean canMakePortal = AmplifiedPortalCreation.isPortal(world, pos, entity);
        if (canMakePortal) {
            world.func_180501_a(pos, ((Block)UABlocks.AMPLIFIEDPORTAL.get()).func_176223_P(), 18);
            return true;
        }
        return false;
    }

    @Nullable
    public static boolean isPortal(IWorld world, BlockPos pos, Entity entity) {
        return AmplifiedPortalCreation.isValid(world, pos, entity);
    }

    @Mod.EventBusSubscriber(modid="ultra_amplified_dimension")
    private static class ForgeEvents {
        static ForgeRegistry<Item> itemRegistry = (ForgeRegistry)ForgeRegistries.ITEMS;

        private ForgeEvents() {
        }

        @SubscribeEvent
        public static void BlockRightClickEvent(PlayerInteractEvent.RightClickBlock event) {
            World world = event.getWorld();
            Entity entity = event.getEntity();
            if (!entity.func_213453_ef() && !UltraAmplified.UAConfig.portalActivationItem.get().isEmpty()) {
                ResourceLocation itemrl = new ResourceLocation(UltraAmplified.UAConfig.portalActivationItem.get());
                if (itemRegistry.containsKey(itemrl)) {
                    Item activationItem = (Item)itemRegistry.getValue(itemrl);
                    if (event.getItemStack().func_77973_b() == activationItem) {
                        AmplifiedPortalCreation.trySpawnPortal((IWorld)world, event.getPos(), entity);
                    }
                } else if (entity instanceof ServerPlayerEntity) {
                    StringTextComponent message = new StringTextComponent("\u00a7eUltra Amplified Dimension: \u00a7fI could not find the item with the resourcelocation that was put in the portal activation item config! Here is what was in the config: \u00a7c" + UltraAmplified.UAConfig.portalActivationItem.get());
                    entity.func_145747_a((ITextComponent)message);
                }
            }
        }
    }
}

