/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.biome;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.BlockBlobConfig;
import net.minecraft.world.gen.feature.BlockBlobFeature;
import net.minecraft.world.gen.feature.BlockStateFeatureConfig;
import net.minecraft.world.gen.feature.BlockWithContextConfig;
import net.minecraft.world.gen.feature.BlockWithContextFeature;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.ConfiguredRandomFeatureList;
import net.minecraft.world.gen.feature.DecoratedFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.LakesFeature;
import net.minecraft.world.gen.feature.LiquidsConfig;
import net.minecraft.world.gen.feature.MultipleRandomFeatureConfig;
import net.minecraft.world.gen.feature.MultipleWithChanceRandomFeature;
import net.minecraft.world.gen.feature.OreFeature;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.feature.SphereReplaceConfig;
import net.minecraft.world.gen.feature.SphereReplaceFeature;
import net.minecraft.world.gen.feature.SpringFeature;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.Structures;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.telepathicgrunt.ultraamplified.UltraAmplified;
import net.telepathicgrunt.ultraamplified.world.biome.UABiome;
import net.telepathicgrunt.ultraamplified.world.biome.UABiomes;

@Mod.EventBusSubscriber(modid="ultra_amplified_dimension", bus=Mod.EventBusSubscriber.Bus.MOD)
public class BiomeAddModdedFeatures {
    private static ForgeRegistry<Feature<?>> FeatureRegistry = (ForgeRegistry)ForgeRegistries.FEATURES;
    private static ForgeRegistry<EntityType<?>> EntityRegistry = (ForgeRegistry)ForgeRegistries.ENTITIES;
    private static ForgeRegistry<Block> BlockRegistry = (ForgeRegistry)ForgeRegistries.BLOCKS;
    private static List<Structure<? extends IFeatureConfig>> listOfVanillaStructures = Arrays.asList(Structures.field_215143_a, Structures.field_215144_b, Structures.field_215145_c, Structures.field_215146_d, Structures.field_215147_e, Structures.field_215148_f, Structures.field_215149_g, Structures.field_215150_h, Structures.field_215151_i, Structures.field_215152_j, Structures.field_215153_k, Structures.field_215154_l, Structures.field_215155_m, Structures.field_215156_n, Structures.field_215157_o);
    private static List<Structure<? extends IFeatureConfig>> listOfVanillaStructureFeatures = Arrays.asList(Feature.field_202329_g, Feature.field_214536_b, Feature.field_202337_o, Feature.field_202335_m, Feature.field_202331_i, Feature.field_204029_o, Feature.field_202332_j, Feature.field_202333_k, Feature.field_202334_l, Feature.field_202336_n, Feature.field_204292_r, Feature.field_202330_h, Feature.field_214549_o, Feature.field_204751_l, Feature.field_214550_p);
    private static List<EntityType<? extends MobEntity>> listOfVanillaMobs = Arrays.asList(EntityType.field_200791_e, EntityType.field_200792_f, EntityType.field_220360_g, EntityType.field_200795_i, EntityType.field_203780_j, EntityType.field_200796_j, EntityType.field_200797_k, EntityType.field_200798_l, EntityType.field_205137_n, EntityType.field_204724_o, EntityType.field_200803_q, EntityType.field_200804_r, EntityType.field_220356_B, EntityType.field_200811_y, EntityType.field_200762_B, EntityType.field_200763_C, EntityType.field_200769_I, EntityType.field_200771_K, EntityType.field_200779_S, EntityType.field_200780_T, EntityType.field_200781_U, EntityType.field_220353_aa, EntityType.field_200783_W, EntityType.field_200784_X, EntityType.field_203779_Z, EntityType.field_200785_Y, EntityType.field_200786_Z, EntityType.field_200736_ab, EntityType.field_203778_ae, EntityType.field_200737_ac, EntityType.field_200741_ag, EntityType.field_200743_ai, EntityType.field_200748_an, EntityType.field_200749_ao, EntityType.field_200750_ap, EntityType.field_204262_at, EntityType.field_203099_aq, EntityType.field_200759_ay, EntityType.field_200722_aA, EntityType.field_200724_aC, EntityType.field_200725_aD, EntityType.field_200727_aF);
    private static Biome[] vanillaBiomesToCheck = new Biome[]{Biomes.field_76772_c, Biomes.field_76769_d, Biomes.field_76770_e, Biomes.field_76767_f, Biomes.field_76768_g, Biomes.field_76780_h, Biomes.field_76778_j, Biomes.field_76779_k, Biomes.field_76774_n, Biomes.field_76775_o, Biomes.field_76789_p, Biomes.field_76786_s, Biomes.field_76785_t, Biomes.field_76784_u, Biomes.field_222370_aw, Biomes.field_222371_ax, Biomes.field_76782_w, Biomes.field_76792_x, Biomes.field_150574_L, Biomes.field_150576_N, Biomes.field_150577_O, Biomes.field_150583_P, Biomes.field_150582_Q, Biomes.field_150585_R, Biomes.field_150584_S, Biomes.field_150579_T, Biomes.field_150578_U, Biomes.field_150581_V, Biomes.field_150580_W, Biomes.field_150588_X, Biomes.field_150587_Y, Biomes.field_150589_Z, Biomes.field_150607_aa, Biomes.field_150608_ab, Biomes.field_185441_Q, Biomes.field_185442_R, Biomes.field_185443_S, Biomes.field_185444_T, Biomes.field_150590_f, Biomes.field_150599_m, Biomes.field_185445_W, Biomes.field_185446_X, Biomes.field_185447_Y, Biomes.field_185448_Z, Biomes.field_185429_aa, Biomes.field_185430_ab, Biomes.field_185431_ac, Biomes.field_185432_ad, Biomes.field_185433_ae, Biomes.field_185434_af, Biomes.field_185435_ag, Biomes.field_185436_ah, Biomes.field_185437_ai, Biomes.field_185438_aj, Biomes.field_185439_ak, Biomes.field_76776_l, Biomes.field_203616_V, Biomes.field_76771_b, Biomes.field_203615_U, Biomes.field_203614_T, Biomes.field_203620_Z, Biomes.field_203619_Y, Biomes.field_150575_M, Biomes.field_203618_X, Biomes.field_203617_W};
    private static List<String> blacklistedFeatureMods;
    private static List<String> blacklistedFeatureResourceLocations;

    private static void addModdedFeatureAndSpawns(Biome vanillaBiome, UABiome uaBiome) {
        Map.Entry structureEntry;
        block0: for (GenerationStage.Decoration decorationType : GenerationStage.Decoration.values()) {
            for (ConfiguredFeature feature : vanillaBiome.func_203607_a(decorationType)) {
                SphereReplaceConfig sphereReplaceConfig;
                if (uaBiome.func_203607_a(decorationType).contains(feature) || !(feature.field_222738_b instanceof DecoratedFeatureConfig)) continue block0;
                DecoratedFeatureConfig insideConfig = (DecoratedFeatureConfig)feature.field_222738_b;
                Feature insideFeature = insideConfig.field_214689_a.field_222737_a;
                ResourceLocation rl = FeatureRegistry.getKey((IForgeRegistryEntry)insideFeature);
                if (rl == null) continue;
                String namespace = rl.func_110624_b();
                if (UltraAmplified.UAConfig.importModdedStructure.get().booleanValue() && insideFeature instanceof Structure) {
                    if (blacklistedFeatureMods.contains(namespace) || UltraAmplified.UAConfig.blacklistedStructureList.get().contains(rl.toString()) || listOfVanillaStructureFeatures.contains(insideFeature)) continue;
                    uaBiome.func_203611_a(decorationType, feature);
                    continue;
                }
                if (!UltraAmplified.UAConfig.importModdedFeatures.get().booleanValue()) continue;
                if (insideFeature instanceof OreFeature) {
                    OreFeatureConfig oreConfig = (OreFeatureConfig)insideConfig.field_214689_a.field_222738_b;
                    if (!BiomeAddModdedFeatures.checkIfBlockIsAllowed(oreConfig.field_202444_d.func_177230_c())) continue;
                    uaBiome.func_203611_a(decorationType, feature);
                    continue;
                }
                if (insideFeature instanceof SphereReplaceFeature) {
                    sphereReplaceConfig = (SphereReplaceConfig)insideConfig.field_214689_a.field_222738_b;
                    if (!BiomeAddModdedFeatures.checkIfBlockIsAllowed(sphereReplaceConfig.field_214693_a.func_177230_c())) continue;
                    uaBiome.func_203611_a(decorationType, feature);
                    continue;
                }
                if (insideFeature instanceof BlockBlobFeature) {
                    BlockBlobConfig doublePlantConfig = (BlockBlobConfig)insideConfig.field_214689_a.field_222738_b;
                    if (!BiomeAddModdedFeatures.checkIfBlockIsAllowed(doublePlantConfig.field_214683_a.func_177230_c())) continue;
                    uaBiome.func_203611_a(decorationType, feature);
                    continue;
                }
                if (insideFeature instanceof LakesFeature) {
                    BlockStateFeatureConfig lakeConfig = (BlockStateFeatureConfig)insideConfig.field_214689_a.field_222738_b;
                    if (!BiomeAddModdedFeatures.checkIfBlockIsAllowed(lakeConfig.field_227270_a_.func_177230_c())) continue;
                    uaBiome.func_203611_a(decorationType, feature);
                    continue;
                }
                if (insideFeature instanceof SpringFeature) {
                    LiquidsConfig springConfig = (LiquidsConfig)insideConfig.field_214689_a.field_222738_b;
                    if (!BiomeAddModdedFeatures.checkIfBlockIsAllowed(springConfig.field_214678_a.func_206883_i().func_177230_c())) continue;
                    uaBiome.func_203611_a(decorationType, feature);
                    continue;
                }
                if (insideFeature instanceof BlockWithContextFeature) {
                    sphereReplaceConfig = (BlockWithContextConfig)insideConfig.field_214689_a.field_222738_b;
                    if (!BiomeAddModdedFeatures.checkIfBlockIsAllowed(sphereReplaceConfig.field_206924_a.func_177230_c())) continue;
                    uaBiome.func_203611_a(decorationType, feature);
                    continue;
                }
                if (insideFeature instanceof MultipleWithChanceRandomFeature) {
                    MultipleRandomFeatureConfig randConfig = (MultipleRandomFeatureConfig)insideConfig.field_214689_a.field_222738_b;
                    insideFeature = ((ConfiguredRandomFeatureList)randConfig.field_202449_a.get((int)0)).field_214842_a.field_222737_a;
                    rl = FeatureRegistry.getKey((IForgeRegistryEntry)insideFeature);
                    if (rl == null || (namespace = rl.func_110624_b()).equals("minecraft")) continue;
                    uaBiome.func_203611_a(decorationType, feature);
                    continue;
                }
                if (namespace.equals("minecraft")) continue;
                uaBiome.func_203611_a(decorationType, feature);
            }
        }
        Iterator iterator = vanillaBiome.field_201874_aj.entrySet().iterator();
        while (iterator.hasNext() && !uaBiome.field_201874_aj.containsKey(structureEntry = (Map.Entry)iterator.next())) {
            ResourceLocation rl = ((Structure)structureEntry.getKey()).getRegistryName();
            String namespace = rl.func_110624_b();
            if (blacklistedFeatureMods.contains(namespace) || UltraAmplified.UAConfig.blacklistedStructureList.get().contains(rl.toString()) || !UltraAmplified.UAConfig.importModdedStructure.get().booleanValue() || listOfVanillaStructures.contains(structureEntry.getKey())) continue;
            uaBiome.addStructure(structureEntry);
        }
        block3: for (EntityClassification entityType : EntityClassification.values()) {
            for (Biome.SpawnListEntry spawnEntry : vanillaBiome.func_76747_a(entityType)) {
                if (uaBiome.func_76747_a(entityType).contains(spawnEntry)) continue block3;
                if (!UltraAmplified.UAConfig.importModdedMobs.get().booleanValue() || listOfVanillaMobs.contains(spawnEntry.field_200702_b)) continue;
                uaBiome.func_201866_a(entityType, spawnEntry);
            }
        }
    }

    /*
     * Could not resolve type clashes
     */
    private static void resetBiomesBackToDefault() {
        for (Biome uaBiome : UABiomes.getBiomeArray()) {
            String namespace;
            ResourceLocation rl;
            for (GenerationStage.Decoration decorationType : GenerationStage.Decoration.values()) {
                for (int featureIndex = uaBiome.func_203607_a(decorationType).size() - 1; featureIndex >= 0 && ((ConfiguredFeature)uaBiome.func_203607_a((GenerationStage.Decoration)decorationType).get((int)featureIndex)).field_222738_b instanceof DecoratedFeatureConfig; --featureIndex) {
                    SphereReplaceConfig sphereReplaceConfig;
                    DecoratedFeatureConfig insideConfig = (DecoratedFeatureConfig)((ConfiguredFeature)uaBiome.func_203607_a((GenerationStage.Decoration)decorationType).get((int)featureIndex)).field_222738_b;
                    Feature insideFeature = insideConfig.field_214689_a.field_222737_a;
                    rl = FeatureRegistry.getKey((IForgeRegistryEntry)insideFeature);
                    if (rl == null) continue;
                    namespace = rl.func_110624_b();
                    if (insideFeature instanceof Structure) {
                        if (listOfVanillaStructureFeatures.contains(insideFeature) || namespace.equals("ultra_amplified_dimension")) continue;
                        uaBiome.func_203607_a(decorationType).remove(featureIndex);
                        continue;
                    }
                    if (insideFeature instanceof OreFeature) {
                        OreFeatureConfig oreConfig = (OreFeatureConfig)insideConfig.field_214689_a.field_222738_b;
                        if (!BiomeAddModdedFeatures.checkIfBlockIsAllowed(oreConfig.field_202444_d.func_177230_c())) continue;
                        uaBiome.func_203607_a(decorationType).remove(featureIndex);
                        continue;
                    }
                    if (insideFeature instanceof SphereReplaceFeature) {
                        sphereReplaceConfig = (SphereReplaceConfig)insideConfig.field_214689_a.field_222738_b;
                        if (!BiomeAddModdedFeatures.checkIfBlockIsAllowed(sphereReplaceConfig.field_214693_a.func_177230_c())) continue;
                        uaBiome.func_203607_a(decorationType).remove(featureIndex);
                        continue;
                    }
                    if (insideFeature instanceof BlockBlobFeature) {
                        BlockBlobConfig blockBlobConfig = (BlockBlobConfig)insideConfig.field_214689_a.field_222738_b;
                        if (!BiomeAddModdedFeatures.checkIfBlockIsAllowed(blockBlobConfig.field_214683_a.func_177230_c())) continue;
                        uaBiome.func_203607_a(decorationType).remove(featureIndex);
                        continue;
                    }
                    if (insideFeature instanceof BlockWithContextFeature) {
                        sphereReplaceConfig = (BlockWithContextConfig)insideConfig.field_214689_a.field_222738_b;
                        if (!BiomeAddModdedFeatures.checkIfBlockIsAllowed(sphereReplaceConfig.field_206924_a.func_177230_c())) continue;
                        uaBiome.func_203607_a(decorationType).remove(featureIndex);
                        continue;
                    }
                    if (insideFeature instanceof LakesFeature) {
                        BlockStateFeatureConfig blockStateFeatureConfig = (BlockStateFeatureConfig)insideConfig.field_214689_a.field_222738_b;
                        if (!BiomeAddModdedFeatures.checkIfBlockIsAllowed(blockStateFeatureConfig.field_227270_a_.func_177230_c())) continue;
                        uaBiome.func_203607_a(decorationType).remove(featureIndex);
                        continue;
                    }
                    if (insideFeature instanceof SpringFeature) {
                        LiquidsConfig springConfig = (LiquidsConfig)insideConfig.field_214689_a.field_222738_b;
                        if (!BiomeAddModdedFeatures.checkIfBlockIsAllowed(springConfig.field_214678_a.func_206883_i().func_177230_c())) continue;
                        uaBiome.func_203607_a(decorationType).remove(featureIndex);
                        continue;
                    }
                    if (insideFeature instanceof MultipleWithChanceRandomFeature) {
                        MultipleRandomFeatureConfig randConfig = (MultipleRandomFeatureConfig)insideConfig.field_214689_a.field_222738_b;
                        insideFeature = ((ConfiguredRandomFeatureList)randConfig.field_202449_a.get((int)0)).field_214842_a.field_222737_a;
                        rl = FeatureRegistry.getKey((IForgeRegistryEntry)insideFeature);
                        if (rl == null) continue;
                        namespace = rl.func_110624_b();
                        if (!UltraAmplified.UAConfig.importModdedFeatures.get().booleanValue() || namespace.equals("minecraft")) continue;
                        uaBiome.func_203607_a(decorationType).remove(featureIndex);
                        continue;
                    }
                    if (namespace.equals("minecraft") || namespace.equals("ultra_amplified_dimension")) continue;
                    uaBiome.func_203607_a(decorationType).remove(featureIndex);
                }
            }
            ArrayList listOfStructureToRemove = new ArrayList();
            for (Map.Entry structureEntry : uaBiome.field_201874_aj.entrySet()) {
                String namespace2 = ((Structure)structureEntry.getKey()).getRegistryName().func_110624_b();
                if (listOfVanillaStructures.contains(structureEntry.getKey()) || namespace2.equals("ultra_amplified_dimension")) continue;
                listOfStructureToRemove.add(structureEntry.getKey());
            }
            for (Structure structToRemove : listOfStructureToRemove) {
                uaBiome.field_201874_aj.remove(structToRemove);
            }
            for (Iterator entityType : EntityClassification.values()) {
                for (int spawnListIndex = uaBiome.func_76747_a(entityType).size() - 1; spawnListIndex >= 0; --spawnListIndex) {
                    EntityType entity = ((Biome.SpawnListEntry)uaBiome.func_76747_a(entityType).get((int)spawnListIndex)).field_200702_b;
                    rl = EntityRegistry.getKey((IForgeRegistryEntry)entity);
                    if (rl == null) continue;
                    namespace = rl.func_110624_b();
                    if (listOfVanillaMobs.contains(entity) || namespace.equals("ultra_amplified_dimension")) continue;
                    uaBiome.func_76747_a(entityType).remove(spawnListIndex);
                }
            }
        }
    }

    private static boolean checkIfBlockIsAllowed(Block blockToCheck) {
        ResourceLocation rl = BlockRegistry.getKey((IForgeRegistryEntry)blockToCheck);
        if (rl == null) {
            return false;
        }
        String namespace = rl.func_110624_b();
        return !namespace.equals("minecraft") && !namespace.equals("ultra_amplified_dimension");
    }

    @Mod.EventBusSubscriber(modid="ultra_amplified_dimension")
    private static class ForgeEvents {
        private ForgeEvents() {
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void Load(WorldEvent.Load event) {
            if (FeatureRegistry == null) {
                throw new NullPointerException("Feature Registry not set");
            }
            if (EntityRegistry == null) {
                throw new NullPointerException("Entity Registry not set");
            }
            if (BlockRegistry == null) {
                throw new NullPointerException("Block Registry not set");
            }
            BiomeAddModdedFeatures.resetBiomesBackToDefault();
            blacklistedFeatureMods = new ArrayList();
            blacklistedFeatureResourceLocations = new LinkedList<String>(Arrays.asList(UltraAmplified.UAConfig.blacklistedStructureList.get().split(",")));
            for (int i = 0; i < blacklistedFeatureResourceLocations.size(); ++i) {
                blacklistedFeatureResourceLocations.set(i, ((String)blacklistedFeatureResourceLocations.get(i)).trim());
            }
            for (String entry : blacklistedFeatureResourceLocations) {
                if (!entry.contains(":*")) continue;
                blacklistedFeatureMods.add(entry.split(":")[0]);
            }
            int biomeIndex = 0;
            for (Biome biome : UABiomes.getBiomeArray()) {
                if (biomeIndex == vanillaBiomesToCheck.length) break;
                BiomeAddModdedFeatures.addModdedFeatureAndSpawns(vanillaBiomesToCheck[biomeIndex], (UABiome)biome);
                ++biomeIndex;
            }
            BiomeAddModdedFeatures.addModdedFeatureAndSpawns(Biomes.field_201936_P, (UABiome)UABiomes.END_FIELD);
            BiomeAddModdedFeatures.addModdedFeatureAndSpawns(Biomes.field_201937_Q, (UABiome)UABiomes.END_FIELD);
            BiomeAddModdedFeatures.addModdedFeatureAndSpawns(Biomes.field_201938_R, (UABiome)UABiomes.END_FIELD);
            BiomeAddModdedFeatures.addModdedFeatureAndSpawns(Biomes.field_201939_S, (UABiome)UABiomes.END_FIELD);
            BiomeAddModdedFeatures.addModdedFeatureAndSpawns(Biomes.field_201939_S, (UABiome)UABiomes.BARREN_END_FIELD);
        }
    }
}

