/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.biome.surfacebuilder;

import com.mojang.datafixers.Dynamic;
import java.util.Arrays;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.PerlinNoiseGenerator;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;

public class BadlandsSurfaceBuilderUA
extends SurfaceBuilder<SurfaceBuilderConfig> {
    private static final BlockState WHITE_TERRACOTTA = Blocks.field_196777_fo.func_176223_P();
    private static final BlockState ORANGE_TERRACOTTA = Blocks.field_196778_fp.func_176223_P();
    private static final BlockState TERRACOTTA = Blocks.field_150405_ch.func_176223_P();
    private static final BlockState YELLOW_TERRACOTTA = Blocks.field_196783_fs.func_176223_P();
    private static final BlockState BROWN_TERRACOTTA = Blocks.field_196719_fA.func_176223_P();
    private static final BlockState RED_TERRACOTTA = Blocks.field_196721_fC.func_176223_P();
    private static final BlockState LIGHT_GRAY_TERRACOTTA = Blocks.field_196791_fw.func_176223_P();
    protected BlockState[] field_215432_a;
    protected long field_215433_b;
    protected PerlinNoiseGenerator field_215435_c;
    protected PerlinNoiseGenerator field_215437_d;
    protected PerlinNoiseGenerator field_215439_e;

    public BadlandsSurfaceBuilderUA(Function<Dynamic<?>, ? extends SurfaceBuilderConfig> p_i51317_1_) {
        super(p_i51317_1_);
    }

    public void buildSurface(Random random, IChunk chunkIn, Biome biomeIn, int x, int z, int startHeight, double noise, BlockState defaultBlock, BlockState defaultFluid, int seaLevel, long seed, SurfaceBuilderConfig config) {
        int i = x & 0xF;
        int j = z & 0xF;
        BlockState blockstate = WHITE_TERRACOTTA;
        BlockState blockstate1 = biomeIn.func_203944_q().func_204109_b();
        int k = (int)(noise / 3.0 + 3.0 + random.nextDouble() * 0.25);
        boolean flag = Math.cos(noise / 3.0 * Math.PI) > 0.0;
        int l = -1;
        boolean flag1 = false;
        int i1 = 0;
        BlockPos.Mutable blockpos$Mutable = new BlockPos.Mutable();
        for (int j1 = startHeight; j1 >= 0; --j1) {
            if (i1 >= 15) continue;
            blockpos$Mutable.func_181079_c(i, j1, j);
            BlockState blockstate2 = chunkIn.func_180495_p((BlockPos)blockpos$Mutable);
            if (blockstate2.func_185904_a() == Material.field_151579_a) {
                l = -1;
                continue;
            }
            if (blockstate2.func_177230_c() != defaultBlock.func_177230_c()) continue;
            if (l == -1) {
                flag1 = false;
                if (k <= 0) {
                    blockstate = Blocks.field_150350_a.func_176223_P();
                    blockstate1 = defaultBlock;
                } else if (j1 >= seaLevel - 4 && j1 <= seaLevel + 1) {
                    blockstate = WHITE_TERRACOTTA;
                    blockstate1 = biomeIn.func_203944_q().func_204109_b();
                }
                if (j1 < seaLevel && (blockstate == null || blockstate.func_185904_a() == Material.field_151579_a)) {
                    blockstate = defaultFluid;
                }
                l = k + Math.max(0, j1 - seaLevel);
                if (j1 >= seaLevel - 1) {
                    if (j1 > seaLevel + 3 + k && chunkIn.func_180495_p(blockpos$Mutable.func_177977_b()).func_185904_a() != Material.field_151579_a) {
                        chunkIn.func_177436_a((BlockPos)blockpos$Mutable, biomeIn.func_203944_q().func_204108_a(), false);
                        flag1 = true;
                    } else {
                        BlockState blockstate3 = j1 >= 64 && j1 <= 127 ? (flag ? TERRACOTTA : this.func_215431_a(x, j1, z)) : ORANGE_TERRACOTTA;
                        chunkIn.func_177436_a((BlockPos)blockpos$Mutable, blockstate3, false);
                    }
                } else {
                    chunkIn.func_177436_a((BlockPos)blockpos$Mutable, blockstate1, false);
                    Block block = blockstate1.func_177230_c();
                    if (block == Blocks.field_196777_fo || block == Blocks.field_196778_fp || block == Blocks.field_196780_fq || block == Blocks.field_196782_fr || block == Blocks.field_196783_fs || block == Blocks.field_196785_ft || block == Blocks.field_196787_fu || block == Blocks.field_196789_fv || block == Blocks.field_196791_fw || block == Blocks.field_196793_fx || block == Blocks.field_196795_fy || block == Blocks.field_196797_fz || block == Blocks.field_196719_fA || block == Blocks.field_196720_fB || block == Blocks.field_196721_fC || block == Blocks.field_196722_fD) {
                        chunkIn.func_177436_a((BlockPos)blockpos$Mutable, ORANGE_TERRACOTTA, false);
                    }
                }
            } else if (l > 0) {
                --l;
                if (flag1) {
                    chunkIn.func_177436_a((BlockPos)blockpos$Mutable, ORANGE_TERRACOTTA, false);
                } else {
                    chunkIn.func_177436_a((BlockPos)blockpos$Mutable, this.func_215431_a(x, j1, z), false);
                }
            }
            ++i1;
        }
    }

    public void func_205548_a(long seed) {
        if (this.field_215433_b != seed || this.field_215432_a == null) {
            this.func_215430_b(seed);
        }
        if (this.field_215433_b != seed || this.field_215435_c == null || this.field_215437_d == null) {
            SharedSeedRandom random = new SharedSeedRandom(seed);
            this.field_215435_c = new PerlinNoiseGenerator(random, 3, 0);
            this.field_215437_d = new PerlinNoiseGenerator(random, 0, 0);
        }
        this.field_215433_b = seed;
    }

    protected void func_215430_b(long p_215430_1_) {
        this.field_215432_a = new BlockState[64];
        Arrays.fill(this.field_215432_a, TERRACOTTA);
        SharedSeedRandom random = new SharedSeedRandom(p_215430_1_);
        this.field_215439_e = new PerlinNoiseGenerator(random, 0, 0);
        for (int l1 = 0; l1 < 64; ++l1) {
            if ((l1 += random.nextInt(5) + 1) >= 64) continue;
            this.field_215432_a[l1] = ORANGE_TERRACOTTA;
        }
        int i2 = random.nextInt(4) + 2;
        for (int i = 0; i < i2; ++i) {
            int j = random.nextInt(3) + 1;
            int k = random.nextInt(64);
            for (int l = 0; k + l < 64 && l < j; ++l) {
                this.field_215432_a[k + l] = YELLOW_TERRACOTTA;
            }
        }
        int j2 = random.nextInt(4) + 2;
        for (int k2 = 0; k2 < j2; ++k2) {
            int i3 = random.nextInt(3) + 2;
            int l3 = random.nextInt(64);
            for (int i1 = 0; l3 + i1 < 64 && i1 < i3; ++i1) {
                this.field_215432_a[l3 + i1] = BROWN_TERRACOTTA;
            }
        }
        int l2 = random.nextInt(4) + 2;
        for (int j3 = 0; j3 < l2; ++j3) {
            int i4 = random.nextInt(3) + 1;
            int k4 = random.nextInt(64);
            for (int j1 = 0; k4 + j1 < 64 && j1 < i4; ++j1) {
                this.field_215432_a[k4 + j1] = RED_TERRACOTTA;
            }
        }
        int k3 = random.nextInt(3) + 3;
        int j4 = 0;
        for (int l4 = 0; l4 < k3; ++l4) {
            j4 += random.nextInt(16) + 4;
            for (int k1 = 0; j4 + k1 < 64 && k1 < 1; ++k1) {
                this.field_215432_a[j4 + k1] = WHITE_TERRACOTTA;
                if (j4 + k1 > 1 && random.nextBoolean()) {
                    this.field_215432_a[j4 + k1 - 1] = LIGHT_GRAY_TERRACOTTA;
                }
                if (j4 + k1 >= 63 || !random.nextBoolean()) continue;
                this.field_215432_a[j4 + k1 + 1] = LIGHT_GRAY_TERRACOTTA;
            }
        }
    }

    protected BlockState func_215431_a(int p_215431_1_, int p_215431_2_, int p_215431_3_) {
        int i = (int)Math.round(this.field_215439_e.func_215464_a((double)p_215431_1_ / 512.0, (double)p_215431_3_ / 512.0, false) * 2.0);
        return this.field_215432_a[(p_215431_2_ + i + 64) % 64];
    }
}

