/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.biome.surfacebuilder;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;

public class GravelSurfaceBuilder
extends SurfaceBuilder<SurfaceBuilderConfig> {
    private static final BlockState AIR = Blocks.field_150350_a.func_176223_P();
    private static final BlockState STONE = Blocks.field_150348_b.func_176223_P();

    public GravelSurfaceBuilder(Function<Dynamic<?>, ? extends SurfaceBuilderConfig> p_i51310_1_) {
        super(p_i51310_1_);
    }

    public void buildSurface(Random random, IChunk chunkIn, Biome biomeIn, int x, int z, int startHeight, double noise, BlockState defaultBlock, BlockState defaultFluid, int seaLevel, long seed, SurfaceBuilderConfig config) {
        this.buildSurface(random, chunkIn, biomeIn, x, z, startHeight, noise, defaultBlock, defaultFluid, config.func_204108_a(), config.func_204109_b(), config.func_204110_c(), seaLevel);
    }

    protected void buildSurface(Random random, IChunk chunkIn, Biome biomeIn, int xStart, int zStart, int startHeight, double noise, BlockState defaultBlock, BlockState defaultFluid, BlockState topBlock, BlockState middleBlock, BlockState bottomBlock, int seaLevel) {
        BlockState iblockstate = topBlock;
        BlockState iblockstate1 = middleBlock;
        BlockPos.Mutable blockpos$Mutable = new BlockPos.Mutable();
        int bottomLayerNoise = -1;
        int noiseThing = (int)(noise / 3.0 + 3.0 + random.nextDouble() * 0.25);
        int x = xStart & 0xF;
        int z = zStart & 0xF;
        for (int y = startHeight; y >= 0; --y) {
            blockpos$Mutable.func_181079_c(x, y, z);
            BlockState iblockstate2 = chunkIn.func_180495_p((BlockPos)blockpos$Mutable);
            if (iblockstate2.func_185904_a() == Material.field_151579_a) {
                bottomLayerNoise = -1;
            } else if (iblockstate2.func_177230_c() == defaultBlock.func_177230_c()) {
                if (bottomLayerNoise == -1) {
                    if (noiseThing <= 0) {
                        iblockstate = Blocks.field_150350_a.func_176223_P();
                        iblockstate1 = defaultBlock;
                    } else if (y >= seaLevel - 4 && y <= seaLevel + 1) {
                        iblockstate = topBlock;
                        iblockstate1 = middleBlock;
                    }
                    if (y < seaLevel && (iblockstate == null || iblockstate.func_185904_a() == Material.field_151579_a)) {
                        iblockstate = biomeIn.func_225486_c((BlockPos)blockpos$Mutable.func_181079_c(xStart, y, zStart)) < 0.15f ? Blocks.field_150432_aD.func_176223_P() : defaultFluid;
                        blockpos$Mutable.func_181079_c(x, y, z);
                    }
                    bottomLayerNoise = noiseThing;
                    if (y >= seaLevel - 1) {
                        chunkIn.func_177436_a((BlockPos)blockpos$Mutable, iblockstate, false);
                    } else if (y < seaLevel - 7 - noiseThing) {
                        iblockstate = Blocks.field_150350_a.func_176223_P();
                        iblockstate1 = defaultBlock;
                        chunkIn.func_177436_a((BlockPos)blockpos$Mutable, bottomBlock, false);
                    } else {
                        chunkIn.func_177436_a((BlockPos)blockpos$Mutable, iblockstate1, false);
                    }
                } else if (bottomLayerNoise > 0) {
                    --bottomLayerNoise;
                    chunkIn.func_177436_a((BlockPos)blockpos$Mutable, iblockstate1, false);
                }
            }
            if (y >= 256 || y <= 0) continue;
            Material materialAbove = chunkIn.func_180495_p(blockpos$Mutable.func_177984_a()).func_185904_a();
            Material materialBelow = chunkIn.func_180495_p(blockpos$Mutable.func_177977_b()).func_185904_a();
            if (materialBelow != Material.field_151579_a) continue;
            if (materialAbove == Material.field_151595_p) {
                chunkIn.func_177436_a((BlockPos)blockpos$Mutable, STONE, false);
                continue;
            }
            if (materialAbove != Material.field_151579_a) continue;
            chunkIn.func_177436_a(blockpos$Mutable.func_177984_a(), AIR, false);
        }
    }
}

