/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.biome.surfacebuilder;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;
import net.telepathicgrunt.ultraamplified.UltraAmplified;
import net.telepathicgrunt.ultraamplified.utils.OpenSimplexNoise;

public class NetherSurfaceBuilderUA
extends SurfaceBuilder<SurfaceBuilderConfig> {
    private static final BlockState STONE = Blocks.field_150348_b.func_176223_P();
    private static final BlockState CAVE_AIR = Blocks.field_201941_jj.func_176223_P();
    private static final BlockState NETHERRACK = Blocks.field_150424_aL.func_176223_P();
    private static final BlockState GRAVEL = Blocks.field_150351_n.func_176223_P();
    private static final BlockState SOUL_SAND = Blocks.field_150425_aM.func_176223_P();
    private static final BlockState LAVA = Blocks.field_150353_l.func_176223_P();
    private static final BlockState WATER = Blocks.field_150355_j.func_176223_P();
    private static final BlockState MAGMA = Blocks.field_196814_hQ.func_176223_P();
    protected long noiseSeed;
    protected OpenSimplexNoise noiseGen;

    public NetherSurfaceBuilderUA(Function<Dynamic<?>, ? extends SurfaceBuilderConfig> p_i51310_1_) {
        super(p_i51310_1_);
    }

    public void func_205548_a(long seed) {
        if (this.noiseSeed != seed || this.noiseGen == null) {
            this.noiseGen = new OpenSimplexNoise(seed);
        }
        this.noiseSeed = seed;
    }

    public void buildSurface(Random random, IChunk chunkIn, Biome biomeIn, int x, int z, int startHeight, double noise, BlockState defaultBlock, BlockState defaultFluid, int seaLevel, long seed, SurfaceBuilderConfig config) {
        int sealevel = seaLevel + 1;
        int xpos = x & 0xF;
        int zpos = z & 0xF;
        int noiseDepth = (int)(noise / 3.0 + 3.0 + random.nextDouble() * 0.25);
        BlockPos.Mutable blockpos$Mutable = new BlockPos.Mutable();
        int depth = -1;
        BlockState topBlockstate = NETHERRACK;
        BlockState bottomBlockstates = NETHERRACK;
        for (int ypos = startHeight; ypos >= 0; --ypos) {
            boolean gravelFlag;
            blockpos$Mutable.func_181079_c(xpos, ypos, zpos);
            BlockState currentBlockToReplace = chunkIn.func_180495_p((BlockPos)blockpos$Mutable);
            if (currentBlockToReplace.func_177230_c() == null || currentBlockToReplace.func_185904_a() == Material.field_151579_a) {
                depth = -1;
                continue;
            }
            if (currentBlockToReplace.func_185904_a() == Material.field_151586_h) {
                if (ypos < UltraAmplified.UAConfig.seaLevel.get() - 7) {
                    chunkIn.func_177436_a((BlockPos)blockpos$Mutable, LAVA, false);
                } else {
                    chunkIn.func_177436_a((BlockPos)blockpos$Mutable, UltraAmplified.UAConfig.lavaOcean.get() != false ? LAVA : WATER, false);
                }
                depth = -1;
                continue;
            }
            if (currentBlockToReplace != STONE) continue;
            boolean soulSandFlag = this.noiseGen.eval((double)x * 0.015, ypos / 7, (double)z * 0.015) > 0.45;
            boolean bl = gravelFlag = this.noiseGen.eval((double)x * 0.02 + 100.0, ypos / 8, (double)z * 0.02 - 100.0) > 0.48;
            if (depth == -1) {
                if (noiseDepth <= 0) {
                    topBlockstate = CAVE_AIR;
                    bottomBlockstates = NETHERRACK;
                } else if (ypos >= sealevel - 4) {
                    topBlockstate = NETHERRACK;
                    bottomBlockstates = NETHERRACK;
                    if (soulSandFlag) {
                        topBlockstate = SOUL_SAND;
                        bottomBlockstates = SOUL_SAND;
                    } else if (gravelFlag) {
                        topBlockstate = GRAVEL;
                    } else if (noise > -3.85 && noise < -3.7 || noise > -0.1 && noise < 0.05 || noise > 3.7 && noise < 3.85) {
                        topBlockstate = MAGMA;
                    }
                }
                depth = noiseDepth;
                if (ypos >= sealevel - 1) {
                    chunkIn.func_177436_a((BlockPos)blockpos$Mutable, topBlockstate, false);
                    if (!gravelFlag || !chunkIn.func_180495_p(blockpos$Mutable.func_177977_b()).func_196958_f()) continue;
                    chunkIn.func_177436_a(blockpos$Mutable.func_177977_b(), NETHERRACK, false);
                    continue;
                }
                chunkIn.func_177436_a((BlockPos)blockpos$Mutable, bottomBlockstates, false);
                continue;
            }
            if (depth > 0) {
                --depth;
                chunkIn.func_177436_a((BlockPos)blockpos$Mutable, bottomBlockstates, false);
                continue;
            }
            chunkIn.func_177436_a((BlockPos)blockpos$Mutable, NETHERRACK, false);
        }
    }
}

