/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.dimension;

import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.GameRules;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.ChunkGeneratorType;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.OverworldGenSettings;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.telepathicgrunt.ultraamplified.UltraAmplified;
import net.telepathicgrunt.ultraamplified.world.dimension.TimeSyncNetworkPacket;
import net.telepathicgrunt.ultraamplified.world.dimension.UAWorldSavedData;
import net.telepathicgrunt.ultraamplified.world.feature.carver.CaveCavityCarver;
import net.telepathicgrunt.ultraamplified.world.generation.UABiomeProvider;
import net.telepathicgrunt.ultraamplified.world.generation.UAChunkGenerator;

public class UADimension
extends Dimension {
    private boolean syncedTimeFromMemory = false;
    private long time = 0L;

    public UADimension(World world, DimensionType typeIn) {
        super(world, typeIn, 1.0f);
        for (int i = 0; i <= 15; ++i) {
            this.field_76573_f[i] = (float)i / 20.0f;
        }
    }

    public ChunkGenerator<?> func_186060_c() {
        CaveCavityCarver.setSeed(this.field_76579_a.func_72905_C());
        return new UAChunkGenerator((IWorld)this.field_76579_a, new UABiomeProvider(this.field_76579_a), (OverworldGenSettings)ChunkGeneratorType.field_206911_b.func_205483_a());
    }

    public void func_186057_q() {
        if (!this.field_76579_a.field_72995_K) {
            UAWorldSavedData.get(this.field_76579_a).setTimeUA(this.time);
            UAWorldSavedData.get(this.field_76579_a).func_76185_a();
        }
    }

    public void func_186059_r() {
        if (!this.field_76579_a.field_72995_K) {
            if (!this.syncedTimeFromMemory) {
                this.time = UAWorldSavedData.get(this.field_76579_a).getTimeUA();
                TimeSyncNetworkPacket.UpdateTimePacket.sendToClient(this.time);
                this.syncedTimeFromMemory = true;
            }
            if (this.field_76579_a.func_82736_K().func_223586_b(GameRules.field_223607_j)) {
                ++this.time;
                if (this.time % 100L == 0L) {
                    TimeSyncNetworkPacket.UpdateTimePacket.sendToClient(this.time);
                }
            }
        }
    }

    public boolean isDaytime() {
        long timeOfDay = this.time % 24000L;
        return timeOfDay - 13000L <= 0L || timeOfDay - 13000L >= 10000L;
    }

    public long getWorldTime() {
        return this.time;
    }

    public void setWorldTime(long timeIn) {
        if (!this.field_76579_a.field_72995_K && this.field_76579_a.func_72912_H().func_76073_f() + 1L != timeIn) {
            this.time = timeIn;
            UAWorldSavedData.get(this.field_76579_a).setTimeUA(this.time);
            UAWorldSavedData.get(this.field_76579_a).func_76185_a();
            TimeSyncNetworkPacket.UpdateTimePacket.sendToClient(this.time);
        }
        super.setWorldTime(timeIn);
    }

    public void setWorldTimeClientSided(long timeIn) {
        this.time = timeIn;
    }

    public int func_76559_b(long worldTime) {
        return (int)(this.time / 24000L % 8L + 8L) % 8;
    }

    public float func_76563_a(long worldTime, float partialTicks) {
        double d0 = MathHelper.func_181162_h((double)((double)this.time / 24000.0 - 0.25));
        double d1 = 0.5 - Math.cos(d0 * Math.PI) / 2.0;
        return (float)(d0 * 2.0 + d1) / 3.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_76571_f() {
        return UltraAmplified.UAConfig.yMaximum.get() + 2;
    }

    public int getActualHeight() {
        return 256;
    }

    public boolean func_177495_o() {
        return false;
    }

    public boolean func_76569_d() {
        return true;
    }

    public Vec3d func_76562_b(float celestialAngle, float partialTicks) {
        float f = MathHelper.func_76134_b((float)(celestialAngle * ((float)Math.PI * 2))) * 2.0f + 0.5f;
        f = MathHelper.func_76131_a((float)f, (float)0.0f, (float)1.0f);
        float f1 = 0.7529412f;
        float f2 = 0.84705883f;
        float f3 = 1.0f;
        float multiplierOfBrightness = ((float)Minecraft.func_71410_x().field_71439_g.func_174824_e((float)partialTicks).field_72448_b - 85.0f) / (float)(UltraAmplified.UAConfig.yMaximum.get() - 85);
        Math.min(Math.max(multiplierOfBrightness, 0.0f), 1.0f);
        f1 = f1 * (f * 0.94f + 0.06f) * multiplierOfBrightness;
        f2 = f2 * (f * 0.94f + 0.06f) * multiplierOfBrightness;
        f3 = f3 * (f * 0.91f + 0.09f) * multiplierOfBrightness;
        return new Vec3d((double)f1, (double)f2, (double)f3);
    }

    @OnlyIn(value=Dist.CLIENT)
    public double func_76565_k() {
        return 1.0;
    }

    public boolean func_76568_b(int x, int z) {
        return UltraAmplified.UAConfig.heavyFog.get();
    }

    public boolean func_76567_e() {
        return UltraAmplified.UAConfig.bedExplodes.get() == false;
    }

    public BlockPos func_206920_a(ChunkPos chunkPosIn, boolean checkValid) {
        BlockPos blockpos = this.field_76579_a.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, new BlockPos(10, 90, 8));
        if (this.field_76579_a.func_180495_p(blockpos).func_204520_s().func_206884_a(FluidTags.field_206960_b)) {
            this.field_76579_a.func_180501_a(blockpos, Blocks.field_150343_Z.func_176223_P(), 3);
        }
        return blockpos;
    }

    public BlockPos func_206921_a(int posX, int posZ, boolean checkValid) {
        return this.func_206920_a(new ChunkPos(posX, posZ), checkValid);
    }
}

