/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.dimension;

import java.util.function.BiFunction;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerPropertiesProvider;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ModDimension;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.RegisterDimensionsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.telepathicgrunt.ultraamplified.UltraAmplified;
import net.telepathicgrunt.ultraamplified.utils.RegUtil;
import net.telepathicgrunt.ultraamplified.world.dimension.UADimension;
import net.telepathicgrunt.ultraamplified.world.dimension.UAOverworldDimension;

@Mod.EventBusSubscriber(modid="ultra_amplified_dimension", bus=Mod.EventBusSubscriber.Bus.MOD)
public class UADimensionRegistration {
    private static final ResourceLocation ULTRAAMPLIFIED_ID = new ResourceLocation("ultra_amplified_dimension", "ultraamplified");
    public static final ModDimension ULTRAAMPLIFIED = new ModDimension(){

        public BiFunction<World, DimensionType, ? extends Dimension> getFactory() {
            return UADimension::new;
        }
    };
    public static final ModDimension OVERWORLD_ULTRAAMPLIFIED = new ModDimension(){

        public BiFunction<World, DimensionType, ? extends Dimension> getFactory() {
            return UAOverworldDimension::new;
        }
    };

    public static DimensionType ultraamplified() {
        return DimensionType.func_193417_a((ResourceLocation)ULTRAAMPLIFIED_ID);
    }

    @SubscribeEvent
    public static void registerModDimensions(RegistryEvent.Register<ModDimension> event) {
        RegUtil.generic(event.getRegistry()).add("ultraamplified", ULTRAAMPLIFIED);
        RegUtil.generic(event.getRegistry()).add("overworld_ultraamplified", OVERWORLD_ULTRAAMPLIFIED);
    }

    @Mod.EventBusSubscriber(modid="ultra_amplified_dimension")
    private static class ForgeEvents {
        private static MinecraftServer server;

        private ForgeEvents() {
        }

        @SubscribeEvent
        public static void registerDimensions(FMLServerAboutToStartEvent event) {
            server = event.getServer();
        }

        @SubscribeEvent
        public static void registerDimensions(RegisterDimensionsEvent event) {
            ModDimension dimension = ULTRAAMPLIFIED;
            if (server != null) {
                WorldType worldtype = null;
                if (server instanceof DedicatedServer) {
                    ServerPropertiesProvider serverPropertiesProvider = (ServerPropertiesProvider)ObfuscationReflectionHelper.getPrivateValue(DedicatedServer.class, (Object)((DedicatedServer)server), (String)"field_71340_o");
                    worldtype = serverPropertiesProvider.func_219034_a().field_219023_q;
                } else if (server instanceof IntegratedServer) {
                    WorldSettings worldSettings = (WorldSettings)ObfuscationReflectionHelper.getPrivateValue(IntegratedServer.class, (Object)((IntegratedServer)server), (String)"field_71350_m");
                    worldtype = worldSettings.func_77165_h();
                }
                if (worldtype == UltraAmplified.UltraAmplifiedWorldType) {
                    dimension = OVERWORLD_ULTRAAMPLIFIED;
                }
            }
            if (DimensionManager.getRegistry().func_218349_b(ULTRAAMPLIFIED_ID).isPresent()) {
                int id = DimensionManager.getRegistry().func_148757_b((Object)DimensionType.func_193417_a((ResourceLocation)ULTRAAMPLIFIED_ID));
                DimensionManager.getRegistry().func_218382_a(id, ULTRAAMPLIFIED_ID, (Object)new DimensionType(id, "", ULTRAAMPLIFIED_ID.func_110624_b() + "/" + ULTRAAMPLIFIED_ID.func_110623_a(), dimension.getFactory(), true, dimension.getMagnifier(), dimension, null));
            } else {
                DimensionManager.registerDimension((ResourceLocation)ULTRAAMPLIFIED_ID, (ModDimension)dimension, null, (boolean)true);
            }
        }
    }
}

