/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.feature;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class BlueIceWaterfall
extends Feature<NoFeatureConfig> {
    private static final BlockState BLUE_ICE = Blocks.field_205164_gk.func_176223_P();
    private static final BlockState SNOW_BLOCK = Blocks.field_196604_cC.func_176223_P();
    private static final BlockState SNOW = Blocks.field_150433_aE.func_176223_P();
    private static final BlockState ICE = Blocks.field_150432_aD.func_176223_P();
    private static final BlockState AIR = Blocks.field_150350_a.func_176223_P();
    protected static final Set<Block> acceptableBlocks = ImmutableSet.of((Object)Blocks.field_150432_aD, (Object)Blocks.field_196604_cC, (Object)Blocks.field_150403_cj);

    public BlueIceWaterfall(Function<Dynamic<?>, ? extends NoFeatureConfig> configFactory) {
        super(configFactory);
    }

    public boolean place(IWorld world, ChunkGenerator<? extends GenerationSettings> changedBlock, Random rand, BlockPos position, NoFeatureConfig fluidConfig) {
        BlockPos.Mutable blockpos$Mutable = new BlockPos.Mutable(position);
        if (!acceptableBlocks.contains(world.func_180495_p(blockpos$Mutable.func_177984_a()).func_177230_c())) {
            return false;
        }
        int numberOfSolidSides = 0;
        int neededNumberOfSides = 0;
        neededNumberOfSides = !acceptableBlocks.contains(world.func_180495_p(blockpos$Mutable.func_177977_b()).func_177230_c()) ? 4 : 3;
        Direction emptySpot = Direction.NORTH;
        for (Object face : Direction.Plane.HORIZONTAL) {
            if (acceptableBlocks.contains(world.func_180495_p(blockpos$Mutable.func_177972_a((Direction)face)).func_177230_c())) {
                ++numberOfSolidSides;
                continue;
            }
            emptySpot = face;
        }
        if (numberOfSolidSides == neededNumberOfSides) {
            world.func_180501_a((BlockPos)blockpos$Mutable, BLUE_ICE, 2);
            if (numberOfSolidSides == 3) {
                blockpos$Mutable.func_189536_c(emptySpot);
                world.func_180501_a((BlockPos)blockpos$Mutable, BLUE_ICE, 2);
            }
            while (true) {
                if (blockpos$Mutable.func_177956_o() <= 1) {
                    return false;
                }
                blockpos$Mutable.func_189536_c(Direction.DOWN);
                if (world.func_180495_p((BlockPos)blockpos$Mutable).func_185904_a() == Material.field_151579_a || world.func_180495_p((BlockPos)blockpos$Mutable) == BLUE_ICE || world.func_180495_p((BlockPos)blockpos$Mutable) == SNOW_BLOCK) {
                    world.func_180501_a((BlockPos)blockpos$Mutable, BLUE_ICE, 2);
                    continue;
                }
                blockpos$Mutable.func_189536_c(Direction.UP);
                boolean spotFound = false;
                for (Direction face : Direction.Plane.HORIZONTAL) {
                    if (world.func_180495_p(blockpos$Mutable.func_177972_a(face)).func_185904_a() != Material.field_151579_a && world.func_180495_p(blockpos$Mutable.func_177972_a(face)) != BLUE_ICE || world.func_180495_p(blockpos$Mutable.func_177977_b().func_177972_a(face)).func_185904_a() != Material.field_151579_a && world.func_180495_p(blockpos$Mutable.func_177977_b().func_177972_a(face)) != BLUE_ICE) continue;
                    blockpos$Mutable.func_189536_c(emptySpot);
                    world.func_180501_a((BlockPos)blockpos$Mutable, BLUE_ICE, 2);
                    blockpos$Mutable.func_189536_c(Direction.DOWN);
                    world.func_180501_a((BlockPos)blockpos$Mutable, BLUE_ICE, 2);
                    spotFound = true;
                    if (blockpos$Mutable.func_177956_o() > 1) break;
                    return false;
                }
                if (!spotFound) break;
            }
            int width = rand.nextInt(2) + 2;
            for (int y = blockpos$Mutable.func_177956_o() - 1; y < blockpos$Mutable.func_177956_o() + 1; ++y) {
                block4: for (int x = -width; x <= width; ++x) {
                    for (int z = -width; z <= width; ++z) {
                        if (x * x + z * z > width * width) continue;
                        if (y <= 1 || y >= world.getMaxHeight()) continue block4;
                        BlockPos blockpos = new BlockPos(x + blockpos$Mutable.func_177958_n(), y, z + blockpos$Mutable.func_177952_p());
                        BlockState block = world.func_180495_p(blockpos);
                        if (!block.func_200132_m() && block.func_204520_s().func_206888_e() && block != ICE) continue;
                        world.func_180501_a(blockpos, BLUE_ICE, 2);
                    }
                }
                ++width;
            }
            for (int x = -width; x <= width; ++x) {
                for (int z = -width; z <= width; ++z) {
                    BlockPos blockpos;
                    BlockState block;
                    if (x * x + z * z > width * width || (block = world.func_180495_p(blockpos = new BlockPos(x + blockpos$Mutable.func_177958_n(), blockpos$Mutable.func_177956_o() + 1, z + blockpos$Mutable.func_177952_p()))) != SNOW) continue;
                    world.func_180501_a(blockpos, AIR, 2);
                }
            }
        }
        return true;
    }
}

