/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.feature;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.BlockBlobConfig;
import net.minecraft.world.gen.feature.Feature;
import net.telepathicgrunt.ultraamplified.UltraAmplified;

public class BoulderGiantStackable
extends Feature<BlockBlobConfig> {
    private static final int startRadius = 4;
    protected static final Set<BlockState> acceptableBlocks = ImmutableSet.of((Object)Blocks.field_150346_d.func_176223_P(), (Object)Blocks.field_196658_i.func_176223_P(), (Object)Blocks.field_185774_da.func_176223_P(), (Object)Blocks.field_196661_l.func_176223_P(), (Object)Blocks.field_150341_Y.func_176223_P(), (Object)Blocks.field_150347_e.func_176223_P(), (Object[])new BlockState[]{Blocks.field_196656_g.func_176223_P(), Blocks.field_150365_q.func_176223_P(), Blocks.field_150366_p.func_176223_P(), Blocks.field_150482_ag.func_176223_P()});

    public BoulderGiantStackable(Function<Dynamic<?>, ? extends BlockBlobConfig> configFactory) {
        super(configFactory);
    }

    public boolean place(IWorld world, ChunkGenerator<? extends GenerationSettings> p_212245_2_, Random rand, BlockPos position, BlockBlobConfig p_212245_5_) {
        BlockState block;
        BlockPos.Mutable blockpos$Mutable = new BlockPos.Mutable(position.func_177958_n() + rand.nextInt(3), 249, position.func_177952_p() + rand.nextInt(3));
        for (int boulderSpawned = 0; boulderSpawned < 15 && !acceptableBlocks.contains(block = world.func_180495_p((BlockPos)blockpos$Mutable)); ++boulderSpawned) {
            while (blockpos$Mutable.func_177956_o() > 7) {
                blockpos$Mutable.func_189536_c(Direction.DOWN);
                if (blockpos$Mutable.func_177956_o() <= 8 || blockpos$Mutable.func_177956_o() >= 250) {
                    return false;
                }
                block = world.func_180495_p((BlockPos)blockpos$Mutable);
                if (!acceptableBlocks.contains(block)) continue;
            }
            blockpos$Mutable.func_189536_c(Direction.UP);
            for (int currentCount = 0; currentCount < 3; ++currentCount) {
                int x = 4 + rand.nextInt(2);
                int y = 4 + rand.nextInt(2);
                int z = 4 + rand.nextInt(2);
                float calculatedDistance = (float)(x + y + z) * 0.333f + 0.5f;
                for (BlockPos blockpos : BlockPos.func_218278_a((BlockPos)blockpos$Mutable.func_177982_a(-x, -y, -z), (BlockPos)blockpos$Mutable.func_177982_a(x, y, z))) {
                    if (!(blockpos.func_177951_i((Vec3i)blockpos$Mutable) <= (double)(calculatedDistance * calculatedDistance))) continue;
                    int randomChance = rand.nextInt(1400);
                    if (UltraAmplified.UAConfig.diamondOreSpawnrate.get() != 0 && randomChance <= 1) {
                        world.func_180501_a(blockpos, Blocks.field_150482_ag.func_176223_P(), 4);
                        continue;
                    }
                    if (UltraAmplified.UAConfig.ironOreSpawnrate.get() != 0 && randomChance <= 50) {
                        world.func_180501_a(blockpos, Blocks.field_150366_p.func_176223_P(), 4);
                        continue;
                    }
                    if (UltraAmplified.UAConfig.coalOreSpawnrate.get() != 0 && randomChance <= 130) {
                        world.func_180501_a(blockpos, Blocks.field_150365_q.func_176223_P(), 4);
                        continue;
                    }
                    if (randomChance <= 480) {
                        world.func_180501_a(blockpos, Blocks.field_196656_g.func_176223_P(), 4);
                        continue;
                    }
                    if (randomChance <= 750) {
                        world.func_180501_a(blockpos, Blocks.field_150347_e.func_176223_P(), 4);
                        continue;
                    }
                    world.func_180501_a(blockpos, Blocks.field_150341_Y.func_176223_P(), 4);
                }
                blockpos$Mutable.func_196234_d(-5 + rand.nextInt(4), 0 - rand.nextInt(2), -5 + rand.nextInt(4));
            }
            blockpos$Mutable.func_181079_c(position.func_177958_n() + rand.nextInt(3), 249, position.func_177952_p() + rand.nextInt(3));
        }
        return true;
    }
}

