/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.feature;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.telepathicgrunt.ultraamplified.UltraAmplified;
import net.telepathicgrunt.ultraamplified.blocks.UABlocks;
import net.telepathicgrunt.ultraamplified.world.feature.config.ColumnBlocksConfig;

public class ColumnRamp
extends Feature<ColumnBlocksConfig> {
    protected long seed;
    private final BlockState AIR = Blocks.field_150350_a.func_176223_P();
    public final Set<Block> irreplacableBlocks = ImmutableSet.of((Object)Blocks.field_226906_mb_, (Object)Blocks.field_150350_a, (Object)Blocks.field_201941_jj, (Object)Blocks.field_150420_aW, (Object)Blocks.field_150419_aX, (Object)Blocks.field_196706_do, (Object[])new Block[]{Blocks.field_150434_aF, (Block)UABlocks.CACTUSBODYBLOCKUA.get(), (Block)UABlocks.CACTUSCORNERBLOCKUA.get(), (Block)UABlocks.CACTUSMAINBLOCKUA.get()});

    public ColumnRamp(Function<Dynamic<?>, ? extends ColumnBlocksConfig> configFactory) {
        super(configFactory);
    }

    public boolean place(IWorld world, ChunkGenerator<? extends GenerationSettings> changedBlock, Random rand, BlockPos position, ColumnBlocksConfig blocksConfig) {
        int circleBounds;
        int xzDiffSquaredStretched;
        int z;
        int x;
        int y;
        int currentHeight;
        if (!UltraAmplified.UAConfig.pillarGen.get().booleanValue()) {
            return false;
        }
        BlockPos.Mutable blockpos$Mutable = new BlockPos.Mutable(position);
        int minWidth = 4;
        int ceilingHeight = currentHeight = 0;
        int bottomFloorHeight = currentHeight;
        int topFloorHeight = currentHeight;
        int heightDiff = 0;
        while (!world.func_180495_p(blockpos$Mutable.func_177981_b(currentHeight)).func_200132_m()) {
            if (blockpos$Mutable.func_177956_o() > 254) {
                return false;
            }
            blockpos$Mutable.func_189534_c(Direction.UP, 2);
        }
        ceilingHeight = blockpos$Mutable.func_177956_o();
        while (world.func_180495_p(blockpos$Mutable.func_177981_b(currentHeight)).func_200132_m()) {
            if (blockpos$Mutable.func_177956_o() > 254) {
                return false;
            }
            blockpos$Mutable.func_189536_c(Direction.UP);
        }
        topFloorHeight = blockpos$Mutable.func_177981_b(currentHeight).func_177956_o();
        if (topFloorHeight - ceilingHeight > 7 || topFloorHeight - ceilingHeight < 2) {
            return false;
        }
        blockpos$Mutable.func_189533_g((Vec3i)position);
        currentHeight = 0;
        while (!world.func_180495_p((BlockPos)blockpos$Mutable).func_200132_m()) {
            if (blockpos$Mutable.func_177956_o() < 70) {
                return false;
            }
            blockpos$Mutable.func_189534_c(Direction.DOWN, 2);
        }
        bottomFloorHeight = blockpos$Mutable.func_177956_o();
        heightDiff = ceilingHeight - bottomFloorHeight;
        if (heightDiff > 27 || heightDiff < 8) {
            return false;
        }
        float randFloat = rand.nextFloat();
        float xTurningValue = (float)Math.sin((double)randFloat * Math.PI * 2.0);
        float zTurningValue = (float)Math.cos((double)randFloat * Math.PI * 2.0);
        int widthAtHeight = this.getWidthAtHeight(0, heightDiff + 5, minWidth);
        int xPosCeiling = position.func_177958_n() + this.getOffsetAtHeight(heightDiff + 1, heightDiff, xTurningValue);
        int zPosCeiling = position.func_177952_p() + this.getOffsetAtHeight(0, heightDiff, zTurningValue);
        int xPosFloor = position.func_177958_n() - this.getOffsetAtHeight(heightDiff - 1, heightDiff, xTurningValue);
        int zPosFloor = position.func_177952_p() + this.getOffsetAtHeight(0, heightDiff, zTurningValue);
        for (int x2 = -widthAtHeight; x2 <= widthAtHeight; ++x2) {
            for (int z2 = -widthAtHeight; z2 <= widthAtHeight; ++z2) {
                if (!((double)(x2 * x2 + z2 * z2) > (double)(widthAtHeight * widthAtHeight) * 0.85) || x2 * x2 + z2 * z2 >= widthAtHeight * widthAtHeight) continue;
                BlockState block1 = world.func_180495_p((BlockPos)blockpos$Mutable.func_181079_c(xPosCeiling + x2, ceilingHeight + 2, zPosCeiling + z2));
                BlockState block2 = world.func_180495_p((BlockPos)blockpos$Mutable.func_181079_c(xPosFloor + x2, bottomFloorHeight - 2, zPosFloor + z2));
                if (block1.func_200132_m() && block2.func_200132_m()) continue;
                return false;
            }
        }
        int xOffset = 0;
        int zOffset = 0;
        int xDiff = 0;
        int zDiff = 0;
        for (y = -2; y <= heightDiff + 3; ++y) {
            widthAtHeight = this.getWidthAtHeight(y, heightDiff + 2, minWidth);
            if (heightDiff < 16) {
                xOffset = (int)((float)this.getOffsetAtHeight(y, heightDiff, xTurningValue) - Math.signum(this.getOffsetAtHeight(y, heightDiff, xTurningValue) / 2) * 2.0f);
                zOffset = (int)((float)this.getOffsetAtHeight(y, heightDiff, zTurningValue) - Math.signum(this.getOffsetAtHeight(y, heightDiff, zTurningValue) / 2) * 2.0f);
            } else if (heightDiff < 21) {
                xOffset = (int)((float)this.getOffsetAtHeight(y, heightDiff, xTurningValue) - Math.signum(this.getOffsetAtHeight(y, heightDiff, xTurningValue) / 3) * 4.0f);
                zOffset = (int)((float)this.getOffsetAtHeight(y, heightDiff, zTurningValue) - Math.signum(this.getOffsetAtHeight(y, heightDiff, zTurningValue) / 3) * 4.0f);
            } else {
                xOffset = (int)((float)this.getOffsetAtHeight(y, heightDiff, xTurningValue) - Math.signum(this.getOffsetAtHeight(y, heightDiff, xTurningValue) / 3) * 6.0f);
                zOffset = (int)((float)this.getOffsetAtHeight(y, heightDiff, zTurningValue) - Math.signum(this.getOffsetAtHeight(y, heightDiff, zTurningValue) / 3) * 6.0f);
            }
            for (x = position.func_177958_n() - widthAtHeight - 1; x <= position.func_177958_n() + widthAtHeight + 1; ++x) {
                for (z = position.func_177952_p() - widthAtHeight - 1; z <= position.func_177952_p() + widthAtHeight + 1; ++z) {
                    BlockState block;
                    xDiff = x - position.func_177958_n();
                    zDiff = z - position.func_177952_p();
                    blockpos$Mutable.func_181079_c(x + xOffset, y + bottomFloorHeight + 3, z + zOffset);
                    xzDiffSquaredStretched = xDiff * xDiff + zDiff * zDiff;
                    circleBounds = (int)((float)((widthAtHeight - 1) * (widthAtHeight - 1)) - 0.5f);
                    if (y > heightDiff) {
                        circleBounds = (int)((float)circleBounds * (0.6f / (float)(y - heightDiff)));
                    }
                    if ((block = world.func_180495_p((BlockPos)blockpos$Mutable)).func_203425_a(BlockTags.field_206952_E) || block.func_203425_a(BlockTags.field_200031_h) || this.irreplacableBlocks.contains(block.func_177230_c()) || xzDiffSquaredStretched > circleBounds) continue;
                    world.func_180501_a((BlockPos)blockpos$Mutable, this.AIR, 2);
                    BlockState blockBelowAir = world.func_180495_p(blockpos$Mutable.func_177977_b());
                    BlockState blockBelowBelowAir = world.func_180495_p(blockpos$Mutable.func_177979_c(2));
                    if (!blockBelowAir.func_200132_m()) continue;
                    if (blocksConfig.topBlock.func_185904_a() == Material.field_151595_p && blockBelowBelowAir.func_185904_a() == Material.field_151579_a) {
                        world.func_180501_a(blockpos$Mutable.func_177977_b(), blocksConfig.middleBlock, 2);
                        continue;
                    }
                    world.func_180501_a(blockpos$Mutable.func_177977_b(), blocksConfig.topBlock, 2);
                }
            }
        }
        for (y = -2; y <= heightDiff + 4; ++y) {
            widthAtHeight = this.getWidthAtHeight(y, heightDiff + 5, minWidth);
            xOffset = this.getOffsetAtHeight(y, heightDiff, xTurningValue);
            zOffset = this.getOffsetAtHeight(y, heightDiff, zTurningValue);
            for (x = position.func_177958_n() - widthAtHeight - 1; x <= position.func_177958_n() + widthAtHeight + 1; ++x) {
                for (z = position.func_177952_p() - widthAtHeight - 1; z <= position.func_177952_p() + widthAtHeight + 1; ++z) {
                    xDiff = x - position.func_177958_n();
                    zDiff = z - position.func_177952_p();
                    blockpos$Mutable.func_181079_c(x + xOffset, y + bottomFloorHeight, z + zOffset);
                    xzDiffSquaredStretched = xDiff * xDiff + zDiff * zDiff;
                    circleBounds = (int)((float)((widthAtHeight - 1) * (widthAtHeight - 1)) - 0.5f);
                    if (y > heightDiff - 3) {
                        circleBounds = (int)((float)circleBounds * (0.8f / (float)(y - (heightDiff - 3))));
                    }
                    if (y <= heightDiff && xzDiffSquaredStretched <= circleBounds) {
                        if (world.func_180495_p((BlockPos)blockpos$Mutable).func_200132_m()) continue;
                        world.func_180501_a((BlockPos)blockpos$Mutable, blocksConfig.insideBlock, 2);
                        continue;
                    }
                    if (y <= heightDiff && xzDiffSquaredStretched > (widthAtHeight + 3) * (widthAtHeight + 3)) continue;
                    for (int downward = 0; downward < 6 && y - downward >= -3; ++downward) {
                        BlockState block = world.func_180495_p(blockpos$Mutable.func_177979_c(downward));
                        BlockState blockBelow = world.func_180495_p(blockpos$Mutable.func_177979_c(downward + 1));
                        if (block != blocksConfig.insideBlock) continue;
                        if (downward == 1 && (blocksConfig.topBlock.func_185904_a() != Material.field_151595_p || blockBelow.func_185904_a() != Material.field_151579_a)) {
                            world.func_180501_a(blockpos$Mutable.func_177979_c(downward), blocksConfig.topBlock, 2);
                            continue;
                        }
                        world.func_180501_a(blockpos$Mutable.func_177979_c(downward), blocksConfig.middleBlock, 2);
                    }
                }
            }
        }
        return true;
    }

    private int getWidthAtHeight(int y, int heightDiff, int thinnestWidth) {
        float yFromCenter = (float)y - (float)heightDiff * 0.5f;
        yFromCenter = Math.abs(yFromCenter * 0.4f) + 3.0f;
        return thinnestWidth + (int)(yFromCenter * yFromCenter / 8.0f);
    }

    private int getOffsetAtHeight(int y, int heightDiff, float turningValue) {
        float yFromCenter = (float)y - (float)heightDiff / 2.0f;
        return (int)(turningValue * yFromCenter);
    }
}

