/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.feature;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;
import net.telepathicgrunt.ultraamplified.UltraAmplified;
import net.telepathicgrunt.ultraamplified.world.generation.BiomeGenHelper;

public class ContainLiquidForOceans
extends Feature<NoFeatureConfig> {
    private static final BlockState ICE = Blocks.field_150432_aD.func_176223_P();
    private static final BlockState SNOW = Blocks.field_150433_aE.func_176223_P();
    private static final BlockState[] DEAD_CORAL_ARRAY = new BlockState[]{Blocks.field_204408_jI.func_176223_P(), Blocks.field_204405_jF.func_176223_P(), Blocks.field_204406_jG.func_176223_P(), Blocks.field_204407_jH.func_176223_P(), Blocks.field_204404_jE.func_176223_P()};

    public ContainLiquidForOceans(Function<Dynamic<?>, ? extends NoFeatureConfig> configFactory) {
        super(configFactory);
    }

    public boolean place(IWorld world, ChunkGenerator<? extends GenerationSettings> chunkSettings, Random random, BlockPos position, NoFeatureConfig configBlock) {
        Biome oceanBiome = this.getOceanInChunk(world, position);
        if (oceanBiome == null) {
            return false;
        }
        BlockPos.Mutable blockpos$Mutable = new BlockPos.Mutable(position.func_177958_n(), 0, position.func_177952_p());
        BlockPos.Mutable blockpos$MutableAbove = new BlockPos.Mutable((BlockPos)blockpos$Mutable);
        for (int x = 0; x < 16; ++x) {
            block1: for (int z = 0; z < 16; ++z) {
                boolean useCoralTop = oceanBiome.func_203944_q().func_204108_a() == DEAD_CORAL_ARRAY[0];
                boolean useCoralBottom = oceanBiome.func_203944_q().func_204108_a() == DEAD_CORAL_ARRAY[0];
                blockpos$Mutable.func_181079_c(position.func_177958_n() + x, 256, position.func_177952_p() + z);
                while (blockpos$Mutable.func_177956_o() >= UltraAmplified.UAConfig.seaLevel.get()) {
                    BlockState blockAbove;
                    BlockState currentblock = world.func_180495_p((BlockPos)blockpos$Mutable);
                    while (currentblock.func_204520_s().func_206888_e() && blockpos$Mutable.func_177956_o() >= UltraAmplified.UAConfig.seaLevel.get()) {
                        blockpos$Mutable.func_189536_c(Direction.DOWN);
                        currentblock = world.func_180495_p((BlockPos)blockpos$Mutable);
                    }
                    if (blockpos$Mutable.func_177956_o() < UltraAmplified.UAConfig.seaLevel.get()) continue block1;
                    boolean containedFlag = true;
                    for (Direction face : Direction.Plane.HORIZONTAL) {
                        currentblock = world.func_180495_p(blockpos$Mutable.func_177972_a(face));
                        if ((currentblock.func_200132_m() || !currentblock.func_204520_s().func_206888_e() || currentblock == ICE) && currentblock != SNOW) continue;
                        containedFlag = false;
                        break;
                    }
                    blockpos$MutableAbove.func_189533_g((Vec3i)blockpos$Mutable).func_189536_c(Direction.UP);
                    if (containedFlag) {
                        blockAbove = world.func_180495_p((BlockPos)blockpos$MutableAbove);
                        if (blockAbove == oceanBiome.func_203944_q().func_204109_b()) {
                            if (useCoralBottom) {
                                world.func_180501_a((BlockPos)blockpos$MutableAbove, DEAD_CORAL_ARRAY[random.nextInt(DEAD_CORAL_ARRAY.length)], 2);
                            } else {
                                world.func_180501_a((BlockPos)blockpos$MutableAbove, ((SurfaceBuilderConfig)oceanBiome.func_203944_q()).func_204110_c(), 2);
                            }
                        }
                    } else if (blockpos$Mutable.func_177956_o() < 256) {
                        blockAbove = world.func_180495_p((BlockPos)blockpos$MutableAbove);
                        if (blockAbove.func_200132_m() || !blockAbove.func_204520_s().func_206888_e()) {
                            world.func_180501_a((BlockPos)blockpos$Mutable, oceanBiome.func_203944_q().func_204109_b(), 2);
                        } else if (useCoralTop) {
                            world.func_180501_a((BlockPos)blockpos$Mutable, DEAD_CORAL_ARRAY[random.nextInt(DEAD_CORAL_ARRAY.length)], 2);
                        } else {
                            world.func_180501_a((BlockPos)blockpos$Mutable, oceanBiome.func_203944_q().func_204108_a(), 2);
                        }
                    } else if (useCoralTop) {
                        world.func_180501_a((BlockPos)blockpos$Mutable, DEAD_CORAL_ARRAY[random.nextInt(DEAD_CORAL_ARRAY.length)], 2);
                    } else {
                        world.func_180501_a((BlockPos)blockpos$Mutable, oceanBiome.func_203944_q().func_204108_a(), 2);
                    }
                    blockpos$Mutable.func_189536_c(Direction.DOWN);
                }
            }
        }
        return true;
    }

    private Biome getOceanInChunk(IWorld world, BlockPos originalPosition) {
        Biome biomeAtLocation = null;
        BlockPos.Mutable mutableBlockPos = new BlockPos.Mutable();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                if (x != 0 && x != 16 && z != 0 && z != 16) continue;
                mutableBlockPos.func_181079_c(originalPosition.func_177958_n() + x, 0, originalPosition.func_177952_p() + z);
                biomeAtLocation = world.func_226691_t_((BlockPos)mutableBlockPos);
                if (!BiomeGenHelper.isOcean(biomeAtLocation)) continue;
                return biomeAtLocation;
            }
        }
        return null;
    }
}

