/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.feature;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.VineBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityType;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.storage.loot.LootTables;
import net.telepathicgrunt.ultraamplified.world.feature.UAFeatures;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DungeonJungle
extends Feature<NoFeatureConfig> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final BlockState CAVE_AIR = Blocks.field_201941_jj.func_176223_P();
    private static final BlockState LEAVES = (BlockState)Blocks.field_196648_Z.func_176223_P().func_206870_a((IProperty)LeavesBlock.field_208494_a, (Comparable)Integer.valueOf(1));
    private static final BlockState LOGS = Blocks.field_196620_N.func_176223_P();
    private static final BlockState SIDEWAYS_LOGS = (BlockState)Blocks.field_196620_N.func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208148_A, (Comparable)Direction.Axis.X);
    private static final BlockState PLANKS = Blocks.field_196668_q.func_176223_P();

    public DungeonJungle(Function<Dynamic<?>, ? extends NoFeatureConfig> configFactory) {
        super(configFactory);
    }

    public boolean place(IWorld world, ChunkGenerator<? extends GenerationSettings> chunkGenerator, Random rand, BlockPos position, NoFeatureConfig p_212245_5_) {
        int z;
        int y;
        int x;
        int randXRange = rand.nextInt(2) + 2;
        int xMin = -randXRange - 1;
        int xMax = randXRange + 1;
        int randZRange = rand.nextInt(2) + 2;
        int zMin = -randZRange - 1;
        int zMax = randZRange + 1;
        int validOpenings = 0;
        int ceilingOpenings = 0;
        BlockPos.Mutable blockpos$Mutable = new BlockPos.Mutable(position);
        for (x = xMin; x <= xMax; ++x) {
            for (y = -1; y <= 4; ++y) {
                for (z = zMin; z <= zMax; ++z) {
                    blockpos$Mutable.func_189533_g((Vec3i)position).func_196234_d(x, y, z);
                    Material material = world.func_180495_p((BlockPos)blockpos$Mutable).func_185904_a();
                    boolean flag = material.func_76220_a();
                    if (y == -1 && !flag) {
                        return false;
                    }
                    if (y == 4 && !flag) {
                        ++ceilingOpenings;
                    }
                    if (x != xMin && x != xMax && z != zMin && z != zMax || y != 0 || !world.func_175623_d((BlockPos)blockpos$Mutable) || !world.func_175623_d(blockpos$Mutable.func_177984_a())) continue;
                    ++validOpenings;
                }
            }
        }
        if (validOpenings >= 1 && validOpenings <= 14 && ceilingOpenings < 14) {
            for (x = xMin; x <= xMax; ++x) {
                for (y = 4; y >= -1; --y) {
                    for (z = zMin; z <= zMax; ++z) {
                        blockpos$Mutable.func_189533_g((Vec3i)position).func_196234_d(x, y, z);
                        if (y == 4) {
                            if (rand.nextInt(3) == 0) {
                                world.func_180501_a((BlockPos)blockpos$Mutable, SIDEWAYS_LOGS, 2);
                                continue;
                            }
                            world.func_180501_a((BlockPos)blockpos$Mutable, LEAVES, 2);
                            continue;
                        }
                        if (x != xMin && y != -1 && z != zMin && x != xMax && y != 4 && z != zMax) {
                            if (world.func_180495_p((BlockPos)blockpos$Mutable).func_177230_c() == Blocks.field_150486_ae || world.func_180495_p((BlockPos)blockpos$Mutable).func_177230_c() == Blocks.field_150474_ac) continue;
                            world.func_180501_a((BlockPos)blockpos$Mutable, CAVE_AIR, 2);
                            continue;
                        }
                        if (blockpos$Mutable.func_177956_o() >= 0 && !world.func_180495_p(blockpos$Mutable.func_177977_b()).func_185904_a().func_76220_a()) {
                            world.func_180501_a((BlockPos)blockpos$Mutable, CAVE_AIR, 2);
                            continue;
                        }
                        if (!world.func_180495_p((BlockPos)blockpos$Mutable).func_185904_a().func_76220_a() || world.func_180495_p((BlockPos)blockpos$Mutable).func_177230_c() == Blocks.field_150486_ae || world.func_180495_p((BlockPos)blockpos$Mutable).func_177230_c() == Blocks.field_150474_ac) continue;
                        if (y == -1 && rand.nextInt(5) != 0) {
                            world.func_180501_a((BlockPos)blockpos$Mutable, PLANKS, 2);
                            continue;
                        }
                        if (rand.nextInt(3) == 0) {
                            world.func_180501_a((BlockPos)blockpos$Mutable, LOGS, 2);
                            continue;
                        }
                        world.func_180501_a((BlockPos)blockpos$Mutable, LEAVES, 2);
                    }
                }
            }
            for (x = xMin + 1; x <= xMax - 1; ++x) {
                block7: for (int z2 = zMin + 1; z2 <= zMax - 1; ++z2) {
                    Direction facing = Direction.Plane.HORIZONTAL.func_179518_a(rand);
                    if (rand.nextInt(3) != 0) continue;
                    for (int y2 = 3; y2 >= 0; --y2) {
                        blockpos$Mutable.func_189533_g((Vec3i)position).func_196234_d(x, y2, z2);
                        world.func_180501_a((BlockPos)blockpos$Mutable, (BlockState)Blocks.field_150395_bd.func_176223_P().func_206870_a((IProperty)VineBlock.field_196546_A.get(facing), (Comparable)Boolean.valueOf(true)), 2);
                        if (rand.nextInt(3) == 0) continue block7;
                    }
                }
            }
            block9: for (int l3 = 0; l3 < 2; ++l3) {
                for (int j4 = 0; j4 < 3; ++j4) {
                    int x2 = position.func_177958_n() + rand.nextInt(randXRange * 2 + 1) - randXRange;
                    int y3 = position.func_177956_o();
                    int z3 = position.func_177952_p() + rand.nextInt(randZRange * 2 + 1) - randZRange;
                    blockpos$Mutable.func_181079_c(x2, y3, z3);
                    if (!world.func_175623_d((BlockPos)blockpos$Mutable)) continue;
                    int j3 = 0;
                    for (Direction Direction2 : Direction.Plane.HORIZONTAL) {
                        if (!world.func_180495_p(blockpos$Mutable.func_177972_a(Direction2)).func_185904_a().func_76220_a()) continue;
                        ++j3;
                    }
                    if (j3 != true) continue;
                    world.func_180501_a((BlockPos)blockpos$Mutable, StructurePiece.func_197528_a((IBlockReader)world, (BlockPos)blockpos$Mutable, (BlockState)Blocks.field_150486_ae.func_176223_P()), 2);
                    LockableLootTileEntity.func_195479_a((IBlockReader)world, (Random)rand, (BlockPos)blockpos$Mutable, (ResourceLocation)LootTables.field_186422_d);
                    continue block9;
                }
            }
            world.func_180501_a(position, Blocks.field_150350_a.func_176223_P(), 2);
            world.func_180501_a(position, Blocks.field_150474_ac.func_176223_P(), 2);
            TileEntity tileentity = world.func_175625_s(position);
            if (tileentity instanceof MobSpawnerTileEntity) {
                ((MobSpawnerTileEntity)tileentity).func_145881_a().func_200876_a(this.pickMobSpawner(world, rand));
            } else {
                LOGGER.error("Failed to fetch mob spawner entity at ({}, {}, {})", new Object[]{position.func_177958_n(), position.func_177956_o(), position.func_177952_p()});
            }
            return true;
        }
        return false;
    }

    private EntityType<?> pickMobSpawner(IWorld world, Random rand) {
        int roll = rand.nextInt(100);
        if (roll < 73) {
            return UAFeatures.pickRandomDungeonMob(rand);
        }
        if (roll < 98) {
            return EntityType.field_200783_W;
        }
        if (roll == 98) {
            return EntityType.field_200797_k;
        }
        return EntityType.field_200795_i;
    }
}

