/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.feature;

import com.mojang.datafixers.Dynamic;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.placement.CountConfig;
import net.telepathicgrunt.ultraamplified.blocks.UABlocks;

public class GlowPatch
extends Feature<CountConfig> {
    private static Map<BlockState, BlockState> GLOWBLOCKMAP;

    public static void setFillerMap() {
        if (GLOWBLOCKMAP == null) {
            GLOWBLOCKMAP = new HashMap<BlockState, BlockState>();
            GLOWBLOCKMAP.put(Blocks.field_150346_d.func_176223_P(), ((Block)UABlocks.GLOWDIRT.get()).func_176223_P());
            GLOWBLOCKMAP.put(Blocks.field_196660_k.func_176223_P(), ((Block)UABlocks.COARSE_GLOWDIRT.get()).func_176223_P());
            GLOWBLOCKMAP.put(Blocks.field_196658_i.func_176223_P(), ((Block)UABlocks.GLOWGRASS_BLOCK.get()).func_176223_P());
            GLOWBLOCKMAP.put(Blocks.field_150391_bh.func_176223_P(), ((Block)UABlocks.GLOWMYCELIUM.get()).func_176223_P());
            GLOWBLOCKMAP.put(Blocks.field_150348_b.func_176223_P(), ((Block)UABlocks.GLOWSTONE_ORE.get()).func_176223_P());
            GLOWBLOCKMAP.put(Blocks.field_196661_l.func_176223_P(), ((Block)UABlocks.GLOWPODZOL.get()).func_176223_P());
            GLOWBLOCKMAP.put(Blocks.field_150354_m.func_176223_P(), ((Block)UABlocks.GLOWSAND.get()).func_176223_P());
            GLOWBLOCKMAP.put(Blocks.field_196611_F.func_176223_P(), ((Block)UABlocks.REDGLOWSAND.get()).func_176223_P());
        }
    }

    public GlowPatch(Function<Dynamic<?>, ? extends CountConfig> configFactory) {
        super(configFactory);
    }

    public boolean place(IWorld world, ChunkGenerator<? extends GenerationSettings> chunkSettings, Random rand, BlockPos position, CountConfig countConfig) {
        BlockPos.Mutable blockpos$Mutable = new BlockPos.Mutable(position);
        for (int attempts = 0; attempts < countConfig.field_204915_a; ++attempts) {
            int gausX = (int)Math.max(Math.min(rand.nextGaussian() * 3.0, 16.0), -16.0);
            int gausY = rand.nextInt(4) - rand.nextInt(4);
            int gausZ = (int)Math.max(Math.min(rand.nextGaussian() * 3.0, 16.0), -16.0);
            blockpos$Mutable.func_189533_g((Vec3i)position).func_196234_d(gausX, gausY, gausZ);
            BlockState chosenBlock = world.func_180495_p((BlockPos)blockpos$Mutable);
            BlockState chosenAboveBlock = world.func_180495_p((BlockPos)blockpos$Mutable.func_189536_c(Direction.UP));
            if (chosenBlock.func_185904_a() == Material.field_151579_a) continue;
            if (chosenBlock.func_177230_c() == Blocks.field_150348_b) {
                world.func_180501_a((BlockPos)blockpos$Mutable.func_189536_c(Direction.DOWN), GLOWBLOCKMAP.get(chosenBlock), 2);
                continue;
            }
            if (!GLOWBLOCKMAP.containsKey(chosenBlock) || chosenAboveBlock.func_185904_a() != Material.field_151579_a) continue;
            world.func_180501_a((BlockPos)blockpos$Mutable.func_189536_c(Direction.DOWN), GLOWBLOCKMAP.get(chosenBlock), 2);
        }
        return true;
    }
}

