/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.feature;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.BlockStateFeatureConfig;
import net.minecraft.world.gen.feature.IcebergFeature;

public class Iceberg
extends IcebergFeature {
    private static final BlockState PACKED_ICE = Blocks.field_150403_cj.func_176223_P();
    private static final BlockState AIR = Blocks.field_150350_a.func_176223_P();
    private static final BlockState WATER = Blocks.field_150355_j.func_176223_P();
    private static final BlockState STONE = Blocks.field_150348_b.func_176223_P();
    private static final BlockState SNOW_BLOCK = Blocks.field_196604_cC.func_176223_P();

    public Iceberg(Function<Dynamic<?>, ? extends BlockStateFeatureConfig> configFactory) {
        super(configFactory);
    }

    public boolean func_212245_a(IWorld world, ChunkGenerator<? extends GenerationSettings> chunkSettings, Random random, BlockPos position, BlockStateFeatureConfig icebergConfig) {
        boolean flag2;
        int y;
        int z;
        int x;
        int upperHeight;
        boolean flag = random.nextDouble() > 0.7;
        BlockState iblockstate = icebergConfig.field_227270_a_;
        double d0 = random.nextDouble() * 2.0 * Math.PI;
        int i = 11 - random.nextInt(5);
        int j = 3 + random.nextInt(3);
        boolean flag1 = random.nextDouble() > 0.7;
        int n = upperHeight = flag1 ? random.nextInt(6) + 6 : random.nextInt(15) + 3;
        if (!flag1 && random.nextDouble() > 0.9) {
            upperHeight += random.nextInt(19) + 7;
        }
        int downHeight = Math.min(upperHeight + random.nextInt(11), 18);
        int maxheight = Math.min(upperHeight + random.nextInt(7) - random.nextInt(5), 11);
        int radius = flag1 ? i : 11;
        for (x = -radius; x < radius; ++x) {
            for (z = -radius; z < radius; ++z) {
                for (y = 0; y < upperHeight; ++y) {
                    int k2;
                    int n2 = k2 = flag1 ? this.func_205178_b(y, upperHeight, maxheight) : this.func_205183_a(random, y, upperHeight, maxheight);
                    if (!flag1 && x >= k2) continue;
                    this.func_205181_a(world, random, position, upperHeight, x, y, z, k2, radius, flag1, j, d0, flag, iblockstate);
                }
            }
        }
        this.func_205186_a(world, position, maxheight, upperHeight, flag1, i);
        for (x = -radius; x < radius; ++x) {
            for (z = -radius; z < radius; ++z) {
                for (y = -1; y > -downHeight; --y) {
                    int l3 = flag1 ? MathHelper.func_76123_f((float)((float)radius * (1.0f - (float)Math.pow(y, 2.0) / ((float)downHeight * 8.0f)))) : radius;
                    int l2 = this.func_205187_b(random, -y, downHeight, maxheight);
                    if (x >= l2) continue;
                    this.func_205181_a(world, random, position, downHeight, x, y, z, l2, l3, flag1, j, d0, flag, iblockstate);
                }
            }
        }
        boolean bl = flag1 ? random.nextDouble() > 0.1 : (flag2 = random.nextDouble() > 0.7);
        if (flag2) {
            this.func_205184_a(random, world, maxheight, upperHeight, position, flag1, i, d0, j);
        }
        return true;
    }

    private void func_205184_a(Random random, IWorld world, int maxheight, int height, BlockPos position, boolean flag, int int1, double double1, int int2) {
        int x = random.nextBoolean() ? -1 : 1;
        int z = random.nextBoolean() ? -1 : 1;
        int randomHeightBasedMultiplier = random.nextInt(Math.max(maxheight / 2 - 2, 1));
        if (random.nextBoolean()) {
            randomHeightBasedMultiplier = maxheight / 2 + 1 - random.nextInt(Math.max(maxheight - maxheight / 2 - 1, 1));
        }
        int l = random.nextInt(Math.max(maxheight / 2 - 2, 1));
        if (random.nextBoolean()) {
            l = maxheight / 2 + 1 - random.nextInt(Math.max(maxheight - maxheight / 2 - 1, 1));
        }
        if (flag) {
            randomHeightBasedMultiplier = l = random.nextInt(Math.max(int1 - 5, 1));
        }
        BlockPos blockpos = new BlockPos(x * randomHeightBasedMultiplier, 0, z * l);
        double double2 = flag ? double1 + 1.5707963267948966 : random.nextDouble() * 2.0 * Math.PI;
        for (int i1 = 0; i1 < height - 3; ++i1) {
            int j1 = this.func_205183_a(random, i1, height, maxheight);
            this.func_205174_a(j1, i1, position, world, false, double2, blockpos, int1, int2);
        }
        for (int belowCenterY = -1; belowCenterY > -height + random.nextInt(5); --belowCenterY) {
            int randomY = this.func_205187_b(random, -belowCenterY, height, maxheight);
            this.func_205174_a(randomY, belowCenterY, position, world, true, double2, blockpos, int1, int2);
        }
    }

    private void func_205174_a(int randomY, int belowCenterY, BlockPos position, IWorld world, boolean placeWater, double double1, BlockPos pos2, int int1, int int2) {
        int radius = randomY + 1 + int1 / 3;
        int int3 = Math.min(randomY - 3, 3) + int2 / 2 - 1;
        BlockPos.Mutable blockpos$Mutable = new BlockPos.Mutable(position);
        for (int x = -radius; x < radius; ++x) {
            for (int z = -radius; z < radius; ++z) {
                double d0 = this.func_205180_a(x, z, pos2, radius, int3, double1);
                if (!(d0 < 0.0)) continue;
                blockpos$Mutable.func_189533_g((Vec3i)position).func_196234_d(x, belowCenterY, z);
                Block block = world.func_180495_p((BlockPos)blockpos$Mutable).func_177230_c();
                if (!this.func_205179_a(block) && block != Blocks.field_196604_cC) continue;
                if (placeWater) {
                    world.func_180501_a((BlockPos)blockpos$Mutable, this.appropriateBlockForNeighbors(world, position), 3);
                    continue;
                }
                this.func_202278_a((IWorldWriter)world, (BlockPos)blockpos$Mutable, this.appropriateBlockForNeighbors(world, position));
                this.removeSnowLayer(world, blockpos$Mutable);
            }
        }
    }

    private void removeSnowLayer(IWorld world, BlockPos.Mutable mutableBlockPos) {
        mutableBlockPos.func_189536_c(Direction.UP);
        if (world.func_180495_p((BlockPos)mutableBlockPos).func_177230_c() == Blocks.field_150433_aE) {
            this.func_202278_a((IWorldWriter)world, (BlockPos)mutableBlockPos, this.appropriateBlockForNeighbors(world, mutableBlockPos.func_177977_b()));
        }
    }

    private void func_205181_a(IWorld world, Random random, BlockPos position, int maxHeight, int xPos, int yPos, int zPos, int int1, int int2, boolean flag1, int int3, double double1, boolean flag2, BlockState defaultState) {
        double d0;
        double d = d0 = flag1 ? this.func_205180_a(xPos, zPos, BlockPos.field_177992_a, int2, this.func_205176_a(yPos, maxHeight, int3), double1) : this.func_205177_a(xPos, zPos, BlockPos.field_177992_a, int1, random);
        if (d0 < 0.0) {
            double d1;
            BlockPos blockpos1 = position.func_177982_a(xPos, yPos, zPos);
            double d2 = d1 = flag1 ? -0.5 : (double)(-6 - random.nextInt(3));
            if (d0 > d1 && random.nextDouble() > 0.9) {
                return;
            }
            this.func_205175_a(blockpos1, world, random, maxHeight - yPos, maxHeight, flag1, flag2, defaultState);
        }
    }

    private void func_205175_a(BlockPos position, IWorld world, Random random, int minHeight, int maxHeight, boolean flag1, boolean flag2, BlockState defaultState) {
        BlockState iblockstate = world.func_180495_p(position);
        Block block = iblockstate.func_177230_c();
        if (iblockstate.func_185904_a() == Material.field_151579_a || block == Blocks.field_196604_cC || block == Blocks.field_150432_aD || block == Blocks.field_150355_j || block == Blocks.field_150353_l) {
            int i;
            boolean flag = !flag1 || random.nextDouble() > 0.05;
            int n = i = flag1 ? 3 : 2;
            if (flag2 && block != Blocks.field_150355_j || block != Blocks.field_150353_l && (double)minHeight <= (double)random.nextInt(Math.max(1, maxHeight / i)) + (double)maxHeight * 0.6 && flag) {
                this.func_202278_a((IWorldWriter)world, position, SNOW_BLOCK);
            } else {
                this.func_202278_a((IWorldWriter)world, position, defaultState);
            }
        }
    }

    private BlockState appropriateBlockForNeighbors(IWorld world, BlockPos position) {
        boolean bordersWater = false;
        boolean bordersAir = false;
        BlockState[] blockArray = new BlockState[5];
        int i = 0;
        for (Direction face : Direction.values()) {
            BlockState iblockstate;
            if (face == Direction.UP) continue;
            blockArray[i] = iblockstate = world.func_180495_p(position.func_177972_a(face));
            ++i;
            if (this.func_205179_a(iblockstate.func_177230_c())) continue;
            if (iblockstate.func_185904_a() == Material.field_151579_a) {
                bordersAir = true;
                continue;
            }
            if (iblockstate.func_204520_s().func_206888_e()) continue;
            bordersWater = true;
        }
        if (bordersWater && bordersAir) {
            return STONE;
        }
        if (bordersWater) {
            return WATER;
        }
        if (bordersAir) {
            return AIR;
        }
        return PACKED_ICE;
    }

    private void func_205186_a(IWorld world, BlockPos position, int smallRadiusIn, int height, boolean flag, int largeRadiusIn) {
        int radius = flag ? largeRadiusIn : smallRadiusIn / 2;
        BlockPos.Mutable blockpos$Mutable = new BlockPos.Mutable(position);
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                for (int y = 0; y <= height; ++y) {
                    blockpos$Mutable.func_189533_g((Vec3i)position).func_196234_d(x, y, z);
                    Block block = world.func_180495_p((BlockPos)blockpos$Mutable).func_177230_c();
                    if (!this.func_205179_a(block) && block != Blocks.field_150433_aE) continue;
                    if (this.func_205182_b((IBlockReader)world, (BlockPos)blockpos$Mutable)) {
                        this.func_202278_a((IWorldWriter)world, (BlockPos)blockpos$Mutable, this.appropriateBlockForNeighbors(world, (BlockPos)blockpos$Mutable));
                        this.func_202278_a((IWorldWriter)world, blockpos$Mutable.func_177984_a(), this.appropriateBlockForNeighbors(world, (BlockPos)blockpos$Mutable));
                        continue;
                    }
                    if (!this.func_205179_a(block)) continue;
                    Block[] ablock = new Block[]{world.func_180495_p(blockpos$Mutable.func_177976_e()).func_177230_c(), world.func_180495_p(blockpos$Mutable.func_177974_f()).func_177230_c(), world.func_180495_p(blockpos$Mutable.func_177978_c()).func_177230_c(), world.func_180495_p(blockpos$Mutable.func_177968_d()).func_177230_c()};
                    int notIceCounter = 0;
                    for (Block block1 : ablock) {
                        if (this.func_205179_a(block1)) continue;
                        ++notIceCounter;
                    }
                    if (notIceCounter < 3) continue;
                    this.func_202278_a((IWorldWriter)world, (BlockPos)blockpos$Mutable, this.appropriateBlockForNeighbors(world, (BlockPos)blockpos$Mutable));
                }
            }
        }
    }
}

